/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap.codeinspector;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.engine.abap.codeinspector.ECodeInspectorMessageType;
import org.conqat.engine.abap.codeinspector.ECodeInspectorTestType;
import org.conqat.engine.abap.codeinspector.ETestAbapNamingCodes;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class CodeInspectorUtils {
    private static final int MAX_OBJECT_NAME_LENGTH = 30;
    private static final HashSet<String> USE_SOBJ_OBJTYPES = CollectionUtils.asHashSet((Object[])new String[]{"FUGS", "LDBA"});
    private static final HashSet<String> IGNORED_OBJTYPES = CollectionUtils.asHashSet((Object[])new String[]{"STAT"});
    public static final Pattern CLASS_INCLUDE_PATTERN = Pattern.compile("^((\\w{30})|((.*?[^=])=*))(C\\w+)$");
    private static final Pattern INTERFACE_INCLUDE_PATTERN = Pattern.compile("^((\\w{30})|((.*?[^=])=*))(I\\w+)$");
    private static final Pattern FUNCTION_GROUP_INCLUDE_PATTERN = Pattern.compile("^(/[^/]+/)?(SAPL|L)(.+)[A-Z]\\d\\d$");
    private static final String DEFAULT_CI_TEST_PREFIX = "CL_CI_TEST_";

    public static UniqueAbapElementName buildAbapElementNameForCodeInspectorResult(String objType, String objName, String sobjType, String sobjName) {
        if (objType == null || IGNORED_OBJTYPES.contains(objType)) {
            return null;
        }
        if (USE_SOBJ_OBJTYPES.contains(objType)) {
            return CodeInspectorUtils.buildAbapElementNameForCodeInspectorResult((EAbapObjectType)EnumUtils.valueOf(EAbapObjectType.class, (String)sobjType), objName, sobjName);
        }
        return CodeInspectorUtils.buildAbapElementNameForCodeInspectorResult((EAbapObjectType)EnumUtils.valueOf(EAbapObjectType.class, (String)objType), objName, sobjName);
    }

    private static UniqueAbapElementName buildAbapElementNameForCodeInspectorResult(EAbapObjectType objectType, String objectName, String includeName) {
        if (objectType == null || objectName == null) {
            return null;
        }
        if (objectName.equals(includeName)) {
            return new UniqueAbapElementName(objectName, objectType);
        }
        if (CodeInspectorUtils.isIncludeOfClassOrInterface(objectType, objectName, includeName)) {
            if (CodeInspectorUtils.isClassExtrasInclude(includeName)) {
                return new UniqueAbapElementName(includeName, objectType);
            }
            return new UniqueAbapElementName(objectName, objectType);
        }
        return CodeInspectorUtils.guessUniqueObjectNameFromIncludeName(includeName);
    }

    private static boolean isIncludeOfClassOrInterface(EAbapObjectType objectType, String name, String includeName) {
        Pattern pattern = null;
        switch (objectType) {
            case CLAS: {
                pattern = CLASS_INCLUDE_PATTERN;
                break;
            }
            case INTF: {
                pattern = INTERFACE_INCLUDE_PATTERN;
                break;
            }
            default: {
                return false;
            }
        }
        Matcher m = pattern.matcher(includeName);
        if (!m.matches() || m.group(1).length() != 30) {
            return false;
        }
        return CodeInspectorUtils.extractIncludeName(m).equals(name);
    }

    private static boolean isClassExtrasInclude(String includeName) {
        Matcher m = CLASS_INCLUDE_PATTERN.matcher(includeName);
        if (!m.matches()) {
            return false;
        }
        String suffix = m.group(5);
        return suffix.startsWith("CC") || suffix.equals("CL");
    }

    private static UniqueAbapElementName guessUniqueObjectNameFromIncludeName(String includeName) {
        if (FUNCTION_GROUP_INCLUDE_PATTERN.matcher(includeName).matches()) {
            return new UniqueAbapElementName(includeName, EAbapObjectType.FUGR);
        }
        Matcher m = CLASS_INCLUDE_PATTERN.matcher(includeName);
        if (m.matches() && m.group(1).length() == 30) {
            if (CodeInspectorUtils.isClassExtrasInclude(includeName)) {
                return new UniqueAbapElementName(includeName, EAbapObjectType.CLAS);
            }
            return new UniqueAbapElementName(CodeInspectorUtils.extractIncludeName(m), EAbapObjectType.CLAS);
        }
        m = INTERFACE_INCLUDE_PATTERN.matcher(includeName);
        if (m.matches() && m.group(1).length() == 30) {
            return new UniqueAbapElementName(CodeInspectorUtils.extractIncludeName(m), EAbapObjectType.INTF);
        }
        return new UniqueAbapElementName(includeName, EAbapObjectType.PROG);
    }

    private static String extractIncludeName(Matcher matcher) {
        return matcher.group(1).replace("=", "");
    }

    public static String buildFindingsMessage(ECodeInspectorTestType testType, String messageCode, String messageTextPattern, String param1, String param2, String param3, String param4) {
        Object message = null;
        switch (testType) {
            case CL_CI_TEST_ABAP_NAMING: {
                message = CodeInspectorUtils.buildTestAbapNamingMessage(messageCode, param1);
                break;
            }
            case CL_CI_TEST_ABAP_NAMING_NEW: {
                message = CodeInspectorUtils.buildTestAbapNamingMessage(messageCode, param1);
                break;
            }
            case CL_CI_TEST_EXTENDED_CHECK: {
                message = param2;
                break;
            }
            case CL_CI_TEST_EXTENDED_CHECK_BASE: {
                message = param2;
                break;
            }
            case CL_CI_TEST_METRIC_PROC: {
                message = "Violation of " + messageCode + " (is " + param3 + ", should be max. " + param2 + ") in " + param1 + ".";
                break;
            }
            case CL_CI_TEST_SYNTAX_CHECK: {
                message = param1;
                break;
            }
            case CL_CI_TEST_VALUE_PARAMETER: {
                message = messageTextPattern + ": " + param2;
                break;
            }
        }
        if (message == null) {
            message = CodeInspectorUtils.buildDefaultFindingsMessage(messageTextPattern, param1, param2, param3, param4);
        }
        message = ((String)message).replaceAll("\\s+", " ");
        return ((String)message).trim();
    }

    private static String buildTestAbapNamingMessage(String messageCode, String param1) {
        ETestAbapNamingCodes code = (ETestAbapNamingCodes)EnumUtils.valueOf(ETestAbapNamingCodes.class, (String)messageCode);
        if (code == ETestAbapNamingCodes.SYNERR) {
            return "Syntax error: Naming analysis was cancelled.";
        }
        String identifierText = messageCode;
        if (code != null) {
            identifierText = code.text;
        }
        if ("[ERROR]".equals(identifierText)) {
            return "ERROR(" + String.valueOf((Object)code) + ") " + param1;
        }
        return param1 + " violates naming convention for " + identifierText + ".";
    }

    private static String buildDefaultFindingsMessage(String messageTextPattern, String param1, String param2, String param3, String param4) {
        if (!StringUtils.isEmpty((String)messageTextPattern)) {
            String text = messageTextPattern.replace("&1", param1);
            text = text.replace("&2", param2);
            text = text.replace("&3", param3);
            text = text.replace("&4", param4);
            return text;
        }
        StringBuilder result = new StringBuilder();
        if (!StringUtils.isEmpty((String)param1)) {
            result.append(param1).append(" ");
        }
        if (!StringUtils.isEmpty((String)param2)) {
            result.append(param2).append(" ");
        }
        if (!StringUtils.isEmpty((String)param3)) {
            result.append(param3).append(" ");
        }
        if (!StringUtils.isEmpty((String)param4)) {
            result.append(param4);
        }
        return result.toString().trim();
    }

    public static String buildRuleId(ECodeInspectorTestType testType, String testTypeNameForUnknown, String messageCode, ECodeInspectorMessageType messageType) {
        String test = testType.name();
        if (testType == ECodeInspectorTestType.UNKNOWN_TEST) {
            test = testTypeNameForUnknown;
        } else if (testType == ECodeInspectorTestType.CL_CI_TEST_EXTENDED_CHECK_BASE) {
            test = ECodeInspectorTestType.CL_CI_TEST_EXTENDED_CHECK.name();
        }
        test = StringUtils.stripPrefix((String)test, (String)DEFAULT_CI_TEST_PREFIX);
        return test + "[" + messageCode + "](" + messageType.name() + ")";
    }
}

