/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.cache;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.atteo.classindex.ClassIndex;
import org.conqat.engine.persistence.cache.StorageCacheBase;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.distribution.LocalMessageBroker;
import org.conqat.lib.commons.function.SupplierWithException;

public class StorageCacheRegistry {
    private static final List<SupplierWithException<StorageCacheBase, ReflectiveOperationException>> INDEX_CACHE_FACTORIES = new ArrayList<SupplierWithException<StorageCacheBase, ReflectiveOperationException>>();

    public static synchronized StorageCacheProvider createCacheProvider(IMessageBroker messageBroker) {
        return new StorageCacheProvider(INDEX_CACHE_FACTORIES, messageBroker);
    }

    private static StorageCacheProvider createStandaloneGlobalCacheProvider() {
        return new StorageCacheProvider(INDEX_CACHE_FACTORIES, new LocalMessageBroker());
    }

    public static synchronized StorageCacheProvider.StorageSystemCacheProvider createStandaloneCacheProvider() {
        return StorageCacheRegistry.createStandaloneGlobalCacheProvider().getCacheProvider("dummy");
    }

    static {
        Iterable storageCacheClasses = ClassIndex.getSubclasses(StorageCacheBase.class);
        for (Class storageCacheClass : storageCacheClasses) {
            if (storageCacheClass.getName().endsWith("Test")) continue;
            INDEX_CACHE_FACTORIES.add((SupplierWithException<StorageCacheBase, ReflectiveOperationException>)((SupplierWithException)() -> {
                Constructor constructor = storageCacheClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (StorageCacheBase)constructor.newInstance(new Object[0]);
            }));
        }
    }
}

