/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.TimedShallowObjectState;
import org.conqat.engine.persistence.index.keyed.query.QueryHelper;
import org.conqat.engine.persistence.index.keyed.query.engine.DescriberCompilationContext;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.IQueryPreprocessor;
import org.conqat.engine.persistence.index.keyed.query.parser.QueryParser;
import org.conqat.engine.persistence.index.keyed.query.tree.ISubQueryComputer;
import org.conqat.engine.persistence.index.keyed.query.trend.ITrendCollector;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;

public class QueryEngine {
    public static final String PARENT_FIELD_NAME = "parent";

    public static <T> List<T> select(Collection<T> objects, IKeyedObjectDescriber<T> describer, String query) throws QueryParsingException, QueryCompilationException, StorageException {
        Predicate<T> filter = QueryParser.parse(query).compile(new DescriberCompilationContext<T>(describer));
        return CollectionUtils.filter(objects, filter);
    }

    public static List<String> selectIds(IKeyedObjectIndex<?> index, String query, IQueryContext context) throws QueryCompilationException, QueryParsingException, StorageException {
        QueryHelper queryHelper = new QueryHelper(index, query, context.getPreprocessors(), null);
        List<TimedShallowObjectState> objects = queryHelper.executeQuery(context.getTimestamp());
        queryHelper.preEvaluateComputers(objects, context.getTimestamp());
        return CollectionUtils.filterAndMap(objects, queryHelper.getFrozenObjectFilter(), TimedShallowObjectState::getId);
    }

    public static <T> PairList<Long, T> selectTrend(IKeyedObjectIndex<?> index, String query, IQueryContext context, ITrendCollector<T> trendCollector) throws StorageException, QueryCompilationException, QueryParsingException {
        QueryHelper queryHelper = new QueryHelper(index, query, context.getPreprocessors(), trendCollector);
        TrendExtractionHelper trendHelper = new TrendExtractionHelper(queryHelper, context.getStartTime(), context.getEndTime(), trendCollector);
        return QueryEngine.buildTrend(context.getStartTime(), context.getEndTime(), trendCollector, trendHelper);
    }

    private static <T> @NonNull PairList<Long, T> buildTrend(long startTime, long endTime, ITrendCollector<T> trendCollector, TrendExtractionHelper trendHelper) {
        PairList trend = new PairList();
        if (startTime > 1L) {
            trend.add((Object)startTime, trendCollector.getTrendEntry());
        }
        for (long timestamp : trendHelper.getOrderedTimestamps()) {
            trendHelper.updateForTimestamp(timestamp);
            trend.add((Object)timestamp, trendCollector.getTrendEntry());
        }
        int lastIndex = trend.size() - 1;
        if (trend.size() > 0 && (Long)trend.getFirst(lastIndex) < endTime) {
            trend.add((Object)endTime, trend.getSecond(lastIndex));
        }
        return trend;
    }

    public static interface IQueryContext {
        public long getStartTime();

        public long getEndTime();

        default public long getTimestamp() {
            long end = this.getEndTime();
            long start = this.getStartTime();
            CCSMAssert.isTrue((start == end ? 1 : 0) != 0, () -> String.format("Expected \"%s\" (%d) to be the same as \"%s\" (%d)", "start", start, "end", end));
            return end;
        }

        public Collection<IQueryPreprocessor> getPreprocessors();

        public static IQueryContext ofTrend(final long startTime, final long endTime, final IQueryPreprocessor ... preprocessors) {
            CCSMAssert.isTrue((endTime >= startTime ? 1 : 0) != 0, () -> String.format("Expected \"%s\" (%d) to greater or equal to \"%s\" (%d)", "endTime", endTime, "startTime", startTime));
            return new IQueryContext(){

                @Override
                public long getStartTime() {
                    return startTime;
                }

                @Override
                public long getEndTime() {
                    return endTime;
                }

                @Override
                public Collection<IQueryPreprocessor> getPreprocessors() {
                    return Arrays.asList(preprocessors);
                }
            };
        }

        public static IQueryContext ofTimestamp(long timestamp, IQueryPreprocessor ... preprocessors) {
            return IQueryContext.ofTrend(timestamp, timestamp, preprocessors);
        }
    }

    private static class TrendExtractionHelper {
        private final List<TimedShallowObjectState> objects;
        private final Predicate<TimedShallowObjectState> filter;
        private final ITrendCollector<?> trendCollector;
        private final ListMap<Long, Integer> objectsByTimestamp = new ListMap();
        private final List<ISubQueryComputer<TimedShallowObjectState>> computers;

        private <T> TrendExtractionHelper(QueryHelper<T> queryHelper, long startTime, long endTime, ITrendCollector<?> trendCollector) throws StorageException {
            this.trendCollector = trendCollector;
            this.objects = queryHelper.executeQuery(endTime);
            this.filter = queryHelper.getFrozenObjectFilter();
            trendCollector.init(this.objects.size());
            queryHelper.preEvaluateComputers(this.objects, startTime);
            this.computers = queryHelper.getSubQueryComputers();
            ArrayList<Long> postChangeOffsets = new ArrayList<Long>(queryHelper.getPostChangeEvaluationOffsets());
            if (!postChangeOffsets.contains(0L)) {
                postChangeOffsets.add(0L);
            }
            this.initializeForStartTime(startTime, endTime, postChangeOffsets);
        }

        public List<Long> getOrderedTimestamps() {
            return CollectionUtils.sort((Collection)this.objectsByTimestamp.getKeys());
        }

        private void initializeForStartTime(long startTime, long endTime, List<Long> postChangeOffsets) {
            int i;
            for (i = 0; i < this.objects.size(); ++i) {
                this.initializeObject(i, startTime, endTime, postChangeOffsets);
            }
            if (this.objectsByTimestamp.getKeys().isEmpty() && startTime > 1L) {
                for (i = 0; i < this.objects.size(); ++i) {
                    this.objectsByTimestamp.add((Object)startTime, (Object)i);
                }
            }
        }

        private void initializeObject(int index, long startTime, long endTime, List<Long> postChangeOffsets) {
            TimedShallowObjectState object = this.objects.get(index);
            boolean selected = object.hasNonNullFrozenValue() && this.filter.test(object);
            this.trendCollector.update(object, index, selected);
            for (long timestamp : object.getTimestamps()) {
                for (Long offset : postChangeOffsets) {
                    long postTimestamp = timestamp + offset;
                    if (postTimestamp <= startTime || postTimestamp > endTime) continue;
                    this.objectsByTimestamp.add((Object)postTimestamp, (Object)index);
                }
            }
        }

        private void updateForTimestamp(long timestamp) {
            Iterator iterator = ((List)this.objectsByTimestamp.getCollection((Object)timestamp)).iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                TimedShallowObjectState object = this.objects.get(i);
                object.freezeAt(timestamp);
                for (ISubQueryComputer<TimedShallowObjectState> computer : this.computers) {
                    computer.updateState(object, timestamp);
                }
                boolean newSelected = this.filter.test(object);
                this.trendCollector.update(object, i, newSelected);
            }
        }
    }
}

