/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.BasicQueryBase;
import org.conqat.engine.persistence.index.keyed.query.tree.IAttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.ICompilationContext;
import org.conqat.engine.persistence.index.keyed.query.tree.StaticOperand;

public class EqualsQuery
extends BasicQueryBase {
    private final boolean lenient;

    public EqualsQuery(IAttributeOperand attribute, StaticOperand value) {
        this(attribute, value, false);
    }

    public EqualsQuery(IAttributeOperand attribute, StaticOperand value, boolean lenient) {
        super(attribute, value);
        this.lenient = lenient;
    }

    @Override
    protected String getReadableOperator() {
        return "=";
    }

    @Override
    public <T> Predicate<T> compile(ICompilationContext<T> context) throws QueryCompilationException {
        EKeyedObjectType type = this.attribute.getType(context);
        Object rightSideValue = this.value.convertTo(type);
        switch (type) {
            case DATE: 
            case NUMBER: 
            case STRING: {
                return this.attribute.getValueEqualsIgnoreCasePredicate(context, rightSideValue, this.lenient);
            }
            case STRING_LIST: {
                BiPredicate<Object, Object> comparator = this.getComparator(type);
                Function valueAccessor = this.attribute.getValueAccessor(context);
                return object -> comparator.test(valueAccessor.apply(object), rightSideValue);
            }
        }
        throw new QueryCompilationException("Unsupported type for equals comparison: " + String.valueOf((Object)type), type.name());
    }

    @Override
    protected BiPredicate<Object, Object> getComparator(EKeyedObjectType type) throws QueryCompilationException {
        if (type != EKeyedObjectType.STRING_LIST) {
            throw new QueryCompilationException("Unknown type: " + String.valueOf((Object)type), type.name());
        }
        return (left, right) -> EqualsQuery.compareList((List)left, (String)right, this.lenient);
    }

    private static boolean compareList(List<String> value, String comparisonValue, boolean lenient) {
        return value.stream().anyMatch(IAttributeOperand.stringComparer(comparisonValue, lenient));
    }
}

