/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.conqat.lib.commons.io.ByteArrayUtils;

public class LZ4Utils {
    private static final int SIZE_BYTES = 4;
    private static final LZ4Factory FACTORY = LZ4Factory.fastestJavaInstance();
    private static final LZ4Compressor COMPRESSOR = FACTORY.fastCompressor();
    private static final LZ4FastDecompressor DECOMPRESSOR = FACTORY.fastDecompressor();

    public static byte[] compress(byte[] data) {
        if (data == null) {
            return null;
        }
        int maxSize = COMPRESSOR.maxCompressedLength(data.length);
        byte[] temp = new byte[maxSize + 4];
        int size = COMPRESSOR.compress(data, 0, data.length, temp, 4);
        ByteArrayUtils.storeIntInStartOfArray((int)data.length, (byte[])temp);
        return Arrays.copyOfRange(temp, 0, 4 + size);
    }

    public static byte[] decompress(byte[] data) {
        if (data == null) {
            return null;
        }
        int resultSize = ByteArrayUtils.readIntFromStartOfArray((byte[])data);
        return DECOMPRESSOR.decompress(data, 4, resultSize);
    }

    public static boolean isCompressibleSize(long sizeInBytes) {
        try {
            COMPRESSOR.maxCompressedLength(Math.toIntExact(sizeInBytes));
            return true;
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            return false;
        }
    }
}

