/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai.google;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.google.GoogleAiClientBase;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.core.rest.client.Retrofit;
import java.io.IOException;
import java.util.List;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.POST;
import retrofit2.http.Path;

public class GeminiAiClient
extends GoogleAiClientBase<IGeminiAiService> {
    private static final int MAX_OUTPUT_TOKENS = 8192;
    private final String model;

    public GeminiAiClient(String model, String project, String location, String credentialsJson, double temperature, @Nullable BiConsumer<String, Long> usageReporter) throws IOException {
        super(project, location, credentialsJson, temperature, usageReporter, IGeminiAiService.class);
        this.model = model;
    }

    @Override
    public String complete(String prompt) throws ServiceCallException {
        GeminiAiConfig config = new GeminiAiConfig(this.temperature, 8192);
        GeminiAiContent content = new GeminiAiContent("USER", List.of(new GeminiAiPart(prompt)));
        List response = (List)Retrofit.executeServiceCall(((IGeminiAiService)this.ensureService()).performPrediction(this.model, new GeminiAiPredictRequest(List.of(content), config))).orElseThrow(() -> new ServiceCallException("No response returned from LLM!"));
        if (this.usageReporter != null) {
            for (GeminiAiPredictResponse responsePart : response) {
                if (responsePart.usageMetadata == null) continue;
                this.usageReporter.accept("input-tokens", Long.valueOf(responsePart.usageMetadata.promptTokenCount));
                this.usageReporter.accept("output-tokens", Long.valueOf(responsePart.usageMetadata.candidatesTokenCount));
            }
        }
        StringBuilder result = new StringBuilder();
        for (GeminiAiPredictResponse responsePart : response) {
            if (responsePart.candidates == null || responsePart.candidates.get((int)0).content == null) continue;
            responsePart.candidates.get((int)0).content.parts.forEach(part -> result.append(part.text));
        }
        return result.toString();
    }

    static interface IGeminiAiService
    extends IRetrofitApi {
        @POST(value="publishers/google/models/{model}:streamGenerateContent")
        public Call<List<GeminiAiPredictResponse>> performPrediction(@Path(value="model") String var1, @Body GeminiAiPredictRequest var2);
    }

    private record GeminiAiConfig(double temperature, int maxOutputTokens) {
    }

    private record GeminiAiContent(String role, List<GeminiAiPart> parts) {
    }

    private record GeminiAiPart(String text) {
    }

    record GeminiAiPredictRequest(List<GeminiAiContent> contents, GeminiAiConfig generationConfig) {
    }

    record GeminiAiPredictResponse(List<GeminiAiCandidate> candidates, GeminiAiMetadata usageMetadata) {
    }

    private record GeminiAiMetadata(int promptTokenCount, int candidatesTokenCount, int totalTokenCount) {
    }

    private record GeminiAiCandidate(GeminiAiContent content) {
    }
}

