/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.SerializationViews;
import org.conqat.engine.commons.util.canonical.CanonicalJson;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class AnalysisProfile
extends NamedConfigurableObjectBase {
    private static final long serialVersionUID = 1L;
    private static final String LANGUAGES_PROPERTY = "languages";
    private static final String TOOLS_PROPERTY = "tools";
    public static final String QUALITY_INDICATOR_PROPERTY = "qualityIndicators";
    public static final String INSTANCE_COMPARISON_QUALITY_INDICATOR_VIEW_PROPERTY = "qualityIndicator";
    @JsonProperty(value="languages")
    @CanonicalJson(ordering=@CanonicalJson.OrderBy(comparator=CanonicalJson.OrderBy.NaturalOrdering.class))
    private final Set<ELanguage> languages = EnumSet.noneOf(ELanguage.class);
    @JsonProperty(value="tools")
    @CanonicalJson(ordering=@CanonicalJson.OrderBy(comparator=CanonicalJson.OrderBy.NaturalOrdering.class))
    private final Set<EAnalysisTool> tools = EnumSet.noneOf(EAnalysisTool.class);
    @JsonProperty(value="qualityIndicators")
    @CanonicalJson(ordering=@CanonicalJson.OrderBy(properties={"name"}))
    private final List<QualityIndicator> qualityIndicators = new ArrayList<QualityIndicator>();
    @JsonProperty(value="description")
    private String description = "";

    @JsonCreator
    public AnalysisProfile(@JsonProperty(value="name") String name, @JsonProperty(value="languages") Set<ELanguage> languages, @JsonProperty(value="tools") Set<EAnalysisTool> tools) {
        super(name);
        this.languages.addAll(languages);
        this.tools.addAll(tools);
        this.tools.add(EAnalysisTool.TEAMSCALE);
    }

    public AnalysisProfile(String name, String description, Set<ELanguage> languages, Set<EAnalysisTool> tools) {
        this(name, languages, tools);
        this.description = description;
    }

    public UnmodifiableSet<EAnalysisTool> getTools() {
        return CollectionUtils.asUnmodifiable(this.tools);
    }

    public UnmodifiableSet<ELanguage> getLanguages() {
        return CollectionUtils.asUnmodifiable(this.languages);
    }

    public UnmodifiableList<QualityIndicator> getQualityIndicators() {
        return CollectionUtils.asUnmodifiable(this.qualityIndicators);
    }

    public @Nullable AnalysisGroup getGroup(String name) {
        for (QualityIndicator indicator : this.qualityIndicators) {
            Optional<AnalysisGroup> optionalGroup = indicator.getGroups().stream().filter(g -> g.getName().equals(name)).findFirst();
            if (!optionalGroup.isPresent()) continue;
            return optionalGroup.get();
        }
        return null;
    }

    public void removeGroupByName(String name) {
        for (QualityIndicator indicator : this.qualityIndicators) {
            Optional<AnalysisGroup> optionalGroup = indicator.getGroups().stream().filter(g -> g.getName().equals(name)).findFirst();
            optionalGroup.ifPresent(indicator::removeGroup);
        }
    }

    public void addQualityIndicator(QualityIndicator qualityIndicator) {
        this.qualityIndicators.add(qualityIndicator);
    }

    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="qualityIndicator")
    @JsonView(value={SerializationViews.InstanceComparisonView.class})
    @Schema(hidden=true)
    Map<String, QualityIndicator> instanceComparisonQualityIndicators() {
        return this.qualityIndicators.stream().collect(Collectors.toMap(QualityIndicator::getName, Function.identity()));
    }

    public Map<String, Map<String, String>> getGroupToOptionsMapping() {
        HashMap<String, Map<String, String>> optionsMapPerGroup = new HashMap<String, Map<String, String>>();
        this.qualityIndicators.forEach(indicator -> optionsMapPerGroup.putAll(indicator.getGroupToOptionsMapping()));
        return optionsMapPerGroup;
    }
}

