/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate;

import com.teamscale.core.config.TeamscaleSystemProperties;
import java.time.Duration;
import java.time.Instant;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jetbrains.annotations.VisibleForTesting;

public record SessionDuration(Instant timeout, Instant endOfLife) {
    @VisibleForTesting
    static final Duration IDLE_TIMEOUT_DURATION = Duration.ofMinutes(TeamscaleSystemProperties.SESSION_IDLE_TIMEOUT_DURATION.getValue().intValue());
    @VisibleForTesting
    static final Duration STAY_LOGGED_IN_MAX_DURATION = Duration.ofDays(30L);
    @VisibleForTesting
    static final Duration DEFAULT_MAX_DURATION = Duration.ofHours(TeamscaleSystemProperties.SESSION_MAX_DURATION.getValue().intValue());

    public SessionDuration(Instant timeout, Instant endOfLife) {
        this.endOfLife = endOfLife;
        this.timeout = timeout.isAfter(endOfLife) ? endOfLife : timeout;
    }

    public static SessionDuration withDefaultTimeout(boolean stayLoggedIn) {
        if (stayLoggedIn) {
            Instant stayLoggedInTimeout = DateTimeUtils.now().plus(STAY_LOGGED_IN_MAX_DURATION);
            return new SessionDuration(stayLoggedInTimeout, stayLoggedInTimeout);
        }
        return SessionDuration.withExplicitEndOfLife(DEFAULT_MAX_DURATION);
    }

    public static SessionDuration withExplicitEndOfLife(Duration untilEndOfLife) {
        Instant now = DateTimeUtils.now();
        return new SessionDuration(now.plus(IDLE_TIMEOUT_DURATION), now.plus(untilEndOfLife));
    }

    public SessionDuration getExtendedDuration() {
        return new SessionDuration(DateTimeUtils.now().plus(IDLE_TIMEOUT_DURATION), this.endOfLife());
    }

    public Duration getDurationUntilTimeout() {
        return Duration.between(DateTimeUtils.now(), this.timeout());
    }

    public boolean isSessionActive() {
        return !this.isTimedOutBefore(DateTimeUtils.now());
    }

    public boolean isTimedOutBefore(Instant instant) {
        return this.timeout().isBefore(instant);
    }
}

