/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolStrategyBase;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.base.ISynchronizeGroupsStrategy;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.ServerDescriptionBase;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserGroupUtils;
import com.teamscale.core.user.UserIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class SynchronizeGroupsStrategyBase<ServerDescription extends ServerDescriptionBase>
extends AuthenticationToolStrategyBase<ServerDescription>
implements ISynchronizeGroupsStrategy {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String ALL_GROUPS = "#ALL_GROUPS#";
    private final IImportGroupsStrategy importGroupsStrategy;
    protected final UserIndex userIndex;
    protected final UserGroupIndex groupIndex;
    protected final IMessageBroker messageBroker;

    protected SynchronizeGroupsStrategyBase(NamedServer<ServerDescription> server, UserIndex userIndex, UserGroupIndex groupIndex, IMessageBroker messageBroker, IImportGroupsStrategy importGroupsStrategy) {
        super(server);
        this.userIndex = userIndex;
        this.groupIndex = groupIndex;
        this.messageBroker = messageBroker;
        this.importGroupsStrategy = importGroupsStrategy;
    }

    @Override
    public void synchronizeSingleGroup(String groupName) throws AuthenticationToolException, StorageException {
        this.synchronizeSingleGroupNow(groupName);
    }

    @Override
    public final void synchronizeSingleGroupNow(String groupName) throws StorageException, AuthenticationToolException {
        UserGroup group = this.groupIndex.getUserGroup(groupName);
        if (group == null) {
            throw new AuthenticationEntityNotFoundException("Group " + groupName + " not found!");
        }
        this.synchronizeGroup(group);
    }

    @Override
    public List<String> synchronizeAllGroups() throws StorageException, AuthenticationToolException {
        return this.synchronizeAllGroupsNow();
    }

    @Override
    public final List<String> synchronizeAllGroupsNow() throws StorageException {
        Set<UserGroup> newGroups = this.retrieveNewGroups();
        List<UserGroup> groups = this.getGroupsForServer();
        groups.addAll(newGroups);
        ArrayList<String> synchronizedGroups = new ArrayList<String>();
        for (UserGroup group : groups) {
            try {
                this.synchronizeGroup(group);
                synchronizedGroups.add(group.getName());
                if (!newGroups.contains(group)) continue;
                this.copyPermissionsOfNewGroup(group);
            }
            catch (AuthenticationToolException e) {
                LOGGER.warn("Synchronizing group '" + group.getName() + "' failed: " + e.getMessage(), (Throwable)((Object)e));
            }
        }
        return synchronizedGroups;
    }

    protected Set<UserGroup> retrieveNewGroups() throws StorageException {
        return Collections.emptySet();
    }

    protected void copyPermissionsOfNewGroup(UserGroup newGroup) throws StorageException {
    }

    private List<UserGroup> getGroupsForServer() throws StorageException {
        return CollectionUtils.filter((Collection)this.groupIndex.getAllUserGroups().extractSecondList(), group -> group.originatesFrom(((ServerDescriptionBase)this.getServer().serverDescription()).getAuthenticationTool(), this.getServer().name()));
    }

    private void synchronizeGroup(UserGroup group) throws AuthenticationToolException, StorageException {
        if (this.handleRemovedGroup(group)) {
            return;
        }
        this.importGroupsStrategy.importGroup(group.getName());
    }

    private boolean handleRemovedGroup(UserGroup group) throws StorageException, AuthenticationToolException {
        if (!this.groupExists(group)) {
            if (group.getUserNames().isEmpty()) {
                return true;
            }
            LOGGER.warn("Group " + group.getName() + " to be synchronized does not exist on server. Removing all users from the group.");
            UserGroupUtils.removeAllUsersFromGroup(group, this.userIndex, this.groupIndex, this.messageBroker);
            return true;
        }
        return false;
    }

    protected abstract boolean groupExists(UserGroup var1) throws StorageException, AuthenticationToolException;
}

