/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.index;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="access-tokens", options={EStorageOption.COMPRESSED}, valueClasses={AccessToken.class})
public class AccessTokenIndex
extends IndexBase
implements IGlobalIndex {
    public static final String NAME = "access-tokens";

    public AccessTokenIndex(IStore store) {
        super(store);
    }

    public <X extends Exception> String getOrCreateToken(String tokenName, Duration minimumValidityDuration, IFactory<AccessToken, X> tokenFactory) throws StorageException, X {
        AccessToken storedToken = (AccessToken)StorageUtils.deserialize((byte[])this.store.getWithString(tokenName));
        if (storedToken == null || !storedToken.stillValidIn(minimumValidityDuration)) {
            storedToken = (AccessToken)tokenFactory.create();
            this.store.putWithString(tokenName, StorageUtils.serialize((Serializable)storedToken));
        }
        return storedToken.getToken();
    }

    public void removeToken(String tokenName) throws StorageException {
        this.store.removeWithString(tokenName);
    }

    @IndexValueClass
    public static class AccessToken
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String token;
        private final Instant validTo;

        public AccessToken(String token, Instant validTo) {
            this.token = token;
            this.validTo = validTo;
        }

        private boolean stillValidIn(Duration duration) {
            return Instant.now().plus(duration).isBefore(this.validTo);
        }

        public String getToken() {
            return this.token;
        }

        public Instant getValidTo() {
            return this.validTo;
        }
    }
}

