/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.core.log.LogEntryBase;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.js.ShortJavaScriptErrorLog;
import com.teamscale.core.log.profiler.ShortProfilerLog;
import com.teamscale.core.log.service.ShortCriticalEventServiceLog;
import com.teamscale.core.log.service.ShortServiceLog;
import com.teamscale.core.log.worker.ShortCriticalEventWorkerLog;
import com.teamscale.core.log.worker.ShortWorkerLog;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=ShortWorkerLog.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ShortCriticalEventWorkerLog.class, name="CriticalEventShortWorkerLog"), @JsonSubTypes.Type(value=ShortCriticalEventServiceLog.class, name="ShortCriticalEventLog"), @JsonSubTypes.Type(value=ShortJavaScriptErrorLog.class, name="ShortJavaScriptErrorLog"), @JsonSubTypes.Type(value=ShortServiceLog.class, name="ShortServiceLog"), @JsonSubTypes.Type(value=ShortProfilerLog.class, name="ShortProfilerLog"), @JsonSubTypes.Type(value=ShortWorkerLog.class, name="ShortWorkerLog")})
@IndexValueClass
public abstract class ShortLogEntryBase
extends LogEntryBase {
    private static final long serialVersionUID = 1L;
    protected static final String DEBUG_COUNT_PROPERTY_NAME = "debugCount";
    protected static final String FATAL_ERROR_COUNT_PROPERTY_NAME = "fatalCount";
    protected static final String ERROR_COUNT_PROPERTY_NAME = "errorCount";
    protected static final String WARNING_COUNT_PROPERTY_NAME = "warningCount";
    protected static final String PROJECT_NAME_PROPERTY_NAME = "projectName";
    private static final Pattern COMMIT_DESCRIPTOR_PATTERN = Pattern.compile("(\\S+)@(\\d+)");
    @JsonProperty(value="debugCount")
    private final int debugCount;
    @JsonProperty(value="fatalCount")
    private final int fatalCount;
    @JsonProperty(value="errorCount")
    private final int errorCount;
    @JsonProperty(value="warningCount")
    private final int warningCount;
    @JsonProperty(value="projectName")
    private @Nullable IProjectId projectId;

    protected ShortLogEntryBase(LogEntryIdentifier id, int debugCount, int fatalCount, int errorCount, int warningCount, @Nullable IProjectId projectId) {
        super(id);
        this.debugCount = debugCount;
        this.fatalCount = fatalCount;
        this.errorCount = errorCount;
        this.warningCount = warningCount;
        this.projectId = projectId;
    }

    public int getFatalCount() {
        return this.fatalCount;
    }

    public int getDebugCount() {
        return this.debugCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public @Nullable IProjectId getProjectId() {
        return this.projectId;
    }

    public void setProjectId(@Nullable PublicProjectId projectId) {
        this.projectId = projectId;
    }

    public final boolean matches(Pattern pattern) {
        return this.getFilterCriteria().filter(Objects::nonNull).map(pattern::matcher).anyMatch(Matcher::find);
    }

    protected Stream<String> getFilterCriteria() {
        long timestamp = this.getTimestamp();
        return Stream.of(Long.toString(timestamp), new Date(timestamp).toString());
    }

    public String getFormattedLogEntry() {
        StringBuilder logEntry = new StringBuilder();
        this.appendFields(logEntry);
        this.appendErrorStatistics(logEntry);
        return logEntry.toString();
    }

    protected void appendFields(StringBuilder builder) {
        builder.append(this.getTimestampFormatted()).append(" ");
        builder.append("(timestamp: ").append(this.getTimestamp()).append(") ");
        builder.append(this.projectId).append(" ");
    }

    protected void appendErrorStatistics(StringBuilder builder) {
        builder.append(this.errorCount).append(" errors ");
        builder.append(this.warningCount).append(" warnings ");
    }

    protected static String formatTimestampsAsDates(String message) {
        Matcher commitDescriptorMatcher = COMMIT_DESCRIPTOR_PATTERN.matcher(message);
        Set timestamps = commitDescriptorMatcher.results().map(match -> Long.parseLong(match.group(2))).collect(Collectors.toSet());
        Iterator iterator = timestamps.iterator();
        while (iterator.hasNext()) {
            long timestamp = (Long)iterator.next();
            String date = DateTimeUtils.getUiFormattedDateString((long)timestamp);
            message = message.replace("@" + timestamp, "@" + timestamp + " (" + date + ")");
        }
        return message;
    }
}

