/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.mail;

import com.teamscale.core.mail.CustomMailOption;
import com.teamscale.core.mail.MailNotificationOption;
import com.teamscale.core.mail.SmtpServerOptions;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.text.StringEscapeUtils;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.html.HTMLWriter;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class MailUtils {
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);
    private final Session session;
    private final SmtpServerOptions mailOptions;

    public MailUtils(SmtpServerOptions mailOptions) {
        this.mailOptions = mailOptions;
        this.session = MailUtils.createSession(mailOptions);
    }

    private static Session createSession(final SmtpServerOptions mailOptions) {
        Properties properties = MailUtils.createProperties(mailOptions);
        return Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                String username = mailOptions.username;
                if (StringUtils.isEmpty((String)username)) {
                    username = mailOptions.fromEMail;
                }
                return new PasswordAuthentication(username, mailOptions.password);
            }
        });
    }

    private static Properties createProperties(SmtpServerOptions options) {
        Properties properties = new Properties();
        properties.put("mail.transport.protocol", "smtp");
        if (options.useSSL) {
            properties.put("mail.smtp.socketFactory.port", Integer.toString(options.port));
            properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail.smtp.ssl.checkserveridentity", (Object)true);
            properties.put("mail.smtp.socketFactory.fallback", "false");
        }
        properties.put("mail.smtp.host", options.host);
        properties.put("mail.smtp.port", Integer.toString(options.port));
        properties.put("mail.smtp.starttls.enable", Boolean.toString(options.useStartTls));
        boolean useAuthentication = !StringUtils.isEmpty((String)options.password);
        properties.put("mail.smtp.auth", Boolean.toString(useAuthentication));
        MailUtils.configureTimeouts(properties);
        return properties;
    }

    private static void configureTimeouts(Properties properties) {
        long timeoutMillis = Math.toIntExact(TIMEOUT.toMillis());
        properties.put("mail.smtp.timeout", (Object)timeoutMillis);
        properties.put("mail.smtps.timeout", (Object)timeoutMillis);
        properties.put("mail.smtp.connectiontimeout", (Object)timeoutMillis);
        properties.put("mail.smtps.connectiontimeout", (Object)timeoutMillis);
    }

    @VisibleForTesting
    Message prepareMessage(Collection<String> recipients, String subject) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = new MimeMessage(this.session);
        message.setFrom((Address)new InternetAddress(this.mailOptions.fromEMail, this.mailOptions.fromName));
        ArrayList<InternetAddress> toAddresses = new ArrayList<InternetAddress>();
        for (String recipient : recipients) {
            toAddresses.add(new InternetAddress(recipient));
        }
        message.setRecipients(Message.RecipientType.TO, (Address[])CollectionUtils.toArray(toAddresses, InternetAddress.class));
        message.setSubject(MailUtils.escapeUserInput(subject));
        message.setSentDate(new Date());
        return message;
    }

    private static String escapeUserInput(String text) {
        return StringEscapeUtils.escapeJava((String)text);
    }

    public void sendHtmlMail(Collection<String> recipients, String subject, String content, GlobalStorageSystem globalStorageSystem) throws StorageException, MailException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        MailNotificationOption notificationOption = MailUtils.getNotificationOption(serverOptionIndex);
        CustomMailOption customMailOption = MailUtils.getCustomMailOption(globalStorageSystem);
        this.sendHtmlMail(recipients, subject, content, customMailOption, notificationOption);
    }

    private void sendHtmlMail(Collection<String> recipients, String subject, String content, CustomMailOption customMailOption, MailNotificationOption notificationOption) throws MailException {
        if (!notificationOption.isMailsActivated) {
            return;
        }
        if (customMailOption != null) {
            content = MailUtils.extendMailContentWithHeaderAndFooter(customMailOption, content);
        }
        this.sendHtmlMail(recipients, subject, content);
    }

    public static MailNotificationOption getNotificationOption(ServerOptionIndex serverOptionIndex) throws StorageException {
        return ServerOptionRegistry.getInstance().getServerOption("mail.notification.option", MailNotificationOption.class, serverOptionIndex);
    }

    private static CustomMailOption getCustomMailOption(GlobalStorageSystem globalStorageSystem) throws StorageException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        return ServerOptionRegistry.getInstance().getServerOption("custom.mail.option", CustomMailOption.class, serverOptionIndex);
    }

    private static String extendMailContentWithHeaderAndFooter(CustomMailOption customMailOption, String mailContent) {
        StringWriter extendedContent = new StringWriter();
        HTMLWriter writer = new HTMLWriter(new PrintWriter(extendedContent));
        MailUtils.appendTextNotEmpty(writer, customMailOption.header);
        MailUtils.appendTextNotEmpty(writer, mailContent);
        MailUtils.appendTextNotEmpty(writer, customMailOption.footer);
        writer.close();
        return extendedContent.toString();
    }

    private static void appendTextNotEmpty(HTMLWriter writer, String string) {
        if (!StringUtils.isEmpty((String)string)) {
            writer.openElement((Enum)EHTMLElement.DIV);
            writer.addRawString(string);
            writer.closeElement((Enum)EHTMLElement.DIV);
        }
    }

    private void sendHtmlMail(Collection<String> recipients, String subject, String html) throws MailException {
        try {
            Message message = this.prepareMessage(recipients, subject);
            MimeBodyPart textPart = new MimeBodyPart();
            String text = MailUtils.htmlToText(html);
            textPart.setText(text, StandardCharsets.UTF_8.name(), "plain");
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setText(html, StandardCharsets.UTF_8.name(), "html");
            MimeMultipart multipart = new MimeMultipart("alternative");
            multipart.addBodyPart((BodyPart)textPart);
            multipart.addBodyPart((BodyPart)htmlPart);
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
        }
        catch (MessagingException | UnsupportedEncodingException e) {
            throw new MailException("Error sending mail with subject: '" + subject + "' to recipients '" + String.valueOf(recipients) + "': " + e.getMessage(), e);
        }
    }

    @VisibleForTesting
    static String htmlToText(String html) {
        Document doc = Jsoup.parse((String)html);
        for (Element aTag : doc.select("a[href]")) {
            String linkText = aTag.text();
            String href = aTag.attr("href");
            aTag.text(linkText + " [" + href + "]");
        }
        return doc.wholeText().trim();
    }

    public static SmtpServerOptions getMailOptions(GlobalStorageSystem globalStorageSystem) throws StorageException {
        ServerOptionIndex optionIndex = (ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        return ServerOptionRegistry.getInstance().getOption("server", "mail.options", null, SmtpServerOptions.class, optionIndex);
    }

    public static MailUtils createMailUtils(GlobalStorageSystem globalStorageSystem) throws StorageException, MailException {
        SmtpServerOptions smtpServerOptions = MailUtils.getMailOptions(globalStorageSystem);
        if (smtpServerOptions == null) {
            throw new MailException("SMTP server options are not defined.");
        }
        return new MailUtils(smtpServerOptions);
    }

    public static class MailException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MailException(String message, Throwable cause) {
            super(message, cause);
        }

        public MailException(String message) {
            super(message);
        }
    }
}

