/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.values;

import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public enum EMetricValueType {
    NUMERIC(0.0, Double.class, MetricDirectorySchemaEntry.EAggregation.MIN, MetricDirectorySchemaEntry.EAggregation.MAX, MetricDirectorySchemaEntry.EAggregation.SUM),
    TIMESTAMP(0L, Long.class, MetricDirectorySchemaEntry.EAggregation.MIN, MetricDirectorySchemaEntry.EAggregation.MAX),
    ASSESSMENT(new Assessment(), Assessment.class, MetricDirectorySchemaEntry.EAggregation.SUM),
    COUNTER_SET(new CounterSet(), CounterSet.class, MetricDirectorySchemaEntry.EAggregation.UNION),
    STRING("", String.class, MetricDirectorySchemaEntry.EAggregation.UNION);

    private final Class<? extends Serializable> valueClass;
    private final Set<MetricDirectorySchemaEntry.EAggregation> supportedAggregations = EnumSet.noneOf(MetricDirectorySchemaEntry.EAggregation.class);
    private final Object defaultValue;
    public static final Set<EMetricValueType> COLOR_METRIC_TYPES;

    private EMetricValueType(Object defaultValue, Class<? extends Serializable> valueClass, MetricDirectorySchemaEntry.EAggregation ... supportedAggregations) {
        this.defaultValue = defaultValue;
        this.valueClass = valueClass;
        this.supportedAggregations.addAll(Arrays.asList(supportedAggregations));
        this.supportedAggregations.add(MetricDirectorySchemaEntry.EAggregation.NONE);
    }

    public Class<? extends Serializable> getValueClass() {
        return this.valueClass;
    }

    public boolean supportsAggregation(MetricDirectorySchemaEntry.EAggregation aggregation) {
        return this.supportedAggregations.contains((Object)aggregation);
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    static {
        COLOR_METRIC_TYPES = EnumSet.of(ASSESSMENT, NUMERIC, TIMESTAMP, COUNTER_SET);
    }
}

