/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.google.common.collect.Iterables;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IMultiStoreMigrator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.serialization.SerializedEntityBase;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion152SplitQualityReportsIndex
implements IMultiStoreMigrator {
    private static final String QUALITY_REPORTS_INDEX_NAME = "quality-reports-index";
    private static final String SLIDE_RENDER_DATA_INDEX_NAME = "slide-render-data";

    @Override
    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V152;
    }

    @Override
    public Set<String> getInputStoreNames() {
        return Set.of(QUALITY_REPORTS_INDEX_NAME);
    }

    @Override
    public Set<String> getOutputStoreNames() {
        return Set.of(QUALITY_REPORTS_INDEX_NAME, SLIDE_RENDER_DATA_INDEX_NAME);
    }

    @Override
    public void migrate(Map<String, IStore> inputStoresByName, Map<String, IStore> outputStoresByName) throws StorageException {
        ConvenientStore unmigratedQualityReportsStore = new ConvenientStore(inputStoresByName.get(QUALITY_REPORTS_INDEX_NAME));
        PairList migratedReportEntries = new PairList();
        PairList migratedSlideDataEntries = new PairList();
        PairList allEntries = unmigratedQualityReportsStore.getEntriesStartingWith("");
        try {
            for (Pair entry : allEntries) {
                migratedReportEntries.add((Object)((byte[])entry.getFirst()), (Object)this.migrateReport((byte[])entry.getSecond()));
                migratedSlideDataEntries.addAll(this.migrateSlides((byte[])entry.getSecond()));
            }
        }
        catch (MigrationException | IOException e) {
            throw new StorageException((Throwable)e);
        }
        ConvenientStore migratedQualityReportsIndex = new ConvenientStore(outputStoresByName.get(QUALITY_REPORTS_INDEX_NAME));
        ConvenientStore slideRenderDataIndex = new ConvenientStore((IStore)new CompressingStore(outputStoresByName.get(SLIDE_RENDER_DATA_INDEX_NAME)));
        migratedQualityReportsIndex.put(migratedReportEntries);
        slideRenderDataIndex.put(migratedSlideDataEntries);
    }

    private byte[] migrateReport(byte[] value) throws MigrationException, IOException {
        SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])value);
        this.migrateReport(entityPool);
        return SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities());
    }

    private PairList<byte[], byte[]> migrateSlides(byte[] value) throws IOException {
        PairList slides = new PairList();
        SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])value);
        SerializedObject report = (SerializedObject)Iterables.getOnlyElement((Iterable)entityPool.getRootEntities());
        Integer metaInfoHandle = (Integer)report.getFieldValue("metaInfo");
        SerializedObject metaInfo = (SerializedObject)entityPool.getEntity(metaInfoHandle.intValue(), SerializedObject.class);
        Integer idHandle = (Integer)metaInfo.getFieldValue("id");
        String reportId = ((SerializedStringObject)entityPool.getEntity(idHandle.intValue(), SerializedStringObject.class)).getValue();
        Integer slidesHandle = (Integer)report.getFieldValue("slides");
        SerializedObject slidesList = (SerializedObject)entityPool.getEntity(slidesHandle.intValue(), SerializedObject.class);
        List slideObjects = SerializationMigrationUtils.getObjectsFromArrayList((SerializedObject)slidesList, (SerializedEntityPool)entityPool);
        for (SerializedEntityBase slideEntity : slideObjects) {
            Integer rawRenderDataHandle;
            SerializedObject slideObject = (SerializedObject)slideEntity;
            Object rawRenderDataValue = slideObject.getFieldValue("rawRenderData");
            if (!(rawRenderDataValue instanceof Integer) || (rawRenderDataHandle = (Integer)rawRenderDataValue) == 0) continue;
            Integer slideIdValue = (Integer)slideObject.getFieldValue("id");
            String slideId = ((SerializedStringObject)entityPool.getEntity(slideIdValue.intValue(), SerializedStringObject.class)).getValue();
            slides.add((Object)StringUtils.stringToBytes((String)(reportId + "#!#" + slideId)), (Object)SerializedEntitySerializer.serializeToBytes(List.of((SerializedObject)entityPool.getEntity(rawRenderDataHandle.intValue(), SerializedObject.class))));
        }
        return slides;
    }

    protected void migrateReport(SerializedEntityPool entityPool) throws IOException {
        SerializedClass reportSlideBase = entityPool.findClass("com.teamscale.index.quality_report.ReportSlideBase");
        List classes = entityPool.getEntities(SerializedClass.class);
        if (reportSlideBase != null) {
            for (SerializedClass serializedClass : classes) {
                if (serializedClass.getSuperClassHandle() != reportSlideBase.getHandle()) continue;
                List instances = SerializedEntityUtils.findInstancesOf((SerializedClass)serializedClass, (SerializedEntityPool)entityPool);
                for (SerializedObject instance : instances) {
                    instance.removeFieldValue("rawRenderData");
                }
            }
            reportSlideBase.removeField("rawRenderData");
        }
    }
}

