/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.option;

import com.teamscale.core.analysis.trigger.OptionScheduledTriggerBase;
import com.teamscale.core.cron.CronExpression;
import com.teamscale.core.cron.InvalidCronPatternException;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionDescriptor;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionScheduledRunnable;
import com.teamscale.core.option.ScheduleOption;
import com.teamscale.core.option.server.ServerOptionRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ScheduleOptionUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static String validateScheduleOptions(IOption option) {
        for (Field field : ScheduleOptionUtils.getScheduleFields(option)) {
            try {
                ScheduleOptionUtils.getCronExpression(field, option);
            }
            catch (InvalidCronPatternException e) {
                return "Invalid cron pattern or macro provided for '" + field.getAnnotation(OptionFieldDescription.class).name() + "': " + e.getMessage();
            }
        }
        return null;
    }

    private static CronExpression getCronExpression(Field field, IOption option) throws InvalidCronPatternException {
        Object scheduleValue = null;
        try {
            if (ScheduleOptionUtils.isDisabledByEnablementOption(field, option)) {
                return null;
            }
            scheduleValue = field.get(option);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            CCSMAssert.fail((String)"This should not happen as we check fields at construction time!");
        }
        String schedule = ScheduleOptionUtils.getExecutionTime(field, scheduleValue);
        if (StringUtils.isEmpty((String)schedule)) {
            return null;
        }
        return CronExpression.parse(schedule);
    }

    private static boolean isDisabledByEnablementOption(Field field, IOption option) {
        ScheduleOption scheduleOption = field.getAnnotation(ScheduleOption.class);
        if (!StringUtils.isEmpty((String)scheduleOption.enablementOption())) {
            Field enablementField = ScheduleOptionUtils.getEnablementField(scheduleOption.enablementOption(), option);
            Object enablementValue = null;
            try {
                enablementValue = enablementField.get(option);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                CCSMAssert.fail((String)"This should not happen as we check fields at construction time!");
            }
            if (enablementValue instanceof Boolean) {
                Boolean isEnabled = (Boolean)enablementValue;
                return isEnabled == false;
            }
        }
        return false;
    }

    private static Field getEnablementField(String fieldName, IOption option) {
        for (Field field : OptionDescriptor.getOptionFields(option.getClass())) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        CCSMAssert.fail((String)"This should not happen as we check fields at construction time!");
        return null;
    }

    private static @Nullable String getExecutionTime(Field field, Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof String) {
            String schedule = (String)fieldValue;
            return schedule;
        }
        if (fieldValue instanceof Boolean) {
            Boolean shouldBeScheduled = (Boolean)fieldValue;
            if (shouldBeScheduled.booleanValue()) {
                return field.getAnnotation(ScheduleOption.class).schedule();
            }
            return null;
        }
        return (String)CCSMAssert.fail((String)"Schedule of field %s#%s must either be of type String or Boolean, but was %s".formatted(field.getDeclaringClass(), field.getName(), fieldValue.getClass()));
    }

    private static List<Field> getScheduleFields(IOption option) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : OptionDescriptor.getOptionFields(option.getClass())) {
            if (!field.isAnnotationPresent(ScheduleOption.class)) continue;
            result.add(field);
        }
        return result;
    }

    public static SetMap<String, Class<? extends OptionScheduledTriggerBase>> getOptionScheduledTriggers(long currentTimeMillis, IndexLayer indexLayer) throws StorageException {
        return ScheduleOptionUtils.getOptionScheduledClasses(currentTimeMillis, indexLayer, ScheduleOption::triggerClass);
    }

    public static SetMap<String, Class<? extends OptionScheduledRunnable>> getOptionScheduledRunnables(long currentTimeMillis, IndexLayer indexLayer) throws StorageException {
        return ScheduleOptionUtils.getOptionScheduledClasses(currentTimeMillis, indexLayer, ScheduleOption::runnableClass);
    }

    private static <T> SetMap<String, Class<? extends T>> getOptionScheduledClasses(long currentTimeMillis, IndexLayer indexLayer, Function<ScheduleOption, Class<? extends T>> classRetriever) throws StorageException {
        SetMap result = new SetMap();
        Map<String, IOption> options = ServerOptionRegistry.getAllServerOptions(indexLayer);
        for (Map.Entry<String, IOption> entry : options.entrySet()) {
            String optionName = entry.getKey();
            for (Class<? extends T> clazz : ScheduleOptionUtils.getScheduled(entry.getValue(), currentTimeMillis, classRetriever)) {
                result.add((Object)optionName, clazz);
            }
        }
        return result;
    }

    private static <T> List<Class<? extends T>> getScheduled(IOption option, long currentTimeMillis, Function<ScheduleOption, Class<? extends T>> retriever) {
        ArrayList<Class<? extends T>> result = new ArrayList<Class<? extends T>>();
        for (Field field : ScheduleOptionUtils.getScheduleFields(option)) {
            ScheduleOptionUtils.getScheduledFromField(option, field, currentTimeMillis, retriever).ifPresent(result::add);
        }
        return result;
    }

    private static <T> Optional<Class<? extends T>> getScheduledFromField(IOption option, Field field, long currentTimeMillis, Function<ScheduleOption, Class<? extends T>> retriever) {
        try {
            Class<T> scheduledClass;
            int modifiers;
            CronExpression executionTime = ScheduleOptionUtils.getCronExpression(field, option);
            if (executionTime != null && executionTime.matches(DateTimeUtils.atZone((long)currentTimeMillis)) && !Modifier.isAbstract(modifiers = (scheduledClass = retriever.apply(field.getAnnotation(ScheduleOption.class))).getModifiers()) && !Modifier.isInterface(modifiers)) {
                return Optional.of(scheduledClass);
            }
        }
        catch (InvalidCronPatternException e) {
            LOGGER.error("Found invalid crontab entry in options: " + e.getMessage(), (Throwable)e);
        }
        return Optional.empty();
    }
}

