/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.google.common.hash.HashCode;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.runtime.impl.worker.DelegatingHashingStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStore;
import org.conqat.engine.persistence.store.branched.IHashingStore;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

public class RecordingStore
extends DelegatingStore {
    private final Map<StorageKey, HashCode> modifiedKeysToInitialValueHash = new HashMap<StorageKey, HashCode>();
    private final Set<StorageKey> removedKeys = new HashSet<StorageKey>();
    private final boolean underlyingStoreIsVirtual;
    private final IHashingStore store;

    public RecordingStore(IStore delegate) {
        this(delegate, false);
    }

    public RecordingStore(IStore delegate, boolean underlyingStoreIsVirtual) {
        super(delegate);
        this.underlyingStoreIsVirtual = underlyingStoreIsVirtual;
        this.store = delegate instanceof IHashingStore ? (IHashingStore)delegate : new DelegatingHashingStore(delegate);
    }

    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        HashCode oldHash = IHashingStore.NULL;
        if (!this.underlyingStoreIsVirtual) {
            oldHash = this.store.getHash(key);
            if (this.store.calculateHash(value).equals((Object)oldHash)) {
                return;
            }
        }
        this.recordPut(key, value, oldHash);
        this.store.put(key, value);
    }

    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        if (this.underlyingStoreIsVirtual) {
            for (int i = 0; i < keysValues.size(); ++i) {
                this.recordPut((byte[])keysValues.getFirst(i), (byte[])keysValues.getSecond(i), IHashingStore.NULL);
            }
            this.store.put(keysValues);
            return;
        }
        List keys = keysValues.extractFirstList();
        List oldHashes = this.store.getHash(keys);
        PairList reduced = new PairList();
        for (int i = 0; i < keysValues.size(); ++i) {
            byte[] value;
            HashCode oldHash = (HashCode)oldHashes.get(i);
            if (oldHash.equals((Object)this.store.calculateHash(value = (byte[])keysValues.getSecond(i)))) continue;
            byte[] key = (byte[])keysValues.getFirst(i);
            reduced.add((Object)key, (Object)value);
            this.recordPut(key, value, oldHash);
        }
        if (!reduced.isEmpty()) {
            this.store.put(reduced);
        }
    }

    public void remove(byte @NonNull [] key) throws StorageException {
        HashCode oldHash = IHashingStore.NULL;
        if (!this.underlyingStoreIsVirtual && IHashingStore.NULL.equals((Object)(oldHash = this.store.getHash(key)))) {
            return;
        }
        this.recordRemove(key, oldHash);
        this.store.remove(key);
    }

    public void remove(List<byte @NonNull []> keys) throws StorageException {
        if (this.underlyingStoreIsVirtual) {
            for (byte[] key : keys) {
                this.recordRemove(key, IHashingStore.NULL);
            }
            this.store.remove(keys);
            return;
        }
        List oldHashes = this.store.getHash(keys);
        ArrayList<byte[]> reducedKeys = new ArrayList<byte[]>();
        for (int i = 0; i < keys.size(); ++i) {
            HashCode oldHash = (HashCode)oldHashes.get(i);
            if (IHashingStore.NULL.equals((Object)oldHash)) continue;
            byte[] key = keys.get(i);
            this.recordRemove(key, oldHash);
            reducedKeys.add(key);
        }
        if (!reducedKeys.isEmpty()) {
            this.store.remove(reducedKeys);
        }
    }

    public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
        if (this.underlyingStoreIsVirtual) {
            throw new StorageException("Prefix removal not supported for virtual stores!");
        }
        List keys = StorageUtils.listKeysStartingWith((byte[])prefix, (IStore)this);
        List values = this.store.getHash(keys);
        for (int i = 0; i < keys.size(); ++i) {
            this.recordRemove((byte[])keys.get(i), (HashCode)values.get(i));
        }
        super.removeByPrefix(prefix);
    }

    public synchronized KeyDelta obtainDelta() {
        HashSet addedOrChanged = CollectionUtils.differenceSet(this.modifiedKeysToInitialValueHash.keySet(), (Collection[])new Collection[]{this.removedKeys});
        return new KeyDelta(addedOrChanged, (Collection<StorageKey>)this.removedKeys);
    }

    private synchronized void recordPut(byte[] key, byte[] value, @NonNull HashCode oldHash) {
        StorageKey storageKey = new StorageKey(key);
        this.removedKeys.remove(storageKey);
        HashCode valueHash = this.store.calculateHash(value);
        if (valueHash.equals((Object)this.modifiedKeysToInitialValueHash.get(storageKey))) {
            this.modifiedKeysToInitialValueHash.remove(storageKey);
        } else {
            this.modifiedKeysToInitialValueHash.putIfAbsent(storageKey, oldHash);
        }
    }

    private synchronized void recordRemove(byte[] key, @NonNull HashCode hashCode) {
        StorageKey storageKey = new StorageKey(key);
        this.removedKeys.add(storageKey);
        this.modifiedKeysToInitialValueHash.putIfAbsent(storageKey, hashCode);
    }
}

