/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.Char;
import us.hebi.matlab.mat.types.FunctionHandle;
import us.hebi.matlab.mat.types.JavaObject;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.ObjectStruct;
import us.hebi.matlab.mat.types.Struct;
import us.hebi.matlab.mat.util.IndentingAppendable;

class StringHelper {
    StringHelper() {
    }

    static String toString(Collection<MatFile.Entry> entries) {
        StringBuilder builder = new StringBuilder();
        IndentingAppendable out = StringHelper.wrap(builder);
        int longest = 0;
        for (MatFile.Entry entry : entries) {
            longest = Math.max(longest, entry.getName().length());
        }
        boolean first = true;
        for (MatFile.Entry entry : entries) {
            if (!first) {
                out.append("\n");
            }
            first = false;
            StringHelper.appendName(entry.getName(), longest, out);
            out.append(" = ");
            StringHelper.append(entry.getValue(), out);
        }
        return builder.toString();
    }

    static String toString(Array array) {
        StringBuilder builder = new StringBuilder();
        StringHelper.append(array, StringHelper.wrap(builder));
        return builder.toString();
    }

    private static void append(Array array, IndentingAppendable out) {
        Matrix matrix;
        Char c;
        if (array.getNumElements() == 0) {
            if (array instanceof Cell) {
                out.append("{}");
                return;
            }
            if (array instanceof Matrix) {
                out.append("[]");
                return;
            }
            if (array instanceof Char) {
                out.append("''");
                return;
            }
        }
        if (array instanceof Char && (c = (Char)array).getNumRows() == 1) {
            out.append("'").append(c.getString()).append("'");
            return;
        }
        if (array instanceof Matrix && (matrix = (Matrix)array).getNumElements() == 1) {
            if (matrix.isLogical()) {
                out.append(matrix.getBoolean(0));
                return;
            }
            out.append(matrix.getDouble(0));
            if (matrix.isComplex()) {
                out.append("+").append(matrix.getImaginaryDouble(0)).append("j");
            }
            return;
        }
        if (array instanceof Struct) {
            String className = "struct";
            if (array instanceof ObjectStruct) {
                className = StringHelper.getFullClassName((ObjectStruct)array);
            }
            out.append(StringHelper.getDimString(array)).append(className);
            Struct struct = (Struct)array;
            int longestName = StringHelper.getLongestName(struct.getFieldNames());
            out.indent();
            for (String field : struct.getFieldNames()) {
                out.append("\n");
                StringHelper.appendName(field, longestName, out);
                if (struct.getNumElements() != 1) continue;
                out.append(": ");
                StringHelper.append(struct.get(field), out);
            }
            out.unindent();
            return;
        }
        if (array instanceof FunctionHandle) {
            out.append(StringHelper.getDimString(array)).append("function_handle");
            out.indent().append("\ncontent: ");
            StringHelper.append(((FunctionHandle)array).getContent(), out);
            out.unindent();
            return;
        }
        if (array instanceof JavaObject) {
            JavaObject javaObj = (JavaObject)array;
            out.append(StringHelper.getDimString(array)).append(javaObj.getClassName()).append(" (Java)");
            return;
        }
        StringHelper.appendGenericString(array, out);
    }

    private static void appendGenericString(Array array, IndentingAppendable out) {
        out.append(StringHelper.getDimString(array)).append((Object)array.getType());
    }

    private static String getDimString(Array array) {
        return Arrays.toString(array.getDimensions()).replaceAll(", ", "x").replace("[", "").replace("]", " ");
    }

    private static int getLongestName(List<String> names) {
        int longest = 0;
        for (String name : names) {
            longest = Math.max(longest, name.length());
        }
        return longest;
    }

    private static void appendName(String name, int longest, IndentingAppendable out) {
        out.append(name.isEmpty() ? "\"\"" : name);
    }

    private static IndentingAppendable wrap(Appendable appendable) {
        IndentingAppendable out = new IndentingAppendable(appendable);
        out.setIndentString("    ");
        return out;
    }

    private static String getFullClassName(ObjectStruct object) {
        if (!object.getPackageName().isEmpty()) {
            return object.getPackageName() + "." + object.getClassName();
        }
        return object.getClassName();
    }
}

