import{_ as t,h as e,ak as a,g as i}from"./chunks/framework.BpCjdwm5.js";const g=JSON.parse('{"title":"Connecting Via a HTTP(S) Proxy","description":"","frontmatter":{"title":"Connecting Via a HTTP(S) Proxy"},"headers":[],"relativePath":"howto/connecting-via-https-proxy/index.md","filePath":"howto/connecting-via-https-proxy/index.md"}'),o={name:"howto/connecting-via-https-proxy/index.md"};function n(r,s,p,h,l,d){return i(),e("div",null,s[0]||(s[0]=[a(`<h1 id="how-to-connect-via-an-http-s-proxy" tabindex="-1">How to Connect Via an HTTP(S) Proxy <a class="header-anchor" href="#how-to-connect-via-an-http-s-proxy" aria-label="Permalink to &quot;How to Connect Via an HTTP(S) Proxy&quot;">​</a></h1><p>Sometimes, connections to external systems (source code repositories, issue trackers, etc.) have to go through an HTTP(S) proxy and Teamscale needs to be configured appropriately.</p><div class="tip custom-block"><p class="custom-block-title">Using an HTTP(S) Proxy with Your Cloud Instance</p><p>If your cloud instance needs to connect through an HTTP(S) proxy, please contact the Teamscale support team at <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">support@teamscale.com</a> for assistance.</p></div><nav class="table-of-contents"><ul><li><a href="#configuring-the-proxy-host-and-port">Configuring the Proxy Host and Port</a></li><li><a href="#providing-credentials-to-the-proxy">Providing Credentials to the Proxy</a></li><li><a href="#bypassing-the-proxy">Bypassing the Proxy</a></li></ul></nav><h2 id="configuring-the-proxy-host-and-port" tabindex="-1">Configuring the Proxy Host and Port <a class="header-anchor" href="#configuring-the-proxy-host-and-port" aria-label="Permalink to &quot;Configuring the Proxy Host and Port&quot;">​</a></h2><p>At a minimum, you will need to configure there proxy&#39;s host name or IP address and its port using Java&#39;s <a href="https://docs.oracle.com/javase/8/docs/technotes/guides/net/proxies.html" target="_blank" rel="noreferrer">standard system properties</a>. To do so, add the following to the <code>JVM_EXTRA_ARGS</code> entry in the file <code>$TEAMSCALE_HOME/config/jvm.properties</code> for HTTP and HTTPS connections, respectively:</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Dhttp.proxyHost</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=&lt;HTTP-Proxy-Host&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Dhttp.proxyPort</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=&lt;HTTP-Proxy-Port&gt;</span></span></code></pre></div><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Dhttps.proxyHost</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=&lt;HTTPS-Proxy-Host&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Dhttps.proxyPort</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=&lt;HTTPS-Proxy-Port&gt;</span></span></code></pre></div><p>Furthermore, for the HTTPS proxy, you will need to ensure that the proxy&#39;s SSL/TLS certificate can be validated using <a href="./../connecting-via-https/">Teamscale&#39;s certificate store</a>.</p><h2 id="providing-credentials-to-the-proxy" tabindex="-1">Providing Credentials to the Proxy <a class="header-anchor" href="#providing-credentials-to-the-proxy" aria-label="Permalink to &quot;Providing Credentials to the Proxy&quot;">​</a></h2><p>Sometimes, a proxy will itself require user name and password, distinct from any credentials required by the external systems accessed via the proxy. To configure user name and password, add the following to the <code>JVM_EXTRA_ARGS</code> entry in the file <code>$TEAMSCALE_HOME/config/jvm.properties</code> for HTTP and HTTPS, respectively:</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Dhttp.proxyUser</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=&lt;HTTP-Proxy-User-Name&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Dhttp.proxyPassword</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=&lt;HTTP-Proxy-User-Password&gt;</span></span></code></pre></div><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Dhttps.proxyUser</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=&lt;HTTPS-Proxy-User-Name&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Dhttps.proxyPassword</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=&lt;HTTPS-Proxy-User-Password&gt;</span></span></code></pre></div><h2 id="bypassing-the-proxy" tabindex="-1">Bypassing the Proxy <a class="header-anchor" href="#bypassing-the-proxy" aria-label="Permalink to &quot;Bypassing the Proxy&quot;">​</a></h2><p>Sometimes, only some connections to external systems should go through the HTTP or HTTPS proxy; connections to other systems should or must be made directly. In this case, add the following to the <code>JVM_EXTRA_ARGS</code> entry in the file <code>$TEAMSCALE_HOME/config/jvm.properties</code>: (Please make sure to surround this parameter with double quotes when using the <code>|</code> character.)</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;-Dhttp.nonProxyHosts=localhost|127.0.0.1|*:8080|...&quot;</span></span></code></pre></div><div class="warning custom-block"><p class="custom-block-title">HTTP and HTTPS</p><p>Unlike the other properties above, the <code>http.nonProxyHosts</code> property affects <em>both</em> HTTP and HTTPS. In particular, setting the non-existent <code>https.nonProxyHosts</code> has no effect.</p></div>`,17)]))}const y=t(o,[["render",n]]);export{g as __pageData,y as default};
