import{_ as a,h as i,ak as o,g as s}from"./chunks/framework.BpCjdwm5.js";const m=JSON.parse('{"title":"Improving Analysis Results for C and C++","description":"","frontmatter":{"title":"Improving Analysis Results for C and C++"},"headers":[],"relativePath":"howto/improving-analysis-results-for-cpp/index.md","filePath":"howto/improving-analysis-results-for-cpp/index.md"}'),t={name:"howto/improving-analysis-results-for-cpp/index.md"};function n(r,e,l,d,c,p){return s(),i("div",null,e[0]||(e[0]=[o(`<h1 id="how-to-improve-analysis-results-for-c-and-c" tabindex="-1">How to Improve Analysis Results for C and C++ <a class="header-anchor" href="#how-to-improve-analysis-results-for-c-and-c" aria-label="Permalink to &quot;How to Improve Analysis Results for C and C++&quot;">​</a></h1><p>The challenge with analysis of C and C++ code is that macros meant for configuration are typically set using the build system and are not automatically available to Teamscale. This article describes solutions to this problem.</p><nav class="table-of-contents"><ul><li><a href="#problem-description">Problem Description</a></li><li><a href="#adding-preprocessor-information-to-the-analysis-profile">Adding Preprocessor Information to the Analysis Profile</a></li><li><a href="#using-a-compilation-database">Using a Compilation Database</a></li><li><a href="#analyzing-excluded-code-in-architecture-analysis">Analyzing excluded code in architecture analysis</a></li></ul></nav><h2 id="problem-description" tabindex="-1">Problem Description <a class="header-anchor" href="#problem-description" aria-label="Permalink to &quot;Problem Description&quot;">​</a></h2><p>Typically, C/C++ code relies to some degree on conditional compilation, also referred to as <code>#ifdef</code> programming. This means that the preprocessor is used to include or exclude certain parts of your code base at compile time. While Teamscale finds and uses all macros found in your source code, important macros affecting the compilation process are usually provided by the build system via compiler arguments (<code>-DMacro_Name</code>).</p><p>Since such arguments are not visible to Teamscale, they are not considered in the code analysis. For simple projects this behavior might lead to reasonable results, but to get precise analysis results in general, it is important for Teamscale to know all macros, even those defined by the build system.</p><h2 id="adding-preprocessor-information-to-the-analysis-profile" tabindex="-1">Adding Preprocessor Information to the Analysis Profile <a class="header-anchor" href="#adding-preprocessor-information-to-the-analysis-profile" aria-label="Permalink to &quot;Adding Preprocessor Information to the Analysis Profile&quot;">​</a></h2><p>The easiest way to provide information about macros is by adding it to the analysis profile. If you select the language C/C++ for an analysis profile, you will find an option <em>Predefined Preprocessor Macros</em>. Here you can add preprocessor <code>#define</code> directives that will be applied to every single code file that Teamscale analyzes with this profile. For example, the content could look like this:</p><div class="language-c vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">c</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">#define</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> __cplusplus</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> 199711</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">L</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">#define</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> DEBUG</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> 1</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">#define</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> USE_SPECIAL_FEATURE</span></span></code></pre></div><p>This works great for simple cases of global macros, e.g., setting a debug mode. But if this information changes over time or different macros should be applied to different files, you should read the next section.</p><h2 id="using-a-compilation-database" tabindex="-1">Using a Compilation Database <a class="header-anchor" href="#using-a-compilation-database" aria-label="Permalink to &quot;Using a Compilation Database&quot;">​</a></h2><p>A <a href="https://sarcasm.github.io/notes/dev/compilation-database.html" target="_blank" rel="noreferrer">compilation database</a> is a file containing the exact compilation command for each single file encountered during compilation. This includes information about include paths and macro definitions passed to the compiler. The creation of a compilation database is supported by most popular build systems, such as <code>bazel</code>, <code>cmake</code>, <code>ninja</code> or directly via the <code>clang</code> compiler. To learn how to create a compilation database from your build system, read <a href="https://sarcasm.github.io/notes/dev/compilation-database.html" target="_blank" rel="noreferrer">this guide</a>. Teamscale supports compilation databases in <a href="https://clang.llvm.org/docs/JSONCompilationDatabase.html" target="_blank" rel="noreferrer">JSON format</a>.</p><p>The JSON file containing the compilation database is passed to Teamscale just like any other <a href="./../uploading-external-data/">external data</a> using the format <code>COMPILATION_DATABASE</code>. Typically, you will adjust your build jobs to upload this database to Teamscale or an Artifactory server at least every night or even on every run. You can also use different compilation databases for different branches, just like with other external data. Whenever Teamscale processes a file, it will respect the information from the latest database containing information about this file and hence have the same view on the code as the compiler.</p><h2 id="analyzing-excluded-code-in-architecture-analysis" tabindex="-1">Analyzing excluded code in architecture analysis <a class="header-anchor" href="#analyzing-excluded-code-in-architecture-analysis" aria-label="Permalink to &quot;Analyzing excluded code in architecture analysis&quot;">​</a></h2><p>By default, our architecture analysis for C/C++ finds dependencies in code after preprocessing, i.e., code that would be compiled if a compiler would get the same input as Teamscale. Teamscale obtains that code by</p><ol><li>applying text filters configured in the project configuration (i.e., removing, for example, generated code) and</li><li>running our preprocessor (which removes, for example code between <code>#if 0</code> and <code>#endif</code>).</li></ol><p>Our C/C++ architecture analysis detects dependencies from</p><ol><li><code>#include</code> directives to the included files and from</li><li>function declarations to function definitions.</li></ol><p>For the second point, we need to detect function declarations/definitions that requires code which is as syntactically correct as possible. Therefore, this analysis is based on the code after preprocessing (and after applying text filters).</p><p>If you need dependencies from excluded code, you can enable the option <em>Search for dependencies in excluded code</em> in your analysis profile. Teamscale will then additionally do a best-effort attempt to find dependencies in excluded code. It tries to parse the code without preprocessing and ignores any code that could not be parsed. Since a lot of C/C++ code requires preprocessing before it can be parsed properly, enabling this option can lead to decreased quality of analysis results.</p>`,20)]))}const u=a(t,[["render",n]]);export{m as __pageData,u as default};
