import{_ as i,h as t,ak as a,g as e}from"./chunks/framework.BpCjdwm5.js";const d=JSON.parse('{"title":"Providing Testwise Coverage for TIA","description":"","frontmatter":{"title":"Providing Testwise Coverage for TIA"},"headers":[],"relativePath":"howto/providing-testwise-coverage/index.md","filePath":"howto/providing-testwise-coverage/index.md"}'),n={name:"howto/providing-testwise-coverage/index.md"};function l(h,s,p,r,o,k){return e(),t("div",null,s[0]||(s[0]=[a(`<h1 id="how-to-provide-testwise-coverage-for-test-impact-analysis-tia" tabindex="-1">How to Provide Testwise Coverage for Test Impact Analysis (TIA) <a class="header-anchor" href="#how-to-provide-testwise-coverage-for-test-impact-analysis-tia" aria-label="Permalink to &quot;How to Provide Testwise Coverage for Test Impact Analysis (TIA)&quot;">​</a></h1><p>In order to use the <a href="./../../tutorial/improving-test-efficiency/"><em>Test Impact analysis</em></a> or <em>Pareto testing</em>, you&#39;ll need to provide test coverage on a per-test basis to Teamscale with a <a href="./../../reference/upload-formats-and-samples/testwise-coverage/">testwise coverage report</a>.</p><p>Depending on the technologies you use, select the right approach to record testwise coverage:</p><nav class="table-of-contents"><ul><li><a href="#generic-approach-with-teamscale-build">Generic Approach with teamscale-build</a></li><li><a href="#java-virtual-machine-jvm">Java Virtual Machine (JVM)</a><ul><li><a href="#gradle">Gradle</a></li><li><a href="#maven-and-junit-5">Maven and JUnit 5</a></li></ul></li></ul></nav><h2 id="generic-approach-with-teamscale-build" tabindex="-1">Generic Approach with <code>teamscale-build</code> <a class="header-anchor" href="#generic-approach-with-teamscale-build" aria-label="Permalink to &quot;Generic Approach with \`teamscale-build\`&quot;">​</a></h2><p>This approach works for all technologies.</p><ol><li>You instrument your tests with <a href="./../../reference/supported-technologies/test-coverage/">a supported coverage profiler</a>.</li><li>You run each of your tests separately, gather test coverage for only that one test. You end up with many test coverage reports, one per test case.</li><li>You <a href="./../../tutorial/generating-testwise-coverage/">use <code>teamscale-build</code> to combine these report files into one testwise coverage report</a>.</li><li>You <a href="./../uploading-external-data/#upload-via-command-line">upload the testwise coverage report with <code>teamscale-upload</code></a>.</li></ol><h2 id="java-virtual-machine-jvm" tabindex="-1">Java Virtual Machine (JVM) <a class="header-anchor" href="#java-virtual-machine-jvm" aria-label="Permalink to &quot;Java Virtual Machine (JVM)&quot;">​</a></h2><p>Our <a href="./../../reference/coverage-profilers/teamscale-java-profiler/">Java profiler</a> can record testwise coverage. For tests that are run by Maven or Gradle, we provide plugins that automate both testwise coverage collection and smart test execution with Test Impact analysis.</p><p>For other tests, you can use our profiler directly and <a href="./../../reference/coverage-profilers/teamscale-java-profiler/advanced-setup/#rest-api">send events via its REST API when tests start and end</a>.</p><h3 id="gradle" tabindex="-1">Gradle <a class="header-anchor" href="#gradle" aria-label="Permalink to &quot;Gradle&quot;">​</a></h3><p>Our <a href="./../../reference/integrations/gradle-plugin/">Teamscale Gradle plugin</a> can be used with JUnit Platform-based tests. It adds additional options to your <code>Test</code> tasks that allow you to:</p><ul><li>Collect Testwise Coverage for your tests</li><li>Only run impacted tests</li><li>Sort your test execution to fail fast</li></ul><p>Additionally, the plugin provides utilities to aggregate and upload test execution results and coverage from your build to Teamscale.</p><div class="tip custom-block"><p class="custom-block-title">Tutorial</p><p>We also have a <a href="./../../tutorial/tia-java/">Tutorial on how to set up Test Impact Analysis</a> in a Gradle-based Java project.</p></div><h3 id="maven-and-junit-5" tabindex="-1">Maven and JUnit 5 <a class="header-anchor" href="#maven-and-junit-5" aria-label="Permalink to &quot;Maven and JUnit 5&quot;">​</a></h3><p>If you use JUnit 5 (or any test framework built on JUnit 5, e.g., Serenity) for your tests, you can use our <a href="./../../reference/integrations/maven-plugin/">teamscale-maven-plugin</a> to easily run TIA in your builds. It configures Surefire and Failsafe, so they fetch the list of impacted tests from Teamscale, execute them, and record and upload Testwise Coverage. This also works for Spring Boot applications.</p><p>We recommend that for regular, fast feedback, you run only impacted tests for most of your builds. It is, however, necessary to also run all tests from time to time (e.g., in a nightly or weekly build). This allows Teamscale to regularly update Testwise Coverage information for all tests. To achieve this, you can use <a href="https://maven.apache.org/guides/introduction/introduction-to-profiles.html" target="_blank" rel="noreferrer">Maven profiles</a> and enable the <code>teamscale-maven-plugin</code> only in a special profile.</p><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">profiles</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">	&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">profile</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">id</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;tia&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">id</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">activation</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">			&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">property</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">				&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;tia&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">			&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">property</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">activation</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">dependencies</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">			&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">dependency</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">				&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;com.teamscale&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">				&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;impacted-test-engine&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">				&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;34.2.2&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">				&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">scope</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;test&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">scope</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">			&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">dependency</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">dependencies</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">build</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">			&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugins</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">				&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">					&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;com.teamscale&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">					&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;teamscale-maven-plugin&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">					&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;34.2.2&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">					&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">executions</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">						&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">execution</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">							&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goals</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">								&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;prepare-tia-unit-test&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt; </span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">&lt;!-- Enables TIA for Surefire unit tests --&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">								&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;prepare-tia-integration-test</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">								&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt; </span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">&lt;!-- Enables TIA for Failsafe integration tests --&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">							&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goals</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">						&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">execution</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">					&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">executions</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">					&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">configuration</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">						&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">teamscaleUrl</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;http://localhost:8080&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">teamscaleUrl</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">						&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">projectId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;teamscale-project-id&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">projectId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">						&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">username</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;build&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">username</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">						&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">accessToken</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;\${env.TEAMSCALE_ACCESS_TOKEN}&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">accessToken</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">						&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">includes</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">							&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">include</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;*com.your.company.*&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">include</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">						&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">includes</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">					&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">configuration</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">				&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">			&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugins</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">		&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">build</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">	&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">profile</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">profiles</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div><div class="tip custom-block"><p class="custom-block-title">List of All Available Parameters</p><p>To list all available parameters run <code>mvn com.teamscale:teamscale-maven-plugin:help -Ddetail=true</code> (also works without a maven project).</p></div><p>This adds the plugin and configures the connection to Teamscale. We recommend you also set at least one <code>include</code> pattern so coverage is only recorded for your code, not for 3rd party libraries.</p><p>It also configures Surefire and Failsafe to use our <code>impacted-test-engine</code>. This engine automatically fetches impacted tests from Teamscale and executes them. Make sure the engine version matches the <code>teamscale-maven-plugin</code> version.</p><div class="warning custom-block"><p class="custom-block-title">Parallel Tests Not Supported</p><p>Parallelized tests are not supported by this plugin. When tests run in parallel, it is impossible to record Testwise Coverage as the coverage from the tests running in parallel cannot be distinguished anymore. Make sure to set <code>&lt;forkCount&gt;1&lt;/forkCount&gt;</code> and <code>&lt;threadCount&gt;1&lt;/threadCount&gt;</code> (c.f. <a href="https://maven.apache.org/surefire/maven-surefire-plugin/test-mojo.html#forkCount" target="_blank" rel="noreferrer">the Maven documentation</a>) for all tests where you enable the provider, otherwise a TIA-enabled build will fail. These settings are the defaults for Surefire and Failsafe.</p></div><div class="warning custom-block"><p class="custom-block-title">Use of <code>&lt;reuseForks&gt;true&lt;/reuseForks&gt;</code></p><p>It is strongly discouraged to set<code>&lt;reuseForks&gt;true&lt;/reuseForks&gt;</code> as this will start and close a new JVM for each test case. Since the Teamscale-Maven-Plugin writes a coverage report every time the JVM closes, this can lead to performance problems on some systems.</p></div><p>The plugin sets the right system property to attach itself to Surefire and Failsafe tests. Surefire and Failsafe pick up the system property automatically and apply it to any JVMs they spawn.</p><div class="tip custom-block"><p class="custom-block-title">Spring Boot</p><p>The plugin also works out-of-the-box for Spring Boot applications. Here, the Spring Boot Maven plugin will pick up the JVM options and pass them to the Spring Boot application that is started before the integration tests.</p></div><p>In some cases, your system-under-test is not launched by these plugins but by some other means (e.g., another plugin). In this case, make sure the <code>argLine</code> property is passed to the JVM of your system-under-test. If you do not want Surefire or Failsafe to pick up the <code>argLine</code> automatically or want to add additional parameters, you can change the name of the property that holds the JVM arguments by setting the configuration property <code>&lt;propertyName&gt;</code>.</p><p>If you need to add additional parameters to the <a href="./../../reference/coverage-profilers/teamscale-java-profiler/#options">Teamscale Java Profiler</a>, you can use <code>&lt;additionalAgentOptions&gt;</code>.</p><h4 id="troubleshooting" tabindex="-1">Troubleshooting <a class="header-anchor" href="#troubleshooting" aria-label="Permalink to &quot;Troubleshooting&quot;">​</a></h4><p>For troubleshooting help, please have a look at the <a href="./../../reference/integrations/maven-plugin/#troubleshooting">troubleshooting section</a> of our Maven Plugin page.</p>`,30)]))}const g=i(n,[["render",l]]);export{d as __pageData,g as default};
