import{_ as c}from"./chunks/js-profiler-bigpic.BteOd1sF.js";import{_ as p,h,ak as o,O as t,z as s,L as r,g as d,j as e,x as a}from"./chunks/framework.BpCjdwm5.js";const C=JSON.parse('{"title":"Recording JavaScript Coverage in the Browser","description":"","frontmatter":{"title":"Recording JavaScript Coverage in the Browser"},"headers":[],"relativePath":"howto/setting-up-profiler-tga/javascript/index.md","filePath":"howto/setting-up-profiler-tga/javascript/index.md"}'),g={name:"howto/setting-up-profiler-tga/javascript/index.md"};function u(k,i,f,m,b,v){const n=r("PluginTabsTab"),l=r("PluginTabs");return d(),h("div",null,[i[6]||(i[6]=o('<h1 id="how-to-record-test-coverage-for-javascript-applications-in-the-browser" tabindex="-1">How to Record Test Coverage for JavaScript Applications in the Browser <a class="header-anchor" href="#how-to-record-test-coverage-for-javascript-applications-in-the-browser" aria-label="Permalink to &quot;How to Record Test Coverage for JavaScript Applications in the Browser&quot;">​</a></h1><p>This how-to describes how test coverage information can be recorded for a JavaScript application running in a web browser (Firefox, Chrome, Electron, ...) using the <a href="/reference/coverage-profilers/teamscale-javascript-profiler/">Teamscale JavaScript Profiler</a>.</p><p>The outlined approach is particularly suited for scenarios where the system under test is deployed to a server and tests are running against that server. This might either happen via manual tests or also by automated UI tests.<br> It is also suited for legacy systems that use a testing approach with no explicit means to collect coverage information.</p><p><img src="'+c+'" alt="Overview" width="969" height="538" data-zoom="true"></p><p>The above figure illustrates the overall process:</p><ol><li>compile (or transpile) your application into the JavaScript code to be executed in the Web browser</li><li>instrument the compiled source code using our JavaScript Instrumenter</li><li>start the Coverage Collector to receive coverage information from browsers that run your application</li><li>start your instrumented application in the web browser and begin producing test coverage</li><li>if configured, the collector will automatically upload test coverage to Teamscale</li></ol><p>For Node.js applications, please follow our <a href="./../nodejs/">Node.js coverage How-To</a>. For tests with a less complicated setup, for example, JavaScript unit tests, there are often simpler solutions, which are discussed under <a href="#alternatives">alternatives</a>.</p><div class="warning custom-block"><p class="custom-block-title">Public Beta</p><p>The Teamscale JavaScript Profiler is still in the public beta phase. Your development and testing environment might not yet be fully supported by this approach. Please contact our support (<a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">support@teamscale.com</a>) in case you encounter any issues.</p></div><nav class="table-of-contents"><ul><li><a href="#prerequisites">Prerequisites</a><ul><li><a href="#source-maps">Source Maps</a></li><li><a href="#content-security-policy">Content Security Policy</a></li></ul></li><li><a href="#configuring-coverage-collection-in-teamscale">Configuring Coverage Collection in Teamscale</a></li><li><a href="#instrumentation">Instrumentation</a><ul><li><a href="#installing-and-running">Installing and Running</a></li></ul></li><li><a href="#coverage-collector">Coverage Collector</a><ul><li><a href="#installing-and-running-1">Installing and Running</a></li><li><a href="#configuration">Configuration</a></li></ul></li><li><a href="#uploading-coverage-for-inspection">Uploading Coverage for Inspection</a></li><li><a href="#alternatives">Alternatives</a></li></ul></nav><h2 id="prerequisites" tabindex="-1">Prerequisites <a class="header-anchor" href="#prerequisites" aria-label="Permalink to &quot;Prerequisites&quot;">​</a></h2><p>To use the Teamscale JavaScript Profiler, a number of prerequisites have to be in place.</p><p>The instrumented code must be executed in a (possibly headless) browser environment that supports at least <em>ECMAScript 2015</em>. Furthermore, we require that a <em>DOM</em> and <em>WebSockets</em> are available in that execution environment. In other words, the approach supports Edge &gt;= v79, Firefox &gt;= v54, Chrome &gt;= v51, and Safari &gt;= v10. Instrumented applications will fail in Node.js.</p><p>To run the components of the profiler, we recommend using the latest Node.js LTS version, at least, version 14 is needed.</p><h3 id="source-maps" tabindex="-1">Source Maps <a class="header-anchor" href="#source-maps" aria-label="Permalink to &quot;Source Maps&quot;">​</a></h3><p>The code which is executed in the browser often does not correspond to the code written by the developers. It can be the result of several transformation steps, for example, compilation (transpilation) from other languages, source code minimization, or bundling.</p><p>The presence of source map files in the code of the test subject ensures that the tested code can be mapped back to the original. Depending on your build pipeline, a different approach must be chosen to add the source maps to the test subject&#39;s code bundle.</p><p>In the following we provide pointers to relevant configuration options for some of the popular tools used in the context of JavaScript applications:</p>',17)),t(l,null,{default:s(()=>[t(n,{label:"TypeScript"},{default:s(()=>i[0]||(i[0]=[e("div",{class:"language-javascript vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"javascript"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// tsconfig.json")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"{ "),e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"compilerOptions"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": { "),e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"sourceMap"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": "),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"true"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"inlineSources"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": "),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"true"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"..."),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," }, "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"..."),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," }")])])])],-1),e("p",null,[a("See the "),e("a",{href:"https://www.typescriptlang.org/tsconfig#inlineSourceMap",target:"_blank",rel:"noreferrer"},"Typescript documentation"),a(" for more details and options.")],-1)])),_:1,__:[0]}),t(n,{label:"Webpack"},{default:s(()=>i[1]||(i[1]=[e("div",{class:"language-javascript vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"javascript"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// webpack.config.js")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"module"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"."),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"exports"),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," ="),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," { devtool: "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'source-map'"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"..."),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," }")])])])],-1),e("p",null,[a("See the "),e("a",{href:"https://webpack.js.org/configuration/devtool/",target:"_blank",rel:"noreferrer"},"Webpack documentation"),a(" for more details on options to control the generation of source maps.")],-1),e("p",null,[a("Please use the "),e("a",{href:"https://webpack.js.org/loaders/source-map-loader/",target:"_blank",rel:"noreferrer"},[e("code",null,"source-map-loader"),a(" package")]),a(" to ensure that source maps from a previous transformation step are not lost.")],-1)])),_:1,__:[1]}),t(n,{label:"Angular ng-build"},{default:s(()=>i[2]||(i[2]=[e("div",{class:"language-javascript vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"javascript"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// angular.json")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"configurations"'),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": {")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'    "production"'),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": {")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'        "sourceMap"'),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": "),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"true"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},",")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"        ...")])])])],-1),e("p",null,[a("See the "),e("a",{href:"https://angular.io/guide/workspace-config#source-map-configuration",target:"_blank",rel:"noreferrer"},"Angular documentation"),a(" for more details and options.")],-1)])),_:1,__:[2]}),t(n,{label:"Vite"},{default:s(()=>i[3]||(i[3]=[e("div",{class:"language-javascript vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"javascript"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// vite.config.ts")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"build"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": { "),e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"sourcemap"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'inline'"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"..."),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," }")])])])],-1),e("p",null,[a("See the "),e("a",{href:"https://vitejs.dev/config/#build-sourcemap",target:"_blank",rel:"noreferrer"},"Vite documentation"),a(" for more options and details.")],-1)])),_:1,__:[3]}),t(n,{label:"Rollup"},{default:s(()=>i[4]||(i[4]=[e("div",{class:"language-javascript vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"javascript"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// rollup.config.js")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"output"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": { "),e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"sourceMap"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},": "),e("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"true"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"..."),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," }")])])])],-1),e("p",null,[a("See the "),e("a",{href:"https://rollupjs.org/guide/en/#outputsourcemap",target:"_blank",rel:"noreferrer"},"Rollup documentation"),a(" for more details and options.")],-1)])),_:1,__:[4]}),t(n,{label:"esbuild"},{default:s(()=>i[5]||(i[5]=[e("div",{class:"language-javascript vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"javascript"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// esbuild.js")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"require"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"("),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'esbuild'"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},")."),e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"buildSync"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"({")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"  entryPoints: ["),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'app.ts'"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"],")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"  sourcemap: "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'inline'"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},",")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"  outfile: "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'out.js'"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},",")]),a(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"})")])])])],-1),e("p",null,[a("The "),e("a",{href:"https://esbuild.github.io/api/#sourcemap",target:"_blank",rel:"noreferrer"},"esbuild documentation"),a(" provides details and options on producing source map files.")],-1)])),_:1,__:[5]})]),_:1}),i[7]||(i[7]=o(`<h3 id="content-security-policy" tabindex="-1">Content Security Policy <a class="header-anchor" href="#content-security-policy" aria-label="Permalink to &quot;Content Security Policy&quot;">​</a></h3><p>To use the profiler, the application&#39;s Cross-Origin Resource Sharing (CORS) has to be adjusted. The instrumented application sends coverage information via WebSockets to a collecting server. That is, communication via WebSockets must be allowed. Whether this is allowed is determined by the <code>Content-Security-Policy</code> attribute. This attribute is either part of the HTTP header sent by the Web server delivering the Web application, or by a corresponding <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy" target="_blank" rel="noreferrer">HTML entry</a>. If the collecting server is running on the same machine as the browser, then communicating with localhost must be allowed by adding <code>ws://localhost:*</code> for <code>connect-src</code>, <code>blob</code>, and <code>worker-src</code> to the <code>Content-Security-Policy</code> header.</p><p>The following snippet shows the content security policy that has to be added for allowing accessing the collector at host <code>&lt;collectorHost&gt;</code> on port <code>&lt;port&gt;</code>:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>connect-src &#39;self&#39; ws://&lt;collectorHost&gt;:&lt;port&gt;;</span></span>
<span class="line"><span>script-src &#39;self&#39; blob: ws://&lt;collectorHost&gt;:&lt;port&gt;;</span></span>
<span class="line"><span>worker-src &#39;self&#39; blob: ws://&lt;collectorHost&gt;:&lt;port&gt;;</span></span></code></pre></div><p>By not specifying a content security policy, everything would be allowed. This can also be specified explicitly, for testing environments:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>default-src * data: blob: filesystem: about: ws: wss: &#39;unsafe-inline&#39; &#39;unsafe-eval&#39; &#39;unsafe-dynamic&#39;; script-src * data: blob: &#39;unsafe-inline&#39; &#39;unsafe-eval&#39;; connect-src * data: blob: &#39;unsafe-inline&#39;; img-src * data: blob: &#39;unsafe-inline&#39;; frame-src * data: blob: ; style-src * data: blob: &#39;unsafe-inline&#39;; font-src * data: blob: &#39;unsafe-inline&#39;;</span></span></code></pre></div><p>The place to configure the content security policy depends on the backend framework that serves the frontend code. See, for example, the <a href="https://docs.spring.io/spring-security/site/docs/5.2.0.RELEASE/reference/html/default-security-headers-2.html#webflux-headers-csp" target="_blank" rel="noreferrer">Spring documentation</a> on that topic.</p><h2 id="configuring-coverage-collection-in-teamscale" tabindex="-1">Configuring Coverage Collection in Teamscale <a class="header-anchor" href="#configuring-coverage-collection-in-teamscale" aria-label="Permalink to &quot;Configuring Coverage Collection in Teamscale&quot;">​</a></h2><p>There are <a href="/reference/coverage-profilers/teamscale-javascript-profiler/#coverage-collection-options">various ways and parameters</a> to configure how coverage is collected using the Teamscale JavaScript Profiler. We recommend defining a coverage profiling configuration in Teamscale and referencing that via <code>--config-id</code> when instrumenting the application to test. This can be done in <a href="/reference/ui/project/coverage-profilers/">Coverage Profilers View</a> in Teamscale under <strong>Project Configuration</strong> &gt; <strong>Coverage Profilers</strong>. For this HowTo, we define an example configuration with the ID <code>rc-testing-web-frontend</code>, with the following options set:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>teamscalePartition=RC Testing</span></span>
<span class="line"><span>teamscaleProject=angular-hero-app</span></span>
<span class="line"><span>dumpAfterMins=120</span></span></code></pre></div><div class="info custom-block"><p class="custom-block-title">Configuration Refresh</p><p>The collector configurations are refresh from Teamscale once a minute, or if requested explicitly via the <code>/refresh</code> <a href="/reference/coverage-profilers/teamscale-javascript-profiler/#control-api">end point</a> of the control API.</p></div><h2 id="instrumentation" tabindex="-1">Instrumentation <a class="header-anchor" href="#instrumentation" aria-label="Permalink to &quot;Instrumentation&quot;">​</a></h2><p>Before we can produce any coverage from a JavaScript application, this application has to be instrumented. For this we use the Teamscale JavaScript Instrumenter package.</p><h3 id="installing-and-running" tabindex="-1">Installing and Running <a class="header-anchor" href="#installing-and-running" aria-label="Permalink to &quot;Installing and Running&quot;">​</a></h3><p>The instrumenter is available as a Node.js package with the name <code>@teamscale/javascript-instrumenter</code>.</p><p>We recommend <code>npx</code> or <code>pnpm exec</code> to execute the instrumenter. For example, the following command is used to instrument an example app.</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">npx</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> @teamscale/javascript-instrumenter</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    --input</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> ./dist/</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    --collector</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> localhost:54678</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    --config-id</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> rc-testing-web-frontend</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    --commit</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> 4f845c120051b0fbf3f61bb9edb747f114b39433</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    --in-place</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    --include-origin</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;src/app/**/*&#39;</span></span></code></pre></div><p>Here is a short breakdown of that command:</p><ul><li>It instructs the Instrumenter to instrument the code compiled/transpiled/minified code in the target folder <code>./dist/</code>.</li><li>It expects that the <a href="#coverage-collector">collector</a> (<code>--collector</code>) will be running at <code>localhost:54678</code>.</li><li>The collector configuration with the ID <code>rc-testing-web-frontend</code> shall be received from Teamscale to the collector&#39;s coverage dump behavior.</li><li>The collected coverage shall be assigned to the commit with the Git commit hash <code>4f845c120051b0fbf3f61bb9edb747f114b39433</code>.</li><li>The instrumentation is done in-place (<code>--in-place</code>), that is, existing files are replaced by their instrumented counterparts.</li><li>The relevant source files (<code>--include-origin</code>) that should be matched against are located in <code>src/app/**/*</code>.</li></ul><p>For more information on the defined and available option parameters, have a look at our <a href="/reference/coverage-profilers/teamscale-javascript-profiler/#options">reference page</a>.</p><p>Now there should be an instrumented version of your application in the <code>dist</code> folder.</p><h2 id="coverage-collector" tabindex="-1">Coverage Collector <a class="header-anchor" href="#coverage-collector" aria-label="Permalink to &quot;Coverage Collector&quot;">​</a></h2><p>Now that the code has been instrumented to produce and send coverage information, we describe how to set up the coverage collector.</p><h3 id="installing-and-running-1" tabindex="-1">Installing and Running <a class="header-anchor" href="#installing-and-running-1" aria-label="Permalink to &quot;Installing and Running&quot;">​</a></h3><p>The collector is available as a Node.js package with the name <code>@teamscale/coverage-collector</code>.</p><h4 id="running-using-npx" tabindex="-1">Running using NPX <a class="header-anchor" href="#running-using-npx" aria-label="Permalink to &quot;Running using NPX&quot;">​</a></h4><p>The collector can be installed and started using the <code>npx</code> command. The following command starts the collector on the default port <code>54678</code>. The coverage will be dumped into the default folder <code>./coverage</code>:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">npx</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> @teamscale/coverage-collector</span></span></code></pre></div><h4 id="running-as-node-script" tabindex="-1">Running as Node Script <a class="header-anchor" href="#running-as-node-script" aria-label="Permalink to &quot;Running as Node Script&quot;">​</a></h4><p>The package <code>@teamscale/coverage-collector</code> can be added as a development dependency to the <code>package.json</code> file. For example, by running <code>npm install -D @teamscale/coverage-collector</code> (or <code>pnpm add -D @teamscale/coverage-collector</code>).</p><p>After installing the package it should be registered in the <code>package.json</code> and be available locally for being executed. Please check the <a href="https://www.npmjs.com/package/@teamscale/coverage-collector" target="_blank" rel="noreferrer">NPM package registry</a> for the latest version of the package regularly.</p><p>Now we have to start the collector before testing is done and have to stop it after this process has been finished. For this, we propose to use <a href="https://www.npmjs.com/package/pm2" target="_blank" rel="noreferrer">the <code>pm2</code> package</a>. The usage of pm2 is illustrated by following scripts in a <code>package.json</code>:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>&quot;scripts&quot;: {</span></span>
<span class="line"><span>  &quot;collector&quot;: &quot;coverage-collector&quot;,</span></span>
<span class="line"><span>  &quot;pretest&quot;: &quot;npx pm2 delete CC; npx pm2 start npm --name CC -- run collector&quot;,</span></span>
<span class="line"><span>  &quot;test&quot;: &quot;jest&quot;,</span></span>
<span class="line"><span>  &quot;posttest&quot;: &quot;npx pm2 delete CC&quot;</span></span>
<span class="line"><span>},</span></span></code></pre></div><p>Please see the <a href="https://docs.npmjs.com/cli/v8/using-npm/scripts" target="_blank" rel="noreferrer">npmjs documentation</a> for details on the <code>pre</code> and <code>post</code> scripts used in the above example.</p><p>That&#39;s it! Now the collector will receive the coverage information from the running application and generate the coverage reports.</p><h3 id="configuration" tabindex="-1">Configuration <a class="header-anchor" href="#configuration" aria-label="Permalink to &quot;Configuration&quot;">​</a></h3><p>To further configure the collector, have a look at the options in our <a href="/reference/coverage-profilers/teamscale-javascript-profiler/#options-1">Reference page</a>.</p><h2 id="uploading-coverage-for-inspection" tabindex="-1">Uploading Coverage for Inspection <a class="header-anchor" href="#uploading-coverage-for-inspection" aria-label="Permalink to &quot;Uploading Coverage for Inspection&quot;">​</a></h2><p>When the code to be tested was instrumented and the collector is running, code coverage will be produced and collected when running the code.</p><p>You can use the configuration you created in Teamscale&#39;s UI under <strong>Project Configuration</strong> &gt; <strong>Coverage Profilers</strong> to configure the collector to upload coverage directly to Teamscale. See the <a href="/reference/coverage-profilers/teamscale-javascript-profiler/#coverage-collection-options">list available collector options</a>. Alternatively, the default setting of the collector is to write coverage files to disk in the <a href="/reference/upload-formats-and-samples/#example-file-for-teamscale-simple-coverage">Teamscale Simple Coverage Format</a>.</p><p>Whenever a testing process has been finished (for example, in the build pipeline), the coverage can be provided to Teamscale for being used, for example, for a <a href="/reference/test-gap-analysis/">Test Gap Analysis</a>. This can be done by using the <a href="https://github.com/cqse/teamscale-upload" target="_blank" rel="noreferrer">Teamscale Upload Tool</a> or by using the REST API directly. More details can be found in the corresponding <a href="/howto/uploading-external-data/">documentation</a>.</p><p>The collector can also be configured to send the collected coverage directly to a Teamscale server. The upload is enabled by setting the URL of the Teamscale server using parameter <code>--teamcale-server-url</code> along with Teamcale credentials and parameters that define the target project and commit of the upload.</p><h2 id="alternatives" tabindex="-1">Alternatives <a class="header-anchor" href="#alternatives" aria-label="Permalink to &quot;Alternatives&quot;">​</a></h2><p>The above approach works for all JavaScript applications that are run in the browser.</p><p>Some automated E2E testing frameworks, such as, <a href="https://www.cypress.io/" target="_blank" rel="noreferrer">Cypress</a>, can dump coverage information directly.</p><p>For unit tests, established tools such as <a href="https://jestjs.io/docs/cli#--coverageboolean" target="_blank" rel="noreferrer">Jest</a> can produce coverage reports.</p>`,46))])}const F=p(g,[["render",u]]);export{C as __pageData,F as default};
