import{_ as e,h as a,ak as i,g as t}from"./chunks/framework.BpCjdwm5.js";const n="/assets/generate_toml.DCPpMuqt.png",m=JSON.parse('{"title":"Teamscale IDE Configuration","description":"","frontmatter":{"title":"Teamscale IDE Configuration"},"headers":[],"relativePath":"reference/teamscale-toml/index.md","filePath":"reference/teamscale-toml/index.md"}'),l={name:"reference/teamscale-toml/index.md"};function o(p,s,r,h,c,d){return t(),a("div",null,s[0]||(s[0]=[i('<h1 id="teamscale-ide-configuration-file-format-teamscale-toml" tabindex="-1">Teamscale IDE Configuration File Format (<code>.teamscale.toml</code>) <a class="header-anchor" href="#teamscale-ide-configuration-file-format-teamscale-toml" aria-label="Permalink to &quot;Teamscale IDE Configuration File Format (`.teamscale.toml`)&quot;">​</a></h1><p>This article describes the uniform configuration file format used to configure the various <a href="./../supported-technologies/ides/">IDEs supported by Teamscale</a>.</p><div class="tip custom-block"><p class="custom-block-title">Auto-Generating the Configuration File</p><p>A basic configuration file sufficient for many project set-ups can be auto-generated by Teamscale. To do so, select <em>Configure IDE plug-ins / CLI</em> on the <em>Project Configuration &gt; Projects</em> page.</p><p><img src="'+n+`" alt="Generate a Configuration file" width="529" height="394"></p></div><h2 id="file-format-version-1-0" tabindex="-1">File format (Version 1.0) <a class="header-anchor" href="#file-format-version-1-0" aria-label="Permalink to &quot;File format (Version 1.0)&quot;">​</a></h2><p>The Teamscale IDE configuration is determined by one or more <code>.teamscale.toml</code> files stored in <a href="https://toml.io/" target="_blank" rel="noreferrer">TOML format</a>. Each file may set some properties, e.g., <code>server.url</code> or <code>project.id</code>, which may in turn be overridden by further, more specific <code>.teamscale.toml</code> files. This merging of configuration files makes it possible to succinctly describe even complex setups with a handful of small <code>.teamscale.toml</code> files.</p><p>In a single <code>.teamscale.toml</code> file, all properties are optional; thus, an empty file is a valid <code>.teamscale.toml</code> file. However, some properties must be set once all applicable <code>.teamscale.toml</code> files have been <a href="#merging-strategy">merged</a> into a Teamscale IDE configuration.</p><div class="language-toml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">toml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># The Teamscale IDE configuration file format version of this file.</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">version = </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;1.0&quot;</span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"> # Optional, default: 1.0</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Whether this is the root config file.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># If true, configuration discovery stops at this file and does not continue upwards to the filesystem root.</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">root = </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">false</span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"> # Optional, default: false</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">[</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">server</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">]</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># The URL of the Teamscale server.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># If set, it must match the URL of a server for which credentials (Username, Access Key) have been configured in the respective IDE.</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">url = </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;https://teamscale.io/&quot;</span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"> # Optional, but must be set in the merged configuration</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">[</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">]</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># The Project ID (or one of its Alternative Project IDs) of the Teamscale project.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Note that the Project ID may be different from the more prominently displayed Project Name.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">#</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># If a .teamscale.toml file sets the project.id and does not set project.path</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># explicitly, then it implicitly sets project.path = &quot;&quot; (i.e., associates the</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># current folder with the root folder of the Teamscale project).</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">id = </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;example&quot;</span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"> # Optional, but must be set in the merged configuration</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># The branch to use for retrieving data from the server.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># </span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># If empty or unset, the applicable branch is discovered from the VCS, with the</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Teamscale default branch being a fallback.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># If set and non-empty, branch auto-discovery is not used. Instead, the given branch is used</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">branch = </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;main&quot;</span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"> # Optional</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># The code path within the Teamscale project on the server.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">#</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Paths from parent configs will be overwritten.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># Forward-slashes are used as path separators.</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># If empty (i.e., path = &quot;&quot;), the Teamscale project root is used as code path.</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">path = </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;remote/path&quot;</span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"> # Optional</span></span></code></pre></div><p>A minimal valid config file may look like this using the alternate TOML syntax for nested keys:</p><div class="language-toml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">toml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">server.url = </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;https://teamscale.io/&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">project.id = </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;example&quot;</span></span></code></pre></div><p>Storing unrecognized properties in a <code>.teamscale.toml</code> is allowed. Hence, the following is allowed, even though the <code>server.contact</code> property is not defined in version 1.0 of the file format.</p><div class="language-toml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">toml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">[</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">server</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">url = </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;https://teamscale.io/&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">contact = </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;mailto:admin@teamscale.io&quot;</span></span></code></pre></div><h2 id="merging-strategy" tabindex="-1">Merging Strategy <a class="header-anchor" href="#merging-strategy" aria-label="Permalink to &quot;Merging Strategy&quot;">​</a></h2><p>The Discovery and merging strategy for <code>.teamscale.toml</code> files is similar to that of the well-known <a href="https://editorconfig.org/#file-location" target="_blank" rel="noreferrer"><code>.editorconfig</code> files</a>.</p><ul><li><p>A <code>.teamscale.toml</code> inherits all properties (except for <code>version</code> and <code>root</code>) from <code>.teamscale.toml</code> files stored in parent directories unless these are explicitly set, i.e., overridden. Thus, it is possible to store the server URL and project ID only once in a <code>.teamscale.toml</code> file placed in the repository root and set only the project path in <code>.teamscale.toml</code> files placed in subdirectories.</p></li><li><p>Discovery of further configuration files stops at a <code>.teamscale.toml</code> file with the <code>root</code> property set to <code>true</code>.</p></li></ul>`,14)]))}const g=e(l,[["render",o]]);export{m as __pageData,g as default};
