import{_ as a,h as t,ak as e,g as i}from"./chunks/framework.BpCjdwm5.js";const k=JSON.parse('{"title":"Upload Formats and Samples","description":"","frontmatter":{"title":"Upload Formats and Samples","pageClass":"wider-content"},"headers":[],"relativePath":"reference/upload-formats-and-samples/index.md","filePath":"reference/upload-formats-and-samples/index.md"}'),n={name:"reference/upload-formats-and-samples/index.md"};function o(l,s,r,d,p,h){return i(),t("div",null,s[0]||(s[0]=[e(`<h1 id="supported-upload-formats-and-samples" tabindex="-1">Supported Upload Formats and Samples <a class="header-anchor" href="#supported-upload-formats-and-samples" aria-label="Permalink to &quot;Supported Upload Formats and Samples&quot;">​</a></h1><p>Teamscale supports a variety of external formats (e.g., test coverage) that can be uploaded and will then included in the analysis (e.g., during Test Gap Analysis).</p><nav class="table-of-contents"><ul><li><a href="#supported-formats-for-upload">Supported Formats for Upload</a><ul><li><a href="#findings">Findings</a></li><li><a href="#coverage">Coverage</a></li><li><a href="#test-executions">Test Executions</a></li><li><a href="#other">Other</a></li></ul></li><li><a href="#example-for-xml-file-format-of-lauterbach-trace32-coverage-report">Example for XML File Format of Lauterbach Trace32 Coverage Report</a></li><li><a href="#example-for-json-file-format-for-teamscale-generic-findings">Example for JSON File Format for Teamscale Generic Findings</a></li><li><a href="#example-for-json-file-format-for-teamscale-non-code-metrics">Example for JSON File Format for Teamscale Non-Code Metrics</a></li><li><a href="#example-file-for-teamscale-simple-coverage">Example File for Teamscale Simple Coverage</a></li><li><a href="#example-file-for-teamscale-csv-issues">Example file for Teamscale CSV Issues</a></li><li><a href="#example-file-for-teamscale-csv-spec-items">Example file for Teamscale CSV Spec Items</a></li></ul></nav><h2 id="supported-formats-for-upload" tabindex="-1">Supported Formats for Upload <a class="header-anchor" href="#supported-formats-for-upload" aria-label="Permalink to &quot;Supported Formats for Upload&quot;">​</a></h2><p>This guide lists the report formats that Teamscale understands and gives some short hints on how to generate them. For an overview over how reports can be uploaded to Teamscale, take a look at <a href="./../../howto/uploading-external-data/">how to upload external analysis data to Teamscale</a>.</p><div class="tip custom-block"><p class="custom-block-title">Language-specific Coverage Tool Recommendations</p><p>If you want to setup a coverage tool, take a look at the <a href="./../../howto/setting-up-profiler-tga/">Coverage Profiler Overview</a> listing page.</p></div><h3 id="findings" tabindex="-1">Findings <a class="header-anchor" href="#findings" aria-label="Permalink to &quot;Findings&quot;">​</a></h3><table><tbody><tr><th>Report Format</th><th>Parameter Value</th><th>Remark</th><th>Programming Language(s)</th></tr><tr><td>Astree</td><td><code>ASTREE</code></td><td>Astree findings report format.<a href="https://www.absint.com/astree/index.htm">from AbsInt</a>. This is an XML format.</td><td>C/C++</td></tr><tr><td>C# Compiler Warning</td><td><code>CS_COMPILER_WARNING</code></td><td>C# Compiler warnings format.</td><td>C#</td></tr><tr><td>Clang</td><td><code>CLANG</code></td><td>Clang findings format.</td><td>C, C++, Objective C/C++</td></tr><tr><td>Cppcheck</td><td><code>CPPCHECK</code></td><td>Cppcheck results in XML format.</td><td>C/C++</td></tr><tr><td>FindBugs &amp; SpotBugs</td><td><code>FINDBUGS</code></td><td><a href="http://findbugs.sourceforge.net/">FindBugs</a> &amp; <a href="https://spotbugs.github.io/">SpotBugs</a> are static code analyzers for Java. SpotBugs is the successor fork of the unmaintained FindBugs project. Teamscale supports the old findings from FindBugs (some were not migrated to SpotBugs) as well as the new ones. For FindBugs findings which were migrated to SpotBugs, Teamscale shows the new finding message from SpotBugs. Findings produced by the <a href="https://find-sec-bugs.github.io"><i>Find Security Bugs</i></a> plug-in for Spotbugs are also supported. This is an XML format.</td><td>Java</td></tr><tr><td>FxCop</td><td><code>FXCOP</code></td><td>.NET findings report format.</td><td>C#</td></tr><tr><td>jQAssistant</td><td><code>JQASSISTANT</code></td><td><a href="https://jqassistant.org/">jQAssistant</a> is a quality assurance tool which allows to check for architecture and design rules. Teamscale supports the upload of jQAssistant&#39;s XML reports.</td><td>Java, Typescript, Javascript</td></tr><tr><td>Mypy</td><td><code>MYPY</code></td><td>Mypy (static type checker for Python) findings report format.</td><td>Python</td></tr><tr><td>Parasoft C/C++ test</td><td><code>PARASOFT_CPP_TEST</code></td><td>Parasoft C/C++ test.</td><td>C/C++</td></tr><tr><td>PC-Lint</td><td><code>PCLINT</code></td><td>PClint coverage report format.</td><td>C/C++</td></tr><tr><td>Pylint</td><td><code>PYLINT</code></td><td>Pylint (static analysis for Python) findings format.</td><td>Python</td></tr><tr><td>Roslyn</td><td><code>ROSLYN</code></td><td>The Roslyn (Microsoft .NET) compiler platform reports problems with the compiled C# or Visual Basic .NET code based on a set of configurable rules. The result file can be directly imported into Teamscale as external findings.</td><td>C#</td></tr><tr><td>SAP Code Inspector</td><td><code>SAP_CODE_INSPECTOR</code></td><td>The SAP Code Inspector format is a Teamscale-specific JSON findings report uploadable directly through Teamscale&#39;s Web UI. The JSON report is a list of inspector finding data objects.</td><td>ABAP</td></tr><tr><td>Simulink Model Advisor</td><td><code>MODEL_ADVISOR</code></td><td>Simulink Model Advisor generates HTML reports when it runs checks on models in Matlab.</td><td>Matlab</td></tr><tr><td>SpCop</td><td><code>SPCOP</code></td><td><a href="https://archive.codeplex.com/?p=sharepointcop">SpCop</a> (Sharepoint Code Analysis) findings report format. <b>Deprecated</b>: support for this format is deprecated and will be removed in Teamscale 2025.7.</td><td>C#</td></tr><tr><td>Teamscale Generic Findings</td><td><code>GENERIC_FINDINGS</code></td><td>A canonical file format for uploadings external findings to Teamscale. <a href="#example-for-json-file-format-for-teamscale-generic-findings">See example</a></td><td>-</td></tr></tbody></table><h3 id="coverage" tabindex="-1">Coverage <a class="header-anchor" href="#coverage" aria-label="Permalink to &quot;Coverage&quot;">​</a></h3><table><tbody><tr><th>Report Format</th><th>Parameter Value</th><th>Remark</th><th>Programming Languages(s)</th></tr><tr><td>Bullseye</td><td><code>BULLSEYE</code></td><td>Bullseye (C++) coverage report format.</td><td>C/C++</td></tr><tr><td>Clover</td><td><code>CLOVER</code></td><td><a href="https://www.atlassian.com/de/software/clover">Clover</a> is a test coverage format. Teamscale supports the upload of the XML report format of Clover.</td><td>Java, Groovy</td></tr><tr><td>Cobertura</td><td><code>COBERTURA</code></td><td><a href="https://github.com/cobertura/cobertura">Cobertura</a> is a format for Java test coverage. This is an XML format.</td><td>Java</td></tr><tr><td>Gcov</td><td><code>GCOV</code></td><td><a href="https://gcc.gnu.org/onlinedocs/gcc/Gcov-Intro.html">Gcov</a> is a profiling tool for code compiled with gcc. It comes with the gnu compiler collection. The reports are plaintext containing an annotated version of the source files. The reports usually have the <code>.gcov</code> file extension and contain plain text.</td><td>C/C++</td></tr><tr><td>Go Cover</td><td><code>GOLANG_COVERAGE</code></td><td><a href="https://golang.org/cmd/cover/">Go Cover</a> is a coverage format for Go.</td><td>Go</td></tr><tr><td>IEC Coverage</td><td><code>IEC_COVERAGE</code></td><td>Proprietary coverage format developed by Engel for upload of IEC coverage.</td><td></td></tr><tr><td>JaCoCo</td><td><code>JACOCO</code></td><td>JaCoCo (Java Code Coverage) xml report format. Teamscale needs the <strong>XML files</strong> exported from JaCoCo, as the JaCoCo-internal trace files (<code>.exec</code>) cannot be parsed.</td><td>Java</td></tr><tr><td>JetBrains dotCover</td><td><code>DOT_COVER</code></td><td><a href="https://www.jetbrains.com/dotcover/">dotCover</a> is a coverage format for .NET. Teamscale requires the <strong>detailed XML</strong> format variant, which includes statement-by-statement coverage. In ReSharper, use <code>Export to Detailed XML</code> to generate the detailed variant. To determine which variant a <code>.xml</code> file is in, look for &lt;File&gt; elements below &lt;Type&gt; and &lt;Statement&gt; elements below &lt;Method&gt; etc.; &lt;File&gt; and &lt;Statement&gt; are included only in the detailed XML variant.</td><td>C#</td></tr><tr><td>Lauterbach Trace32</td><td><code>LAUTERBACH_TRACE32</code></td><td>The <a href="https://www.lauterbach.com/frames.html?download_trace32.html">Lauterbach Trace32 Software</a> allows recording trace based coverage on hardware for various chip families. For more information about collecting coverage see the <a href="https://www2.lauterbach.com/pdf/app_code_coverage.pdf">Application Note for Trace-Based Code Coverage</a> or watch the <a href="https://support.lauterbach.com/kb/videos">tutorial videos</a>. Teamscale parses the coverage information from the mixed source/object code view in the coverage XML files for individual functions (i.e. <code>func-*.xml</code> files) generated by the Trace32 software. The XML files with coverage for individual functions can be imported into Teamscale. When uploading the XML files via the REST API to Teamscale import all <code>func-*.xml</code> files in one upload session. The coverage is converted into line coverage. Source lines of code in the report which are not fully covered but have corresponding object code which is executed are marked as partially covered in Teamscale. <a href="#example-for-xml-file-format-of-lauterbach-trace32-coverage-report">See example XML report</a>.</td><td>C/C++</td></tr><tr><td>Lcov</td><td><code>LCOV</code></td><td><a href="https://github.com/linux-test-project/lcov">Lcov</a> is a frontend for gcov from the Linux Test Project (LTP). The format is plaintext containing lines that start, for example, with <code>SF:</code>, <code>DA:</code>, , <code>TN:</code>, <code>BRDA:</code>, <code>BRF:</code>. The file ends with <code>end_of_record</code>.</td><td>JavaScript, C/C++, Dart</td></tr><tr><td>LLVM Coverage</td><td><code>LLVM</code></td><td><a href="https://llvm.org/docs/CoverageMappingFormat.html">LLVM Coverage</a> format</td><td>Ada, C/C++, Delphi, Fortran, Kotlin, Objective-C, Swift</td></tr><tr><td>Microsoft Coverage</td><td><code>MS_COVERAGE</code></td><td>MS Coverage report format (CQSE Coverage Merger). <strong style="color:orange;">Deprecated, use VS_COVERAGE instead.</strong></td><td></td></tr><tr><td>OpenCover</td><td><code>OPEN_COVER</code></td><td><a href="https://github.com/OpenCover/opencover">OpenCover</a> is a .NET coverage format (Windows only). Teamscale supports the upload of the XML report format.</td><td>C#</td></tr><tr><td>Raw Testwise Coverage</td><td><code>RAW_TESTWISE</code></td><td>A Teamscale-specific coverage format that allows to express coverage information on a per test level. It can be produced from Bullseye reports via the <a href="../cli/teamscale-build/#the-coverage-raw-testwise-command">teamscale-build</a> tool.</td><td>C, C++</td></tr><tr><td>Teamscale Compact Coverage</td><td><code>TEAMSCALE_COMPACT_COVERAGE</code></td><td>A Teamscale-specific coverage format to reduce the amount of data uploaded to and processed by the Teamscale instance. <a href="teamscale-compact-coverage/">See reference and example</a></td><td>-</td></tr><tr><td>Teamscale Simple Coverage</td><td><code>SIMPLE</code></td><td>A Teamscale-specific coverage format that has a very simple syntax designed for easy testing. <a href="#example-file-for-teamscale-simple-coverage">See example</a></td><td></td></tr><tr><td>Testwise Coverage</td><td><code>TESTWISE_COVERAGE</code></td><td>A Teamscale-specific coverage format that allows to express coverage information on a per test level. <a href="testwise-coverage/">See reference and example</a></td><td>Java</td></tr><tr><td>Testwell CTC++</td><td><code>CTC</code></td><td><a href="http://www.testwell.fi/ctcdesc.html">CTC coverage</a> is a coverage format from for C/C++. This is an XML format with <code>ctc_xml_report</code> as root node.</td><td>C/C++</td></tr><tr><td>Visual Studio Coverage</td><td><code>VS_COVERAGE</code></td><td>MS Coverage report format (Visual Studio Coverage Merger). Generated by the MSTest Coverage Collector or Microsoft Performance Tool in Visual Studio. The resulting <code>.coverage</code> binary files have to be <a href="/howto/setting-up-profiler-tga/cs/#visual-studio-tfs-mstest-code-coverage/">converted to XML</a> before uploading them to Teamscale.</td><td>C/C++, C#</td></tr><tr><td>Xcode Test Coverage</td><td><code>XCODE</code></td><td>Line coverage data in txt format from Xcode (<code>xccov</code>). Details on how to create a corresponding report can be found in the article on <a href="../../howto/setting-up-external-tools/#xcode-test-coverage">XCode Test Coverage</a></td><td>Swift</td></tr><tr><td>XR.Baboon </td><td><code>XR_BABOON</code></td><td><a href="https://github.com/inorton/XR.Baboon">XR.Baboon</a> was originally intended as a code coverage format for C# on .NET/Mono, but was later extended to support C and C++ as well.</td><td>C#, C/C++</td></tr><tr><td>J-Link/Ozone coverage</td><td><code>JLINK_CSV</code></td><td>Coverage from the Segger J-Link hardware debugger that has been converted to a CSV via <a href="https://www.segger.com/products/development-tools/ozone-j-link-debugger/technology/trace-reports/">Segger Ozone</a>.</td><td>C/C++</td></tr></tbody></table><h3 id="test-executions" tabindex="-1">Test Executions <a class="header-anchor" href="#test-executions" aria-label="Permalink to &quot;Test Executions&quot;">​</a></h3><table><tbody><tr><th>Report Format</th><th>Parameter Value</th><th>Remark</th><th>Programming Language(s)</th></tr><tr><td>Boost.Test</td><td><code>BOOST_TEST</code></td><td>Boost.Test format for test results</td><td>C/C++</td></tr><tr><td>JUnit</td><td><code>JUNIT</code></td><td><a href="https://junit.org">JUnit</a> (Java unit tests) format for test results</td><td>Java</td></tr><tr><td>Microsoft Test</td><td><code>MS_TEST</code></td><td>MS Test format for test results. Teamscale will process the <code>.trx</code> files (XML format)</td><td>C#</td></tr><tr><td>NUnit</td><td><code>NUNIT</code></td><td><a href="https://nunit.org/">NUnit</a> (.Net unit tests) format for test results. NUnit version 2 and 3 are supported.</td><td>C#</td></tr><tr><td>Testwise Coverage</td><td><code>TESTWISE_COVERAGE</code></td><td>A Teamscale-specific coverage format that allows to express coverage information on a per test level. <a href="testwise-coverage/">See reference and example</a></td><td>Java</td></tr><tr><td>XCResult JSON</td><td><code>XCRESULT_JSON</code></td><td>XCResult test execution reports in JSON format. Note that uploading the <code>*.xcresult</code> file is not possible, as it has to <a href="../../howto/setting-up-external-tools/#xcode-test-coverage"> be converted to JSON.</a></td><td>Swift</td></tr><tr><td>XUnit</td><td><code>XUNIT</code></td><td>XUnit (.NET unit tests) format for test results.</td><td>C#</td></tr></tbody></table><h3 id="other" tabindex="-1">Other <a class="header-anchor" href="#other" aria-label="Permalink to &quot;Other&quot;">​</a></h3><table><tbody><tr><th>Report Format</th><th>Parameter Value</th><th>Remark</th><th>Programming Language</th></tr><tr><td>JSON Compilation Database</td><td><code>COMPILATION_DATABASE</code></td><td>A <a href="https://clang.llvm.org/docs/JSONCompilationDatabase.html">compilation database</a> containing include paths and preprocessor defined to increase analysis precision. <a href="https://llvm.org/docs/CoverageMappingFormat.html">LLVM Coverage</a> format</td><td>C/C++</td></tr><tr><td>Teamscale Custom Artifacts Metrics</td><td><code>GENERIC_NON_CODE</code></td><td>A canonical file format for uploading non-code metrics to Teamscale. <a href="#example-for-json-file-format-for-teamscale-non-code-metrics">See example</a></td><td>-</td></tr></tbody></table><h2 id="example-for-xml-file-format-of-lauterbach-trace32-coverage-report" tabindex="-1">Example for XML File Format of Lauterbach Trace32 Coverage Report <a class="header-anchor" href="#example-for-xml-file-format-of-lauterbach-trace32-coverage-report" aria-label="Permalink to &quot;Example for XML File Format of Lauterbach Trace32 Coverage Report&quot;">​</a></h2><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;?</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">xml</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;1.0&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> encoding</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;iso-8859-1&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> standalone</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;no&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> ?&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;?</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">xml-stylesheet</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> type</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;text/xsl&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> href</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;t32transform.xsl&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">?&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">TRACE32</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> file</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;C:\\T32\\demo\\t32cast\\eca\\mcdc\\coverage\\coverage\\func-p-8000988-8000a0f.xml&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">coverage</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">COVerage.EXPORT.ListLine</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> ts</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;1618396955&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> t32ver</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;S.2021.04.000134317MXD&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> t32pv</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;ARM&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> cpu</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;RM57L843-ZWT&quot;</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">                                  metric</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;mcdc&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            ...</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">COVerage.EXPORT.ListLine</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">coverage</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">marker</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">BookMark.EXPORT</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> ts</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;1618396955&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> t32ver</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;S.2021.04.000134317MXD&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> t32pv</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;ARM&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> cpu</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;RM57L843-ZWT&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">BookMark.EXPORT</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">marker</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">listing</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">List.EXPORT</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> ts</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;1618396955&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> t32ver</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;S.2021.04.000134317MXD&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> t32pv</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;ARM&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> order</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;source&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            ...</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">List.EXPORT</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">listing</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">TRACE32</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div><h2 id="example-for-json-file-format-for-teamscale-generic-findings" tabindex="-1">Example for JSON File Format for Teamscale Generic Findings <a class="header-anchor" href="#example-for-json-file-format-for-teamscale-generic-findings" aria-label="Permalink to &quot;Example for JSON File Format for Teamscale Generic Findings&quot;">​</a></h2><div class="language-json vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">json</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">[</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;path&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;com/acme/Foo.java&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;findings&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;findingTypeId&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;myfinding-1&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;message&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Invalid construct&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;startLine&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">14</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;endLine&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">14</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  },</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;path&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;com/acme/Foo2.java&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;findings&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;findingTypeId&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;myfinding-2&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;message&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Range not defined&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;startLine&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">12</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;endLine&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">44</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;assessment&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;RED&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      },</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;findingTypeId&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;myfinding-3&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;message&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Finding with offsets&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;startOffset&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">1234</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;endOffset&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">2345</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">]</span></span></code></pre></div><h2 id="example-for-json-file-format-for-teamscale-non-code-metrics" tabindex="-1">Example for JSON File Format for Teamscale Non-Code Metrics <a class="header-anchor" href="#example-for-json-file-format-for-teamscale-non-code-metrics" aria-label="Permalink to &quot;Example for JSON File Format for Teamscale Non-Code Metrics&quot;">​</a></h2><div class="language-json vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">json</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">[</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;path&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;metric1/value1&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;count&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">15</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  },</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;path&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;metric1/value2&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;count&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">42</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;content&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;some text&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;assessment&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;RED&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">5</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;YELLOW&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">3</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;GREEN&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">1</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    },</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;time&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">3.145</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">]</span></span></code></pre></div><h2 id="example-file-for-teamscale-simple-coverage" tabindex="-1">Example File for Teamscale Simple Coverage <a class="header-anchor" href="#example-file-for-teamscale-simple-coverage" aria-label="Permalink to &quot;Example File for Teamscale Simple Coverage&quot;">​</a></h2><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>com/acme/Foo.java</span></span>
<span class="line"><span>5</span></span>
<span class="line"><span>7</span></span>
<span class="line"><span>9-12</span></span>
<span class="line"><span>com/acme/Foo2.java</span></span>
<span class="line"><span>45</span></span>
<span class="line"><span>46</span></span>
<span class="line"><span>47</span></span>
<span class="line"><span>48-50</span></span>
<span class="line"><span>51-55</span></span></code></pre></div><h2 id="example-file-for-teamscale-csv-issues" tabindex="-1">Example file for Teamscale CSV Issues <a class="header-anchor" href="#example-file-for-teamscale-csv-issues" aria-label="Permalink to &quot;Example file for Teamscale CSV Issues&quot;">​</a></h2><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>id,subject,assignee,author,description,created,updated,status,closed,url,parent</span></span>
<span class="line"><span>1,Broken Navigation,Bob,Bob,Broken Navigation,1,1,OPEN,false,,</span></span></code></pre></div><h2 id="example-file-for-teamscale-csv-spec-items" tabindex="-1">Example file for Teamscale CSV Spec Items <a class="header-anchor" href="#example-file-for-teamscale-csv-spec-items" aria-label="Permalink to &quot;Example file for Teamscale CSV Spec Items&quot;">​</a></h2><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>id,subject,assignee,author,description,created,updated,status,closed,url,additional_assignees,linkRoles,linkedRequirements,type,typeAbbreviation,parent,optOne,optTwo</span></span>
<span class="line"><span>1,Add included classes in renaming,Bob,Bob,Adding support for CSS function radial-gradient,1,1,closed,true,,,,,System Requirement,SR,3,An optional Field,Another optional field</span></span></code></pre></div>`,26)]))}const E=a(n,[["render",o]]);export{k as __pageData,E as default};
