import{_ as e,h as s,ak as t,g as a}from"./chunks/framework.BpCjdwm5.js";const k=JSON.parse('{"title":"Testwise Coverage","description":"","frontmatter":{"title":"Testwise Coverage","pageClass":"wider-content"},"headers":[],"relativePath":"reference/upload-formats-and-samples/testwise-coverage/index.md","filePath":"reference/upload-formats-and-samples/testwise-coverage/index.md"}'),n={name:"reference/upload-formats-and-samples/testwise-coverage/index.md"};function l(o,i,r,h,d,p){return a(),s("div",null,i[0]||(i[0]=[t(`<h1 id="testwise-coverage" tabindex="-1">Testwise Coverage <a class="header-anchor" href="#testwise-coverage" aria-label="Permalink to &quot;Testwise Coverage&quot;">​</a></h1><nav class="table-of-contents"><ul><li><a href="#report-format">Report Format</a><ul><li><a href="#preliminaries">Preliminaries</a></li><li><a href="#testwisecoveragereport">TestwiseCoverageReport</a></li><li><a href="#fileinfo">FileInfo</a></li><li><a href="#testinfo">TestInfo</a></li><li><a href="#executionunit">ExecutionUnit</a></li></ul></li><li><a href="#sample-file">Sample File</a></li></ul></nav><h2 id="report-format" tabindex="-1">Report Format <a class="header-anchor" href="#report-format" aria-label="Permalink to &quot;Report Format&quot;">​</a></h2><p>Testwise Coverage is a Teamscale-specific coverage format that allows to express coverage information on a per test level.</p><div class="tip custom-block"><p class="custom-block-title">Versions</p><p>There are two versions of this report format. Version 2 is supported in Teamscale 7.8 and later. Version 1 is still supported for backwards compatibility. This document describes the version 2 of the Testwise Coverage report format. You can still find the <a href="./version_1/">documentation of the version 1 format here</a>.</p></div><h3 id="preliminaries" tabindex="-1">Preliminaries <a class="header-anchor" href="#preliminaries" aria-label="Permalink to &quot;Preliminaries&quot;">​</a></h3><ul><li>Uniform path <ul><li>File path like string that represents a hierarchy. Parts of the hierarchy are delimited by slashes.</li></ul></li><li>Line range string <ul><li>String containing line ranges and individual lines separated by commas.</li><li>Compact representation of a set of lines of code.</li><li>Example: <code>&quot;10-12,13,22-27,40&quot;</code></li></ul></li></ul><h3 id="testwisecoveragereport" tabindex="-1">TestwiseCoverageReport <a class="header-anchor" href="#testwisecoveragereport" aria-label="Permalink to &quot;TestwiseCoverageReport&quot;">​</a></h3><p>The top level JSON object is the <code>TestwiseCoverageReport</code>. It contains the following attributes:</p><table><tbody><tr><td style="line-height:1.6;"><code>version</code></td><td><code>int</code></td><td>required</td><td><ul><li>The version for the format described here should be <code>2</code>.</li><li>Version number for the Testwise Coverage report version.</li><li>If not given the parser will fall back to version 1 of the Testwise Coverage format.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>partial</code></td><td><code>bool</code></td><td>optional</td><td><ul><li> If set to <code>true</code> the set of tests contained in the report don&#39;t represent the full set of tests. These tests are added or updated in Teamscale, but no tests that are missing in the report will be deleted. </li><li>If not provided defaults to <code>false</code>.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>files</code></td><td><code>Array&lt;FileInfo&gt;</code></td><td>required</td><td><ul><li>See section for <a href="#fileinfo"><code>FileInfo</code></a>.</li><li><code>FileInfo</code>s are referenced elsewhere in the report by their index within the array.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>executionUnits</code></td><td><code>Array&lt;ExecutionUnit&gt;</code></td><td>optional</td><td><ul><li>See section for <a href="#executionunit"><code>ExecutionUnit</code></a>.</li><li>Defaults to the empty array if omitted.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>tests</code></td><td><code>Array&lt;TestInfo&gt;</code></td><td>optional</td><td><ul><li>See section for <a href="#testinfo"><code>TestInfo</code></a>.</li><li>Defaults to the empty array if omitted.</li></ul></td></tr></tbody></table><h3 id="fileinfo" tabindex="-1">FileInfo <a class="header-anchor" href="#fileinfo" aria-label="Permalink to &quot;FileInfo&quot;">​</a></h3><p>Information about a covered file. It contains the following attributes.</p><table><tbody><tr><td style="line-height:1.6;"><code>path</code></td><td><code>string</code></td><td>required</td><td><ul><li>Code path within the repository.</li><li> Ideally the exact relative path from the repository root. Otherwise, the path will be resolved to the longest matching suffix in Teamscale. </li></ul></td></tr><tr><td style="line-height:1.6;"><code>coverableLines</code></td><td><code>string</code></td><td>optional</td><td><ul><li>Line range string for the lines in the source code that are considered coverable by the coverage tool, i.e. are reported with execution counts =0 or &gt;0.</li><li>If omitted Teamscale will determine coverable lines heuristically based on source code.</li></ul></td></tr></tbody></table><h3 id="testinfo" tabindex="-1">TestInfo <a class="header-anchor" href="#testinfo" aria-label="Permalink to &quot;TestInfo&quot;">​</a></h3><table><tbody><tr><td style="line-height:1.6;"><code>uniformPath</code></td><td><code>string</code></td><td>required</td><td><ul><li>A unique hierarchical identifier of the test with <code>/</code> as separator.</li><li>If this is a parameterized test the test may occur multiple times with different parameters.</li><li>E.g. Java package name / test class name / test method name</li></ul></td></tr><tr><td style="line-height:1.6;"><code>parameters</code></td><td><code>Array&lt;{value:string, name?:string}&gt;</code></td><td>optional</td><td><ul><li>A list of parameters with which the test has been executed.</li><li>The value describes the parameters value.</li><li>The name is optional and denotes the name of the parameter.</li><li>The order of the parameters in the list is significant.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>hash</code></td><td><code>string</code></td><td>optional</td><td><ul><li>A hash determining the version of the test implementation.</li><li>E.g. SHA-1 hash of a test description XML or a revision number of the test specification.</li><li>If the value changes the test is considered as impacted.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>duration</code></td><td><code>float</code></td><td>required</td><td> The duration in seconds it took to execute the test. </td></tr><tr><td style="line-height:1.6;"><code>result</code></td><td><code>string</code></td><td>required</td><td> Describes the result of the test execution. Can be one of: <ul><li><code>PASSED</code> Test execution was successful.</li><li><code>IGNORED</code> The test is currently marked as &quot;do not execute&quot; (e.g. JUnit <code>@Ignore</code> or <code>@Disabled</code>).</li><li><code>SKIPPED</code> Caused by a failing assumption.</li><li><code>INCONCLUSIVE</code> Test assertions cannot be verified.</li><li><code>FAILURE</code> Caused by a failing assertion.</li><li><code>ERROR</code> Caused by an error during test execution (e.g., exception thrown).</li></ul> Tests that did not pass previously are always selected for test execution. </td></tr><tr><td style="line-height:1.6;"><code>message</code></td><td><code>string</code></td><td>optional</td><td>Error message and stacktrace or skip reason.</td></tr><tr><td style="line-height:1.6;"><code>coverage</code></td><td><code>Map&lt;string,string&gt;</code></td><td>optional</td><td> A map of strings to line range strings. The keys are the integer indexes in string form of the <code>FileInfo</code> objects in the top-level <code>files</code> array. The values are the line range strings representing the covered lines. </td></tr><tr><td style="line-height:1.6;"><code>associatedSpecItems</code></td><td><code>List&lt;string&gt;</code></td><td>optional</td><td> A list of specification items that this test verifies. An ID can be specified using a combination of requirements tracing connector name and specification item ID (e.g. <code>req-connector|spec-item-id</code>) or using a format matching the <i>Specification item ID pattern</i> option if this option has been set in the respective connector. </td></tr></tbody></table><h3 id="executionunit" tabindex="-1">ExecutionUnit <a class="header-anchor" href="#executionunit" aria-label="Permalink to &quot;ExecutionUnit&quot;">​</a></h3><p>Represents a set of tests that is executed together. An execution unit in the Testwise Coverage report can either contain a subset or all of the tests that are executed as one unit. Examples include test binaries built for C/C++ code or test Jar files for Java code. During the build process, all tests included in an execution unit will be executed at once to avoid overhead. It contains the following attributes.</p><table><tbody><tr><td style="line-height:1.6;"><code>uniformPath</code></td><td><code>string</code></td><td>required</td><td><ul><li>A unique hierarchical identifier of the test with <code>/</code> as separator.</li><li>E.g. unique path to executable or Jar file.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>hash</code></td><td><code>string</code></td><td>optional</td><td><ul><li>A hash determining the version of the execution unit.</li><li>E.g. SHA-1 hash of test resources.</li><li>If the value changes the execution unit is considered to be impacted.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>duration</code></td><td><code>float</code></td><td>required</td><td> The duration in seconds it took to execute the execution unit. </td></tr><tr><td style="line-height:1.6;"><code>result</code></td><td><code>string</code></td><td>required</td><td><ul><li>The overall result of the execution of the execution unit. Can be one of:</li><ul><li><code>PASSED</code> Execution was successful.</li><li><code>IGNORED</code> The execution unit is currently ignored.</li><li><code>SKIPPED</code> Caused by a failing assumption.</li><li><code>INCONCLUSIVE</code> Test assertions cannot be verified.</li><li><code>FAILURE</code> Caused by a failing assertion.</li><li><code>ERROR</code> Caused by an error during test execution (e.g., exception thrown).</li></ul><li>May differ from the combined result of tests contained in the execution unit.</li><li>If the value changes the execution unit is considered to be impacted.</li></ul> Execution units that did not pass previously are always selected for execution in the context of Test Impact Analysis. </td></tr><tr><td style="line-height:1.6;"><code>coverage</code></td><td><code>Map&lt;string,string&gt;</code></td><td>required</td><td><ul><li> A map of strings to line range strings. The keys are the integer indexes in string form of the <code>FileInfo</code> objects in the top-level <code>files</code> array. The values are the line range strings representing the covered lines. </li><li>The coverage produced by executing all the tests in the execution unit.</li><li>Present if test coverage can&#39;t be obtained for each test in the execution unit individually.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>tests</code></td><td><code>Array&lt;TestInfo&gt;</code></td><td>optional</td><td><ul><li>See section for <code>TestInfo</code>.</li><li>The set of tests that are executed in this execution unit.</li><li>In the UI these tests will be shown in the hierarchy below the execution unit.</li></ul></td></tr></tbody></table><h2 id="sample-file" tabindex="-1">Sample File <a class="header-anchor" href="#sample-file" aria-label="Permalink to &quot;Sample File&quot;">​</a></h2><p>The following JSON sample file combines the necessary data described above.</p><div class="language-json vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">json</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;version&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">2</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;partial&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">true</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;files&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;path&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;example_project/src/com/example/project/Calculator.java&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    },</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;path&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;example_project/test-src/com/example/project/CalculatorTest.java&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  ],</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;tests&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;uniformPath&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;com/example/project/CalculatorTest/testAddition()&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;duration&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">1.5</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;result&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;PASSED&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;coverage&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;0&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;20-24,26,27,29&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;1&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;17-22&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    },</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;uniformPath&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;com/example/project/CalculatorTest/testSubtraction()&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;duration&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">2.0</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;result&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;PASSED&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;coverage&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;0&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;20-24,26,27,29&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;1&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;17-22&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  ],</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;executionUnits&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;uniformPath&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;unit-tests/calculator-tests&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;hash&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;74E9F552F9543754373D4F07EB9D190E746A574A&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;coverage&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;0&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;20-24,27,29&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">        &quot;1&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;19-25&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      },</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;tests&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;uniformPath&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;com/example/project/CalculatorTest/testMultiplication()&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;duration&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">3.0</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;result&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;PASSED&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        },</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;uniformPath&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;com/example/project/CalculatorTest/testDivision()&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;duration&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">4.0</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;result&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;PASSED&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;associatedSpecItems&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">            &quot;requirements-connector1|DP-3&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">            &quot;requirements-connector1|DP-4&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">          ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div>`,21)]))}const u=e(n,[["render",l]]);export{k as __pageData,u as default};
