import{_ as h,h as d,ak as i,j as e,x as t,O as s,z as o,L as l,g as p}from"./chunks/framework.BpCjdwm5.js";const m="/assets/jira-integration-render-problem.BWda3VWI.png",u="/assets/jira-integration-expected.BRNDnphK.png",g="/assets/worker-log-filter.BllloCxG.png",f="/assets/code-inspector-excludes.Ciz65zZx.png",I=JSON.parse('{"title":"Troubleshooting","description":"","frontmatter":{"title":"Troubleshooting"},"headers":[],"relativePath":"troubleshooting/index.md","filePath":"troubleshooting/index.md"}'),y={name:"troubleshooting/index.md"},k={id:"first-exclude-all-generated-code",tabindex:"-1"},b={id:"second-adjust-memory-settings",tabindex:"-1"},v={id:"third-limiting-concurrent-executions-of-system-processes",tabindex:"-1"},w={class:"details custom-block"};function E(T,a,x,A,S,P){const r=l("Badge"),n=l("PluginTabsTab"),c=l("PluginTabs");return p(),d("div",null,[a[16]||(a[16]=i('<h1 id="troubleshooting-known-issues" tabindex="-1">Troubleshooting Known Issues <a class="header-anchor" href="#troubleshooting-known-issues" aria-label="Permalink to &quot;Troubleshooting Known Issues&quot;">​</a></h1><p>This page collects known problems that you might encounter when working with Teamscale along with their respective solutions.</p><nav class="table-of-contents"><ul><li><a href="#teamscale-does-not-start-web-interface-is-not-reachable">Teamscale Does Not Start: Web Interface Is Not Reachable</a></li><li><a href="#teamscale-cannot-be-accessed-invalid-sni">Teamscale cannot be accessed: Invalid SNI</a></li><li><a href="#teamscale-shows-a-blank-page-when-accessing-through-a-reverse-proxy">Teamscale shows a blank page when accessing through a Reverse Proxy</a></li><li><a href="#teamscale-redirects-to-an-internal-url-when-accessing-through-a-reverse-proxy">Teamscale redirects to an internal URL when accessing through a Reverse Proxy</a></li><li><a href="#teamscale-does-not-start-invalid-maximum-heap-size-xmx4096m">Teamscale Does Not Start: Invalid maximum heap size: -Xmx4096m</a></li><li><a href="#teamscale-does-not-start-on-macs-with-mx-cpu-arm-incompatible-architecture">Teamscale Does Not Start on Macs with Mx CPU (ARM): Incompatible Architecture</a></li><li><a href="#teamscale-docker-container-does-not-start-error-java-home-is-not-set-and-no-java-command-could-be-found-in-your-path">Teamscale Docker Container Does not Start: &#39;ERROR: JAVA_HOME is not set and no &#39;java&#39; command could be found in your PATH</a></li><li><a href="#lost-administration-access">Lost Administration Access</a></li><li><a href="#teamscale-runs-into-memory-related-problems">Teamscale Runs Into Memory-Related Problems</a><ul><li><a href="#problem-description">Problem Description</a></li><li><a href="#addressing-the-memory-problems">Addressing the Memory Problems</a></li></ul></li><li><a href="#analysis-is-slow">Analysis is Slow</a><ul><li><a href="#insufficient-io-throughput">Insufficient IO Throughput</a></li><li><a href="#virus-scanner">Virus Scanner</a></li><li><a href="#insufficient-database-cache">Insufficient Database Cache</a></li></ul></li><li><a href="#jira-does-not-render-teamscale-annotations-correctly">Jira Does Not Render Teamscale Annotations Correctly</a></li><li><a href="#teamscale-login-does-not-work-when-embedded-in-an-iframe">Teamscale Login does not work when embedded in an iframe</a></li><li><a href="#cross-site-request-forgery-csrf-errors">Cross-Site-Request-Forgery (CSRF) Errors</a></li><li><a href="#vsix-installer-crashes-when-manually-installing-teamscale-s-visual-studio-extension">Vsix-Installer Crashes When Manually Installing Teamscale&#39;s Visual Studio Extension</a></li><li><a href="#transportexception-object-too-large-when-using-git-connector">TransportException: Object too large When Using Git Connector</a></li><li><a href="#largeobjectexception-encountered-large-object-when-using-git-connector">LargeObjectException: Encountered large object When Using Git Connector</a></li><li><a href="#some-urls-do-not-work-when-running-as-azure-app-service">Some URLs Do Not Work When Running As Azure App Service</a></li><li><a href="#wrong-version-of-clang-tidy-or-llvm">Wrong Version of clang-tidy (or LLVM)</a></li><li><a href="#wrong-version-of-psscriptanalyzer">Wrong Version of PSScriptAnalyzer</a></li><li><a href="#wrong-version-of-cppcheck">Wrong Version of cppcheck</a></li><li><a href="#teamscale-dashboard-cannot-be-accessed-404-not-found">Teamscale Dashboard cannot be accessed: 404 Not Found</a></li><li><a href="#no-users-can-be-assigned-to-quality-control-tasks">No users can be assigned to Quality Control Tasks</a></li><li><a href="#sap-connection-the-sap-jco-library-has-not-been-loaded">SAP Connection: The SAP JCo library has not been loaded</a></li><li><a href="#sap-connection-the-teamscale-technical-user-seems-to-create-or-modify-objects">SAP Connection: The Teamscale technical user seems to create or modify objects</a></li><li><a href="#sap-connection-does-not-import-new-code-anymore">SAP Connection Does Not Import New Code Anymore</a><ul><li><a href="#problem-description-1">Problem Description</a></li><li><a href="#inspecting-the-worker-log">Inspecting the Worker Log</a></li><li><a href="#error-export-configuration-locked">Error: Export Configuration Locked</a></li><li><a href="#error-crash-in-the-sap-system">Error: Crash in the SAP system</a></li><li><a href="#error-timeout">Error: Timeout</a></li><li><a href="#error-sap-connection-fails-with-error-cca-is-not-filled-yet-too-early-to-run-atc-check">Error: SAP Connection fails with error &quot;CCA is not filled yet. Too early to run ATC check&quot;</a></li></ul></li><li><a href="#test-coverage-is-missing-in-teamscale">Test coverage is missing in Teamscale</a><ul><li><a href="#teamscale-java-profiler">Teamscale Java Profiler</a></li></ul></li><li><a href="#teamscale-integration-for-eclipse">Teamscale Integration for Eclipse</a><ul><li><a href="#cannot-install-eclipse-integration">Cannot Install Eclipse Integration</a></li></ul></li><li><a href="#teamscale-integration-for-intellij">Teamscale Integration for IntelliJ</a><ul><li><a href="#intellij-integration-forgets-server-settings">IntelliJ Integration Forgets Server Settings</a></li></ul></li></ul></nav><h2 id="teamscale-does-not-start-web-interface-is-not-reachable" tabindex="-1">Teamscale Does Not Start: Web Interface Is Not Reachable <a class="header-anchor" href="#teamscale-does-not-start-web-interface-is-not-reachable" aria-label="Permalink to &quot;Teamscale Does Not Start: Web Interface Is Not Reachable&quot;">​</a></h2><p>You are trying to start Teamscale, but the web interface (usually located at <a href="http://localhost:8080" target="_blank" rel="noreferrer">http://localhost:8080</a>) is not reachable.</p><p><strong>Check the log files:</strong> There are several locations where logs are written that may contain helpful information about why Teamscale is not starting:</p><ul><li>Directory <code>logs</code> in the <a href="./../reference/administration-ts-installation/#separate-working-data-from-installation-files">Teamscale working directory</a>.</li><li>If Teamscale is installed as windows a service: <code>windows/*.log</code></li><li>The logging facilities of the service executing Teamscale: <code>docker logs</code> or <code>journalctl</code> for systemd units.</li></ul><p>If you are unsure which entries in the log file are related to the startup problem, you can rename the old logs, then restart Teamscale. It will automatically create new log files.</p><p><strong>Check your <code>JAVA_HOME</code> setting:</strong> If you have recently updated Java, please ensure that <code>JAVA_HOME</code> points to the right directory. If you&#39;re running Teamscale as a service, please also check the relevant service configuration files under <code>TEAMSCALE_INSTALL_DIR/windows</code> and <code>TEAMSCALE_INSTALL_DIR/linux</code>.</p><p><strong>Disable SSL:</strong> If you have SSL enabled, please try commenting out all options starting with <code>https</code> in <code>config/teamscale.properties</code> to temporarily disable SSL. If this works, you now know that a faulty SSL configuration is causing the startup problems.</p><p><strong>Access Teamscale via <code>localhost</code>:</strong> While debugging startup problems, test Teamscale&#39;s availability by accessing it via <code>localhost</code> on the machine where it is installed. If this works but accessing it via the server/hostname does not, you now know that a network problem (firewall, missing connectivity) is causing Teamscale to not be available.</p><p><strong>Run Teamscale manually:</strong> If you are running Teamscale as a service, try running it via <code>teamscale.sh</code> or <code>teamscale.bat</code> instead. If this works, you now know that there is a problem with your service setup (e.g. running as a different user with missing permissions or path misconfiguration).</p><h2 id="teamscale-cannot-be-accessed-invalid-sni" tabindex="-1">Teamscale cannot be accessed: <code>Invalid SNI</code> <a class="header-anchor" href="#teamscale-cannot-be-accessed-invalid-sni" aria-label="Permalink to &quot;Teamscale cannot be accessed: `Invalid SNI`&quot;">​</a></h2><p>The behavior you see is an intended security mechanism that verifies that the certificate matches the host name. If you still want to allow non-matching certificates, this can be achieved by setting the <code>-Dcom.teamscale.ssl.skip-sni-host-check=true</code> JVM property in <code>config/jvm.properties</code>.</p><p>Although this property works around the issue, we strongly recommend setting up the proper certificate instead.</p><h2 id="teamscale-shows-a-blank-page-when-accessing-through-a-reverse-proxy" tabindex="-1">Teamscale shows a blank page when accessing through a Reverse Proxy <a class="header-anchor" href="#teamscale-shows-a-blank-page-when-accessing-through-a-reverse-proxy" aria-label="Permalink to &quot;Teamscale shows a blank page when accessing through a Reverse Proxy&quot;">​</a></h2><p>If attempts to access Teamscale via a reverse proxy, such as NGINX, result in a blank page, it&#39;s probable that the reverse proxy isn&#39;t configured appropriately. You might find it helpful to inspect your browser&#39;s console for potential issues. To access the console, follow the steps outlined in <a href="https://balsamiq.com/support/faqs/browserconsole/" target="_blank" rel="noreferrer">this guide</a>, which provides instructions for various browsers. Should an error like <code>Content-Security-Policy: default-src &#39;self&#39;; connect-src ...;</code> appear in the console, it&#39;s a strong indication that the NGINX configuration needs adjustment.</p><p>For assistance in configuring the reverse proxy, kindly refer to our guide on <a href="./../howto/configuring-reverse-proxy/#nginx">Accessing Teamscale via Reverse Proxy</a>. Please pay close attention to the <code>X-Forwarded-...</code> headers; they need to be accurately set to reflect the URL schema, domain, port, and path prefix of how Teamscale is exposed to the user.</p><h2 id="teamscale-redirects-to-an-internal-url-when-accessing-through-a-reverse-proxy" tabindex="-1">Teamscale redirects to an internal URL when accessing through a Reverse Proxy <a class="header-anchor" href="#teamscale-redirects-to-an-internal-url-when-accessing-through-a-reverse-proxy" aria-label="Permalink to &quot;Teamscale redirects to an internal URL when accessing through a Reverse Proxy&quot;">​</a></h2><p>If attempts to access Teamscale via a reverse proxy, such as NGINX, result in an immediate redirect to an NGINX internal URL, it&#39;s very likely that the reverse proxy isn&#39;t configured appropriately.</p><p>For assistance in configuring the reverse proxy, kindly refer to our guide on <a href="./../howto/configuring-reverse-proxy/#nginx">Accessing Teamscale via Reverse Proxy</a>. Please pay close attention to the <code>X-Forwarded-...</code> headers; they need to be accurately set to reflect the URL schema, domain, port, and path prefix of how Teamscale is exposed to the user.</p><h2 id="teamscale-does-not-start-invalid-maximum-heap-size-xmx4096m" tabindex="-1">Teamscale Does Not Start: <code>Invalid maximum heap size: -Xmx4096m</code> <a class="header-anchor" href="#teamscale-does-not-start-invalid-maximum-heap-size-xmx4096m" aria-label="Permalink to &quot;Teamscale Does Not Start: `Invalid maximum heap size: -Xmx4096m`&quot;">​</a></h2><p>When starting Teamscale fails with an error message like <code>Invalid maximum heap size: -Xmx4096m</code>, this is most likely caused by using a 32-bit Java Virtual Machine (JVM). Teamscale <a href="./../reference/system-requirements/#system-requirements-for-analysis-server">requires</a> a 64-bit JVM.</p><h2 id="teamscale-does-not-start-on-macs-with-mx-cpu-arm-incompatible-architecture" tabindex="-1">Teamscale Does Not Start on Macs with Mx CPU (ARM): Incompatible Architecture <a class="header-anchor" href="#teamscale-does-not-start-on-macs-with-mx-cpu-arm-incompatible-architecture" aria-label="Permalink to &quot;Teamscale Does Not Start on Macs with Mx CPU (ARM): Incompatible Architecture&quot;">​</a></h2><p>When starting Teamscale on macOS fails with an <code>UnsatisfiedLinkError</code> and the error message contains the text <code>mach-o file, but is an incompatible architecture (have &#39;x86_64&#39;, need &#39;arm64&#39;)</code>, this indicates failure in loading the LevelDB library. This is because LevelDB is not supported on ARM-based Macs and you will need to switch to a RocksDB or Xodus database for Teamscale to start. You can do so by changing the <code>database.type</code> option in the <code>teamscale.properties</code> file as described <a href="./../reference/administration-ts-installation/#primary-settings-–-teamscale-properties">here</a>.</p><h2 id="teamscale-docker-container-does-not-start-error-java-home-is-not-set-and-no-java-command-could-be-found-in-your-path" tabindex="-1">Teamscale Docker Container Does not Start: &#39;ERROR: JAVA_HOME is not set and no &#39;java&#39; command could be found in your PATH <a class="header-anchor" href="#teamscale-docker-container-does-not-start-error-java-home-is-not-set-and-no-java-command-could-be-found-in-your-path" aria-label="Permalink to &quot;Teamscale Docker Container Does not Start: &#39;ERROR: JAVA_HOME is not set and no &#39;java&#39; command could be found in your PATH&quot;">​</a></h2><p>When the Teamscale Docker container fails with an error message like <code>ERROR: JAVA_HOME is not set and no &#39;java&#39; command could be found in your PATH</code>, this is most likely caused by a too old docker version. Teamscale <a href="./../howto/installing-teamscale/installing-with-docker/#prerequisites">requires</a> Docker 20.10.10.</p><h2 id="lost-administration-access" tabindex="-1">Lost Administration Access <a class="header-anchor" href="#lost-administration-access" aria-label="Permalink to &quot;Lost Administration Access&quot;">​</a></h2><p>In case no user with administrator privileges can log in anymore, you can restore the default admin account. Start Teamscale with the <a href="./../reference/administration-ts-installation/#jvm-settings-jvm-properties">JVM property</a> <code>-Dcom.teamscale.force-create-admin</code>. This will recreate the default admin account, so you log in again as <code>admin</code> using the default password <code>admin</code>. The default admin account will be deleted on the next backup import.</p><h2 id="teamscale-runs-into-memory-related-problems" tabindex="-1">Teamscale Runs Into Memory-Related Problems <a class="header-anchor" href="#teamscale-runs-into-memory-related-problems" aria-label="Permalink to &quot;Teamscale Runs Into Memory-Related Problems&quot;">​</a></h2><p>If you face a memory-related problem in Teamscale, this section may help you remedy the issue.</p><h3 id="problem-description" tabindex="-1">Problem Description <a class="header-anchor" href="#problem-description" aria-label="Permalink to &quot;Problem Description&quot;">​</a></h3><p>Teamscale is running out of memory while fetching data or analyzing the code (often after a drastic slow-down due to the JVM trying to free memory) . A line similar to this one appears in the log files or the worker log:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>java.io.IOException: java.lang.OutOfMemoryError: Java heap space</span></span></code></pre></div><h3 id="addressing-the-memory-problems" tabindex="-1">Addressing the Memory Problems <a class="header-anchor" href="#addressing-the-memory-problems" aria-label="Permalink to &quot;Addressing the Memory Problems&quot;">​</a></h3>',35)),e("h4",k,[a[0]||(a[0]=t("First: Exclude all Generated Code ")),s(r,{text:"Requires Re-Analysis",type:"warning"}),a[1]||(a[1]=t()),a[2]||(a[2]=e("a",{class:"header-anchor",href:"#first-exclude-all-generated-code","aria-label":'Permalink to "First: Exclude all Generated Code <Badge text="Requires Re-Analysis" type="warning" />"'},"​",-1))]),a[17]||(a[17]=i('<p>The main source of problems when Teamscale runs out of memory is when the clone detection tries to find clones on large chunks of generated (often highly similar) code. Therefore, the first solution should be to <strong>exclude any generated code</strong> in the project you are analyzing. For that, you will need to <a href="./../reference/ui/project/project/">edit the configuration</a> of the affected project.</p><ul><li><p>Using <strong>path</strong> patterns:</p><p>For example, to exclude all code that lives in the folder <code>gen-src</code>, use the following exclude patterns on the <strong>Excluded File Names</strong> project setting: <code>**/gen-src/**</code></p><p>The exclusion patterns are regular <a href="https://ant.apache.org/manual/dirtasks.html#patterns" target="_blank" rel="noreferrer">ant include patterns</a></p></li><li><p>Using file <strong>content</strong> patterns:</p><p>If excluding code by using directory structures does not work, you can use the advanced field <strong>Content Exclude</strong>. Use this to exclude files by their content, using regular expressions. For example to exclude all files that contain the documentation string <code>generated by Visual Studio</code>, add the pattern: <code>.*generated by Visual Studio.*</code></p></li></ul><div class="warning custom-block"><p class="custom-block-title">Re-Analysis Required</p><p>Please note that changes to these project options will require a re-analysis of the project.</p></div>',3)),e("h4",b,[a[3]||(a[3]=t("Second: Adjust Memory Settings ")),s(r,{text:"Requires Restart"}),a[4]||(a[4]=t()),a[5]||(a[5]=e("a",{class:"header-anchor",href:"#second-adjust-memory-settings","aria-label":'Permalink to "Second: Adjust Memory Settings <Badge text="Requires Restart" />"'},"​",-1))]),a[18]||(a[18]=i('<p>If you have excluded all your generated source code and Teamscale still runs out of memory, you can adjust the amount of memory used by Teamscale.</p><h5 id="reserving-additional-memory" tabindex="-1">Reserving Additional Memory <a class="header-anchor" href="#reserving-additional-memory" aria-label="Permalink to &quot;Reserving Additional Memory&quot;">​</a></h5><p>This can be done by editing <code>$TEAMSCALE_HOME/config/jvm.properties</code> file. Adjust the value of the <code>JVM_MEMORY</code> parameter, for example by reserving up to 16 gigabytes of RAM: <code>JVM_MEMORY=16G</code></p><h5 id="reducing-the-number-of-workers" tabindex="-1">Reducing the Number of Workers <a class="header-anchor" href="#reducing-the-number-of-workers" aria-label="Permalink to &quot;Reducing the Number of Workers&quot;">​</a></h5><p>If your Teamscale server does not have more memory that ought to be reserved, you can also adjust the number of workers that Teamscale should use. This can be done in the <code>teamscale.properties</code> (<code>config</code> folder) via the <code>engine.workers</code> property.</p><div class="warning custom-block"><p class="custom-block-title">Performance Impact</p><p>Note that this will likely slow down the analysis, as Teamscale can parallelize less processes.</p></div><p>As a rule of thumb, we recommend to <em>reserve 2 GB of memory for each Teamscale worker</em>. However, due to varying analysis setups, this is only the <em>lower bound</em> to keep in mind.</p>',7)),e("h4",v,[a[6]||(a[6]=t("Third: Limiting concurrent executions of system processes ")),s(r,{text:"Requires Restart"}),a[7]||(a[7]=t()),a[8]||(a[8]=e("a",{class:"header-anchor",href:"#third-limiting-concurrent-executions-of-system-processes","aria-label":'Permalink to "Third: Limiting concurrent executions of system processes <Badge text="Requires Restart" />"'},"​",-1))]),a[19]||(a[19]=i('<p>If Teamscale still runs into memory problems, another cause could be external processes requiring too much memory, leaving not enough for the JVM.</p><h5 id="background" tabindex="-1">Background <a class="header-anchor" href="#background" aria-label="Permalink to &quot;Background&quot;">​</a></h5><p>Some Teamscale features require the execution of processes outside the JVM, e.g. Clang-tidy, Cppcheck or Swiftlint. Teamscale cannot limit the amount of memory consumed by these tools. If the underlying server is already close to its memory limits and then lots of these tools are run in parallel, it could be that there is not enough memory available for Teamscale anymore.</p><h5 id="limiting-the-number-of-concurrent-executions" tabindex="-1">Limiting the number of concurrent executions <a class="header-anchor" href="#limiting-the-number-of-concurrent-executions" aria-label="Permalink to &quot;Limiting the number of concurrent executions&quot;">​</a></h5><p>In order to limit the number of external processes started by Teamscale, set the system property <code>com.teamscale.external-process.maximum-concurrency</code> to your desired value.</p><div class="warning custom-block"><p class="custom-block-title">Performance Impact</p><p>Note that this will likely slow down the analysis, as Teamscale can parallelize less processes.</p></div><p>As a rule of thumb, we recommend using the number of configured workers. If Teamscale still runs out of memory, try adjusting the value to a lower number.</p><h4 id="still-experiencing-problems" tabindex="-1">Still Experiencing Problems? <a class="header-anchor" href="#still-experiencing-problems" aria-label="Permalink to &quot;Still Experiencing Problems?&quot;">​</a></h4><p>In case Teamscale&#39;s analysis is still affected by out-of-memory problems, please don&#39;t hesitate to <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">contact our support</a>.</p><h2 id="analysis-is-slow" tabindex="-1">Analysis is Slow <a class="header-anchor" href="#analysis-is-slow" aria-label="Permalink to &quot;Analysis is Slow&quot;">​</a></h2><p>There are several factors that may influence Teamscale&#39;s analysis performance:</p><h3 id="insufficient-io-throughput" tabindex="-1">Insufficient IO Throughput <a class="header-anchor" href="#insufficient-io-throughput" aria-label="Permalink to &quot;Insufficient IO Throughput&quot;">​</a></h3><p>Teamscale&#39;s analyses are mostly IO-bound, meaning the higher the throughput of your hard disk, the faster the analyses will run. This is the single factor that influences Teamscale&#39;s overall performance the most. In case you are experiencing unsatisfactory performance, please <a href="./../reference/administration-ts-installation/#disk-performance">measure the performance of your hard disks</a> and compare it to our <a href="./../reference/administration-ts-installation/#disk-performance">reference table</a>.</p><p>For this reason, we generally recommend running Teamscale on local SSDs, not on network-attached storage.</p><h3 id="virus-scanner" tabindex="-1">Virus Scanner <a class="header-anchor" href="#virus-scanner" aria-label="Permalink to &quot;Virus Scanner&quot;">​</a></h3><p>Many virus scanners are known to have a severe negative impact on the performance of Teamscale&#39;s analyses. Slowdown may be up to 100%. Thus, we recommend you place the following directories on your virus scanner&#39;s allow list, i.e., to exempt them from scanning:</p><ul><li><strong>Teamscale&#39;s Installation Directory:</strong> The directory where you installed Teamscale.</li><li><strong>Database Directory:</strong> By default, this will be the <code>storage</code> directory within your Teamscale installation directory. However, this location can be changed by setting the <code>database.directory</code> properties in your <a href="./../reference/administration-ts-installation/#primary-settings-teamscale-properties"><code>teamscale.properties</code> configuration file.</a>.</li><li><strong>Process Working Directory:</strong> This will contain e.g. clones of analyzed Git repositories. Which exact directory this is depends on which directory you start Teamscale from. In many cases, this will be the same as Teamscale&#39;s installation directory. However, this can be changed by configuring the Docker installation, service definition file or startup scripts (depending on how you installed Teamscale).</li><li><strong>Teamscale Working Directory:</strong> This is configured in your Teamscale instance under <em>Admin</em> &gt; <em>Settings</em> &gt; <em>Server Settings</em>. If you did not explicitly configure this, it will be a subdirectory of the system temp directory. This contains certain temporary files that are created during the source code analysis.</li><li><strong>JVM Temp Directory:</strong> Used for temporary files created outside the source code analysis. By default, this will be the temp directory used by your operating system (On Windows: <code>%USERPROFILE%\\AppData\\Local\\Temp</code> for user processes and <code>C:\\Windows\\Temp</code> for services; on macOS/Linux: <code>/tmp</code>). However, this location can be changed by adding a <code>-Djava.io.tmpdir=...</code> argument to the <code>JVM_EXTRA_ARGS</code> variable in your <code>jvm.properties</code> configuration file.</li></ul><p>Some virus scanners also have the option to white-list certain processes. In this case, we recommend you additionally white-list <code>java.exe</code> and all child-processes it creates.</p><div class="warning custom-block"><p class="custom-block-title">Trend Micro</p><p>Recent versions of Trend Micro can cause significant performance degradation unless configured exactly as specified above. The configuration option with the biggest impact on Teamscale performance is to white-list <code>java.exe</code>. Directory excludes alone will still result in bad performance.</p></div><h3 id="insufficient-database-cache" tabindex="-1">Insufficient Database Cache <a class="header-anchor" href="#insufficient-database-cache" aria-label="Permalink to &quot;Insufficient Database Cache&quot;">​</a></h3><p>The default setting for Teamscale&#39;s database cache is meant for small to medium instances. For large instances, you will need to <a href="./../reference/administration-ts-installation/#database-cache">increase the database cache</a>. This will usually provide a moderate speed-up of the analysis and a significant speed-up of hot-path queries to the API and web interface (e.g. often-used dashboards).</p><h2 id="jira-does-not-render-teamscale-annotations-correctly" tabindex="-1">Jira Does Not Render Teamscale Annotations Correctly <a class="header-anchor" href="#jira-does-not-render-teamscale-annotations-correctly" aria-label="Permalink to &quot;Jira Does Not Render Teamscale Annotations Correctly&quot;">​</a></h2><p>Teamscale can annotate Jira tickets with the finding/test-gap information aggregated over commits for that ticket. This can be enabled in the Jira connector in the project settings.</p><p>If it looks like in the following screenshot, Jira does not render the markdown content correctly:</p><p><img src="'+m+'" alt="Jira Integration Render Problem" width="720" height="223" data-zoom="true"></p><p>This problem can be solved by configuring Jira to the <strong>wiki style</strong> renderer:</p><ol><li>Log in to JIRA as a JIRA administrator.</li><li>Navigate to <em>Administration</em> &gt; <em>Issues</em> &gt; <em>Field Configurations</em>.</li><li>Click on the <em>Configure</em> link for the field configuration used by the field to which Teamscale writes.</li><li>Click on the <em>Renders</em> link for the field to change.</li><li>Select the new renderer type from the <em>Active Renderer</em> drop-down list. Select the <strong>Wiki style</strong> renderer.</li><li>Click on <em>Update</em> to apply the change.</li></ol><p>Afterwards, Teamscale&#39;s annotations in Jira ticket should be rendered properly:</p><p><img src="'+u+'" alt="Working Jira Integration" width="647" height="150" data-zoom="true"></p><h2 id="teamscale-login-does-not-work-when-embedded-in-an-iframe" tabindex="-1">Teamscale Login does not work when embedded in an iframe <a class="header-anchor" href="#teamscale-login-does-not-work-when-embedded-in-an-iframe" aria-label="Permalink to &quot;Teamscale Login does not work when embedded in an iframe&quot;">​</a></h2><p>Some use cases might make it necessary to show Teamscale within an iframe for example to embed it within the dashboard of another web application like Jira. This means that requests within the iframe are performed cross-site as the site name of Teamscale does not match with the site of the containing page. Modern browsers only allow sending cookies cross-site if they are transmitted over a secure connection. Therefore Teamscale must be accessed via HTTPS to work correctly within an iframe as its login mechanism uses cookies. When you terminate HTTPS not directly within Teamscale, but at the load balancer e.g. nginx, Teamscale needs to be made aware of this fact.</p><p>This can be achieved by configuring your <a href="./../howto/configuring-reverse-proxy/">reverse proxy</a> to pass the <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Proto" target="_blank" rel="noreferrer">header</a> <code>X-Forwarded-Proto: https</code> to Teamscale. This enables the <code>Secure</code> attribute from login cookies even if no HTTPS was configured within Teamscale.</p><div class="warning custom-block"><p class="custom-block-title">WARNING</p><p>Your browser needs to be configured to accept cookies from third party sites, which is the default setting unless overridden by e.g. corporate group policy rules. E.g. in Chrome this setting is called <em>Block third-party cookies</em> under <em>Cookies and other site data</em>.</p><p>If your the setting is enforced the only workaround is manually specifying the site holding the iframe as exception under <em>Sites that can always use cookies</em>. Ensure that <em>Including third-party cookies on this site</em> is enabled.</p></div><h2 id="cross-site-request-forgery-csrf-errors" tabindex="-1">Cross-Site-Request-Forgery (CSRF) Errors <a class="header-anchor" href="#cross-site-request-forgery-csrf-errors" aria-label="Permalink to &quot;Cross-Site-Request-Forgery (CSRF) Errors&quot;">​</a></h2><p>If access to a Teamscale instance is being managed by an external server such as NGINX (which is a recommended practice), it may be necessary to adapt the header settings to accommodate the cross site request forgery guarding mechanisms built into Teamscale. Specifically, this is the case when an error message appears containing the text <code>X-Requested-By header is missing</code>.</p><p>To fix this, insert the following line in your NGINX configuration file at the appropriate place (e.g., the server you want to configure):</p><div class="language-nginx vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">nginx</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">add_header </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;Access-Control-Allow-Headers&#39;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;X-Requested-By&#39;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">;</span></span></code></pre></div><p>Another possible cause could be that you have configured your NGINX to rewrite the session cookie to a HttpOnly cookie. To solve this issue, remove the HttpOnly option in your NGINX configuration:</p>',38)),s(c,null,{default:o(()=>[s(n,{label:"NGINX version < 1.19.3"},{default:o(()=>a[9]||(a[9]=[e("div",{class:"language-nginx vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"nginx"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"# WRONG: This configuration breaks the CSRF protection mechanism")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"proxy_cookie_path "),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"/ "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"/; Secure; HttpOnly; SameSite=None"'),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},";")]),t(`
`),e("span",{class:"line"}),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"# CORRECT: The configuration should not add the HttpOnly flag")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"proxy_cookie_path "),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"/ "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"/; Secure; SameSite=None"'),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},";")])])])],-1)])),_:1,__:[9]}),s(n,{label:"NGINX version >= 1.19.3"},{default:o(()=>a[10]||(a[10]=[e("div",{class:"language-nginx vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"nginx"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"# WRONG: This configuration breaks the CSRF protection mechanism")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"proxy_cookie_flags ~"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," secure httponly samesite=none;")]),t(`
`),e("span",{class:"line"}),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"# CORRECT: The configuration should not add the HttpOnly flag")]),t(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"proxy_cookie_flags ~"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," secure samesite=none;")])])])],-1)])),_:1,__:[10]})]),_:1}),a[20]||(a[20]=i(`<p>Please refer to <a href="https://security.stackexchange.com/questions/175536/does-a-csrf-cookie-need-to-be-httponly/175540#175540" target="_blank" rel="noreferrer">this post</a> for details.</p><h2 id="vsix-installer-crashes-when-manually-installing-teamscale-s-visual-studio-extension" tabindex="-1">Vsix-Installer Crashes When Manually Installing Teamscale&#39;s Visual Studio Extension <a class="header-anchor" href="#vsix-installer-crashes-when-manually-installing-teamscale-s-visual-studio-extension" aria-label="Permalink to &quot;Vsix-Installer Crashes When Manually Installing Teamscale&#39;s Visual Studio Extension&quot;">​</a></h2><p>When installing the Teamscale Visual Studio Extension in Visual Studio 2015 on Windows 10, a <code>XamlParseException</code> similar to following error may occur:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>System.Windows.Markup.XamlParseException was unhandled</span></span>
<span class="line"><span>Message: An unhandled exception of type &#39;System.Windows.Markup.XamlParseException&#39; occurred in PresentationFramework.dll</span></span></code></pre></div><p>As a workaround, the extension can be installed manually via the command line as follows:</p><div class="language-powershell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">powershell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">\\path\\to\\visualstudio\\Common7\\IDE\\</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">VSIXInstaller.exe</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> /</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">q </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&lt;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">YOUR</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">-</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">TEAMSCALE_EXTENSION.vsix</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span></span></code></pre></div><h2 id="transportexception-object-too-large-when-using-git-connector" tabindex="-1"><code>TransportException: Object too large</code> When Using Git Connector <a class="header-anchor" href="#transportexception-object-too-large-when-using-git-connector" aria-label="Permalink to &quot;\`TransportException: Object too large\` When Using Git Connector&quot;">​</a></h2><p>The Git connector reports this error when a Git repository that contains a file larger than 2 GB is connected to Teamscale. This is due to internal limitations of the Java Git implementation, which unfortunately cannot be circumvented.</p><p>A possible workaround is to clone the repository with a native Git client, which doesn&#39;t have this limitation, and then exclude the problematic file from Teamscale analysis:</p><ol><li>In the workspace directory, execute <code>git clone --bare $REPO_URL</code>.</li><li>Add the Git connector to the Teamscale project in question.</li><li>When configuring the Git connector, use the <em>Excluded file names</em> option to exclude the respective file from analysis.</li></ol><p>Another option is to remove the offending file from the history of the Git repository entirely, e.g., if it was added by accident. This <a href="https://stackoverflow.com/questions/10622179/how-can-i-find-identify-large-commits-in-git-history" target="_blank" rel="noreferrer">StackOverflow question</a> has some pointers on how to perform such an operation.</p><h2 id="largeobjectexception-encountered-large-object-when-using-git-connector" tabindex="-1"><code>LargeObjectException: Encountered large object</code> When Using Git Connector <a class="header-anchor" href="#largeobjectexception-encountered-large-object-when-using-git-connector" aria-label="Permalink to &quot;\`LargeObjectException: Encountered large object\` When Using Git Connector&quot;">​</a></h2><p>The Git connector reports this error when a file larger than 50MB is read from Git. It is recommended to exclude the file from analysis using the <em>Excluded file names</em> option in the Git connector.</p><p>If you need to analyze the file, e.g., when reading coverage reports from Git, specify a higher threshold (in MB) using the <a href="./../reference/administration-ts-installation/#jvm-arguments">JVM argument</a> <code>-Dcom.teamscale.git-largefile-threshold-mb</code>.</p><h2 id="some-urls-do-not-work-when-running-as-azure-app-service" tabindex="-1">Some URLs Do Not Work When Running As Azure App Service <a class="header-anchor" href="#some-urls-do-not-work-when-running-as-azure-app-service" aria-label="Permalink to &quot;Some URLs Do Not Work When Running As Azure App Service&quot;">​</a></h2><p>Azure App Service runs your application behind a proxy server. By default, this proxy will filter certain URLs, which can lead to pages not loading correctly in Teamscale. For example, all URLs ending in <code>.cs</code> are blocked by default.</p><p>To resolve this, you need to adjust the <code>web.config</code> file in the root of your App Service similar to the following example:</p><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;?</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">xml</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;1.0&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> encoding</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;UTF-8&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">?&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">configuration</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">system.webServer</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">handlers</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">add</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;httpplatformhandler&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> path</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;*&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> verb</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;*&quot;</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">                 modules</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;httpPlatformHandler&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> resourceType</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Unspecified&quot;</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">                 requireAccess</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Script&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> /&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">handlers</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">httpPlatform</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> stdoutLogEnabled</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;true&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> startupTimeLimit</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;300&quot;</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> startupRetryCount</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;0&quot;</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">                      processPath</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;%SystemRoot%\\System32\\WindowsPowerShell\\v1.0\\powershell.exe&quot;</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">                      arguments</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;%home%\\site\\wwwroot\\HttpPlatformHandlerStartup.ps1&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">httpPlatform</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">security</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">requestFiltering</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">hiddenSegments</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                    &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">clear</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> /&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">hiddenSegments</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">fileExtensions</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                    &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">clear</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> /&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">fileExtensions</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">requestFiltering</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">security</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">system.webServer</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">configuration</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div><h2 id="wrong-version-of-clang-tidy-or-llvm" tabindex="-1">Wrong Version of <code>clang-tidy</code> (or LLVM) <a class="header-anchor" href="#wrong-version-of-clang-tidy-or-llvm" aria-label="Permalink to &quot;Wrong Version of \`clang-tidy\` (or LLVM)&quot;">​</a></h2><p>Teamscale can execute clang-tidy on your C/C++/Objective-C source code and manage the reported findings. This feature requires that clang-tidy 17.0.6 is installed on the server. We require this exact version since the checks and check descriptions supported by clang-tidy are stored in Teamscale (the clang-tidy binary has no option to print all descriptions). Our docker images already come with a clang-tidy binary. With all other distributions, you need to install <a href="https://github.com/llvm/llvm-project/releases/tag/llvmorg-17.0.6" target="_blank" rel="noreferrer">clang-tidy 17.0.6</a> on the Teamscale server. We expect clang-tidy to be available as <code>clang-tidy-17</code> in the <code>PATH</code>. Alternatively you can specify the path to the executable via the <code>com.teamscale.clang-tidy-exe</code> VM property.</p><div class="tip custom-block"><p class="custom-block-title">Automatically Check the Clang Tidy Setup</p><p>Teamscale offers a REST service to verify whether clang-tidy is correctly installed: <code>&lt;TEAMSCALE_URL&gt;/api/verify/clang-tidy-setup</code>.</p></div><h2 id="wrong-version-of-psscriptanalyzer" tabindex="-1">Wrong Version of <code>PSScriptAnalyzer</code> <a class="header-anchor" href="#wrong-version-of-psscriptanalyzer" aria-label="Permalink to &quot;Wrong Version of \`PSScriptAnalyzer\`&quot;">​</a></h2><p>Teamscale can execute PSScriptAnalyzer on your PowerShell source code and manage the reported findings. This feature requires that PSScriptAnalyzer 1.21.0 is installed on the server. We require this exact version since the checks and check descriptions supported by PSScriptAnalyzer are stored in Teamscale. Our docker images already come with a PowerShell binary and an installed PSScriptAnalyzer. With all other distributions, you need to install <a href="https://learn.microsoft.com/en-us/powershell/scripting/install/installing-powershell" target="_blank" rel="noreferrer">PowerShell</a> and <a href="https://learn.microsoft.com/de-de/powershell/utility-modules/psscriptanalyzer/overview?view=ps-modules#installing-psscriptanalyzer" target="_blank" rel="noreferrer">PSScriptAnalyzer version 1.21.0</a> on your Teamscale server. We expect PowerShell to be available as <code>pwsh</code> in the <code>PATH</code>. Alternatively you can specify the path to the executable via the <code>com.teamscale.powershell-exe</code> VM property.</p><div class="tip custom-block"><p class="custom-block-title">Automatically Check the PSScriptAnalyzer Setup</p><p>Teamscale offers a REST service to verify whether PowerShell and PSScriptAnalyzer are correctly installed: <code>&lt;TEAMSCALE_URL&gt;/api/verify/powershell-script-analyzer-setup</code>.</p></div><h2 id="wrong-version-of-cppcheck" tabindex="-1">Wrong Version of <code>cppcheck</code> <a class="header-anchor" href="#wrong-version-of-cppcheck" aria-label="Permalink to &quot;Wrong Version of \`cppcheck\`&quot;">​</a></h2><p>Teamscale can execute cppcheck on your C/C++ source code and manage the reported findings. This feature requires that cppcheck 2.17.1 is installed on the server. Our docker images already come with a cppcheck binary. With all other distributions, you need to install <a href="https://github.com/danmar/cppcheck/releases/tag/2.17.1" target="_blank" rel="noreferrer">cppcheck-2.17.1</a> on the Teamscale server.</p><div class="tip custom-block"><p class="custom-block-title">Automatically Check the Cppcheck Setup</p><p>Teamscale offers a REST service to verify whether cppcheck is correctly installed: <code>&lt;TEAMSCALE_URL&gt;/api/verify/cppcheck-setup</code>.</p></div><h2 id="teamscale-dashboard-cannot-be-accessed-404-not-found" tabindex="-1">Teamscale Dashboard cannot be accessed: 404 Not Found <a class="header-anchor" href="#teamscale-dashboard-cannot-be-accessed-404-not-found" aria-label="Permalink to &quot;Teamscale Dashboard cannot be accessed: 404 Not Found&quot;">​</a></h2><p>You are trying to access an existing Teamscale Dashboard, but Teamscale responds with the 404 Not Found error.</p><p><strong>Check NGINX reverse proxy configuration</strong>:</p><p>NGINX reverse proxy has the property of changing the encoding of URIs that are handled by the <code>proxy_pass</code> or <code>rewrite</code> directives in many cases. This can manifest in incorrect URIs that may be handled in an unexpected manner by the Teamscale routing framework. For example, the slash in <code>userName/dashboardName</code> used regularly when storing dashboards will be interpreted as a structural delimiter by the routing framework instead of a part of the path parameter if it is not given in the URL with a proper encoding. This will result in <code>404 Not Found</code> errors, since the routing framework is unable to locate a matching service endpoint. Use the <a href="./../howto/configuring-reverse-proxy/#nginx">suggested NGINX configuration</a> to remedy the problem.</p><h2 id="no-users-can-be-assigned-to-quality-control-tasks" tabindex="-1">No users can be assigned to Quality Control Tasks <a class="header-anchor" href="#no-users-can-be-assigned-to-quality-control-tasks" aria-label="Permalink to &quot;No users can be assigned to Quality Control Tasks&quot;">​</a></h2><p>You have created a new task in the <em>Tasks</em> view, but you cannot set the &quot;Assignee&quot; field to the correct user, as the user is not listed in the selection.</p><p>To be able to set the &quot;Assignee&quot;, you need &quot;View&quot; permissions on the user who you would like to assign. You can achieve this in the following ways:</p><ol><li>An administrator adds you and the assignee to the same user group.</li><li>An administrator adds &quot;View&quot; permissions for your user or user group in the <em>Admin</em> &gt; <em>Users</em> or <em>Admin</em> &gt; <em>Groups</em> views to be able to access the user or user group of the assignee.</li><li>An administrator adds a Global Role Assignment for your user or user group in the <em>Admin</em> &gt; <em>Roles</em> view to be able to access all users (setting the &quot;User&quot; domain and the &quot;Viewer&quot; role).</li></ol><h2 id="sap-connection-the-sap-jco-library-has-not-been-loaded" tabindex="-1">SAP Connection: The SAP JCo library has not been loaded <a class="header-anchor" href="#sap-connection-the-sap-jco-library-has-not-been-loaded" aria-label="Permalink to &quot;SAP Connection: The SAP JCo library has not been loaded&quot;">​</a></h2><p>You are trying to connect Teamscale to your SAP systems, but the settings page <em>Admin</em> &gt; <em>Settings</em> &gt; <em>SAP</em> shows the warning &quot;The SAP JCo library has not been loaded&quot;. Also, <em>System</em> &gt; <em>System Information</em> shows <em>SAP JCo version</em> as &quot;not loaded&quot; in the <em>Java VM</em> section.</p><p>Make sure you followed the <a href="./../tutorial/sap-integration/#installation-of-the-sap-java-connector">installation instructions</a>. If the issue is still not resolved, check the Teamscale log file at <code>logs/teamscale.log</code> for further information, or <a href="./../howto/creating-support-request/">send us a support request</a> for further assistance.</p><h2 id="sap-connection-the-teamscale-technical-user-seems-to-create-or-modify-objects" tabindex="-1">SAP Connection: The Teamscale technical user seems to create or modify objects <a class="header-anchor" href="#sap-connection-the-teamscale-technical-user-seems-to-create-or-modify-objects" aria-label="Permalink to &quot;SAP Connection: The Teamscale technical user seems to create or modify objects&quot;">​</a></h2><p>For entries in the <code>REPOSRC</code> table or the <code>TRDIR</code> view, the <code>CNAM</code> or <code>UNAM</code> columns may contain the name of the technical user used by Teamscale. This does not mean, however, that Teamscale silently created or changed source code in your customer namespace, as the entries are merely <code>==CS</code> includes belonging to global ABAP classes.</p><p>These <code>==CS</code> includes are used for the source-code-based class editor and contain the “complete source code” (hence the <code>CS</code> suffix) for the class. Because Teamscale needs to retrieve code for all ABAP classes in your namespace, the SAP system may first have to generate such a source-code-based representation. Only this representation will be generated under the Teamscale user account. The corresponding objects, however, will still contain the actual creators and modifiers, so tools like SE80, transport management, or the ABAP Development Tools for Eclipse will behave as expected and show the correct user accounts.</p><h2 id="sap-connection-does-not-import-new-code-anymore" tabindex="-1">SAP Connection Does Not Import New Code Anymore <a class="header-anchor" href="#sap-connection-does-not-import-new-code-anymore" aria-label="Permalink to &quot;SAP Connection Does Not Import New Code Anymore&quot;">​</a></h2><p>If one of your Teamscale projects does not show current ABAP code changes from your SAP system anymore, this section may help you remedy the issue. As a general recommendation, please make sure you are running the latest versions of both <a href="./../changelog/">Teamscale</a> and the <a href="./../tutorial/sap-integration/#installation-of-the-sap-connector">Teamscale Connector for SAP NetWeaver® AS ABAP®</a>.</p><h3 id="problem-description-1" tabindex="-1">Problem Description <a class="header-anchor" href="#problem-description-1" aria-label="Permalink to &quot;Problem Description&quot;">​</a></h3><p>Teamscale does not show recent ABAP code changes for one of the SAP systems connected via the Teamscale Connector for SAP NetWeaver® AS ABAP®. The most recent commit shown in the Activity perspective does not reflect current changes in the system.</p><h3 id="inspecting-the-worker-log" tabindex="-1">Inspecting the Worker Log <a class="header-anchor" href="#inspecting-the-worker-log" aria-label="Permalink to &quot;Inspecting the Worker Log&quot;">​</a></h3><p>The first thing to inspect is the worker log. In the <em>System</em> perspective, select the Worker Log entries for <em>Maintenance Jobs</em> and enter <code>abapsystem</code> into the <em>Regex</em> field:</p><p><img src="`+g+`" alt="Worker Log Filter" width="296" height="418"></p><p>Then click on the most recent error entry, and inspect the detailed log message.</p><h3 id="error-export-configuration-locked" tabindex="-1">Error: Export Configuration Locked <a class="header-anchor" href="#error-export-configuration-locked" aria-label="Permalink to &quot;Error: Export Configuration Locked&quot;">​</a></h3><h4 id="symptom" tabindex="-1">Symptom <a class="header-anchor" href="#symptom" aria-label="Permalink to &quot;Symptom&quot;">​</a></h4><p>The worker log entry contains a message like</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>Error occurred during ABAP export in SAP system</span></span>
<span class="line"><span>Unable to lock export for configuration id CQI_MUYWGCIN.</span></span>
<span class="line"><span>An other export for this configuration may be running.</span></span>
<span class="line"><span>Or an earlier export could not finish properly. Export aborted.</span></span></code></pre></div><div class="tip custom-block"><p class="custom-block-title">Check Shadow Mode Settings</p><p>Make sure you have only one Teamscale instance running in non-shadow mode and accessing the same Teamscale working directory.</p></div><h4 id="solution-teamscale-administrators" tabindex="-1">Solution (Teamscale Administrators) <a class="header-anchor" href="#solution-teamscale-administrators" aria-label="Permalink to &quot;Solution (Teamscale Administrators)&quot;">​</a></h4><p>Follow these steps if the SAP System has at least version 1902 of the Teamscale SAP Exporter installed.</p><ol><li>Log into Teamscale as an administrator</li><li>Click on the <i class="very large grey question icon"></i> icon in the top right corner and select <em>API Reference</em>.</li><li>Click on <em>Show Internal Services</em></li><li>Search for the service with name <em>sap-history-id-lock</em>. It is found under the SAP section as <em>/api/sap-history-id-lock/{sapConfigurationId}</em>.</li><li>Click <em>Try it out</em> and enter the SAP Connection ID. This is the identifier of the SAP connection in Teamscale at Admin &gt; Settings &gt; SAP. Then click <em>Execute</em>.</li><li>If the service responds with a return code of 204, the export configuration has been successfully unlocked.</li></ol><h4 id="solution-sap-system-administrators" tabindex="-1">Solution (SAP System Administrators) <a class="header-anchor" href="#solution-sap-system-administrators" aria-label="Permalink to &quot;Solution (SAP System Administrators)&quot;">​</a></h4><p>These steps are applicable if Teamscale SAP Exporter version &lt; 2007 is installed on the SAP system. Please endeavour to update to the latest version of the SAP Exporter available on our <a href="https://gitlab.com/cqse/teamscale/sap-abap-connector/-/releases" target="_blank" rel="noreferrer">releases page</a>.</p><ol><li>Log on to the SAP system using SAPGui.</li><li>Locate the database table <em>/CQSE/ABAPEXP</em> (e.g. in <em>SE11</em>)</li><li>In the entry with the <em>EXPORT_CONFIG_ID</em> from the error message, change <em>LOCKED</em> from <code>X</code> to <code></code>.</li></ol><h3 id="error-crash-in-the-sap-system" tabindex="-1">Error: Crash in the SAP system <a class="header-anchor" href="#error-crash-in-the-sap-system" aria-label="Permalink to &quot;Error: Crash in the SAP system&quot;">​</a></h3><p>Under certain conditions, the export in the SAP system can fail.</p><h4 id="symptom-1" tabindex="-1">Symptom <a class="header-anchor" href="#symptom-1" aria-label="Permalink to &quot;Symptom&quot;">​</a></h4><p>The worker log entry contains a line like</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>RfcException raised by system [CQR|abap-rel|00]:</span></span></code></pre></div><p>This means that an error occurred in the SAP system. In this case, we need more information from the SAP system.</p><h4 id="gathering-further-information" tabindex="-1">Gathering Further Information <a class="header-anchor" href="#gathering-further-information" aria-label="Permalink to &quot;Gathering Further Information&quot;">​</a></h4><ol><li>Note the time the error was logged in the worker log.</li><li>Log on to the SAP system using SAPGui.</li><li>Open transaction <em>ST22</em> and search for short dumps caused by the Teamscale user at the time noted in step 1.</li><li>Export the short dump into a text file</li><li>Send the file to <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">support@teamscale.com</a> or request a link to perform an HTTPS-secured upload</li><li>Our experts will investigate the reason for the crash and provide you with mitigation instructions</li></ol><h4 id="possible-reasons" tabindex="-1">Possible Reasons <a class="header-anchor" href="#possible-reasons" aria-label="Permalink to &quot;Possible Reasons&quot;">​</a></h4><p>There are a number of different things that can cause a code export to crash. Of course, our SAP connector heavily relies on SAP standard functionality. Sometimes these standard routines do not handle edge cases very well, which might lead to crashes. Our exporter does have extensive error handling functionality, but some conditions cannot be handled programmatically, but immediately lead to a dump, e.g. violation of <code>ASSERT</code> conditions, or unbound field symbols, to name just two.</p><p>These conditions can occur e.g. when Code Inspector is executed for an object with rarely used syntax, when DDIC information or function groups have become inconsistent because of some previous error condition unrelated to Teamscale.</p><h4 id="workarounds" tabindex="-1">Workarounds <a class="header-anchor" href="#workarounds" aria-label="Permalink to &quot;Workarounds&quot;">​</a></h4><p>Depending on the cause for the crash, there are different mitigation strategies to disable certain functionalities of the SAP Connector, so that the condition causing the crash does not occur anymore. You may search the call stack for the last code block belonging to the <em>/CQSE/</em> namespace in order to locate the export step the error is related to, e.g. Code Inspector checks or DDIC export.</p><h5 id="code-inspector" tabindex="-1">Code Inspector <a class="header-anchor" href="#code-inspector" aria-label="Permalink to &quot;Code Inspector&quot;">​</a></h5><p>In case of Code Inspector crashes, you may search the short dump for the value of the variable <code>OBJECT_NAME</code> to identify which object Code Inspector was checking when it crashed. Then, have a look at the ABAP code in your favorite ABAP editor, and try to check it manually using Code Inspector. If the check fails, you have the following options:</p><ul><li>Adjust your ABAP code so that Code Inspector can successfully run the check</li><li>Search for an SAP Note fixing the check (e.g. <a href="https://me.sap.com/notes/2215785" target="_blank" rel="noreferrer">Note 2215785</a>, requires login)</li><li>In the SAP system, disable the particular check in the check variant that is used by Teamscale</li><li>Add the particular object to the <em>Code Inspector exclude specification</em> in Teamscale&#39;s SAP connection settings for the respective system to exclude it from Code Inspector checks. Be sure to use the object name as shown in Teamscale:</li></ul><p><img src="`+f+`" alt="Code Inspector Excludes" width="654" height="169" data-zoom="true"></p><h5 id="ddic-export" tabindex="-1">DDIC Export <a class="header-anchor" href="#ddic-export" aria-label="Permalink to &quot;DDIC Export&quot;">​</a></h5><p>In case the crash is related to the DDIC export, you may search the short dump for strings such as <code>OBJECT_NAME</code>, <code>OBJ_NAME</code>, <code>PROG_NAME</code>, or <code>PROGRAM_NAME</code> to determine which DDIC object caused the crash. Then, open the respective DDIC object with SAPGui and run consistency checks (e.g. to identify broken foreign-key relationships in database tables). Workarounds are:</p><ul><li>Fix the inconsistencies in the respective DDIC object</li><li>Disable the option <em>Include objects in ABAP Dictionary (DDIC)</em> in Teamscale&#39;s SAP connection settings for the respective system</li></ul><h3 id="error-timeout" tabindex="-1">Error: Timeout <a class="header-anchor" href="#error-timeout" aria-label="Permalink to &quot;Error: Timeout&quot;">​</a></h3><p>Similar to crashes related to programming errors or data inconsistency, in some cases the RFC connection to the SAP system may be terminated due to a timeout in the SAP system.</p><h4 id="symptom-2" tabindex="-1">Symptom <a class="header-anchor" href="#symptom-2" aria-label="Permalink to &quot;Symptom&quot;">​</a></h4><p>The worker log entry contains a line like</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>RfcException raised by system [CQR|abap-rel|00]:</span></span>
<span class="line"><span>message: Zeitlimit überschritten</span></span></code></pre></div><h4 id="solution" tabindex="-1">Solution <a class="header-anchor" href="#solution" aria-label="Permalink to &quot;Solution&quot;">​</a></h4><p>Please make sure that</p><ul><li>The SAP user configured in Teamscale is not a dialog user (see <a href="./../tutorial/sap-integration/#rfc-user-for-teamscale">RFC User for Teamscale</a>)</li><li>You use asynchronous communication if Code Inspector is enabled (see <a href="./../tutorial/sap-integration/#asynchronous-full-export">Asynchronous Full Export</a>)</li></ul><p>If the problem persists, please:</p><ol><li>Perform an ABAP trace and/or an SQL trace on your system during export</li><li>Send the results to <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">support@teamscale.com</a> or request a link to perform an HTTPS-secured upload</li><li>Our experts will investigate the reason for the crash and provide you with further instructions</li></ol><h3 id="error-sap-connection-fails-with-error-cca-is-not-filled-yet-too-early-to-run-atc-check" tabindex="-1">Error: SAP Connection fails with error &quot;CCA is not filled yet. Too early to run ATC check&quot; <a class="header-anchor" href="#error-sap-connection-fails-with-error-cca-is-not-filled-yet-too-early-to-run-atc-check" aria-label="Permalink to &quot;Error: SAP Connection fails with error &quot;CCA is not filled yet. Too early to run ATC check&quot;&quot;">​</a></h3><p>In some cases, the SAP system can&#39;t execute ATC checks. The error aborts the Teamscale Exporter in the SAP system, so Teamscale does not get updates (code changes, SCI findings).</p><h4 id="symptom-3" tabindex="-1">Symptom <a class="header-anchor" href="#symptom-3" aria-label="Permalink to &quot;Symptom&quot;">​</a></h4><p>The worker log entry contains a line like</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>JCO_ERROR_SYSTEM_FAILURE: CCA is not filled yet. Too early to run ATC check</span></span></code></pre></div><h4 id="solution-1" tabindex="-1">Solution <a class="header-anchor" href="#solution-1" aria-label="Permalink to &quot;Solution&quot;">​</a></h4><p>The problem and its correction are described in <a href="https://me.sap.com/notes/3242711" target="_blank" rel="noreferrer">SAP Note 3242711</a> (requires login). Please make sure this note is implemented in your SAP system.</p><h2 id="test-coverage-is-missing-in-teamscale" tabindex="-1">Test coverage is missing in Teamscale <a class="header-anchor" href="#test-coverage-is-missing-in-teamscale" aria-label="Permalink to &quot;Test coverage is missing in Teamscale&quot;">​</a></h2><p>To narrow down the problem please check the following:</p><details class="details custom-block"><summary>Check the status information of the upload</summary><p>Navigate to the <em>Project Configuration</em> perspective. Select the <em>Projects</em> view and click on the <i class="cloud upload icon"></i> icon for the project that is missing coverage. Now in the <em>External Uploads View</em>, expand the partition of the upload and search for the commit. Be aware that the date and time refers to the code commit for which the coverage has been uploaded, as opposed to the time at which the upload happened. If you can&#39;t find the commit, something must have gone wrong during the actual upload. In this case, please have a look at the <em>Service Log</em> in the <em>System</em> perspective and check our upload script output or tooling logs, depending on how the upload is executed. Otherwise, click on the commit to see all the details for the upload. It lists all the state transitions of the upload and provides hints when something went wrong. The last state should be <code>PROCESSED</code>.</p></details><details class="details custom-block"><summary>Check the worker logs for related warnings and errors</summary><p>Next you might want to check the <em>Worker Log</em> in the <em>System</em> perspective. Open the worker log for your project. Select <em>Errors and warnings</em> and search for entries related to the upload commit e.g., by searching for the timestamp with the Filter option. Click on the entry to see all the log messages.</p></details>`,101)),e("details",w,[a[14]||(a[14]=e("summary",null,"Check whether the coverage report actually contains coverage information",-1)),a[15]||(a[15]=e("p",null,"Make sure that there are parts in the report that actually contain covered lines or instructions. This of course depends on the concrete report format.",-1)),s(c,null,{default:o(()=>[s(n,{label:"JaCoCo"},{default:o(()=>a[11]||(a[11]=[e("p",null,[e("em",null,"JaCoCo"),t(" reports have line tags like "),e("code",null,'<line nr="7" mi="8" ci="0" mb="0" cb="0"/>'),t(" where "),e("code",null,"mi"),t(" means missed instructions and "),e("code",null,"ci"),t(" means covered instructions. If the coverage file only contains "),e("code",null,'ci="0"'),t(" entries, something must be wrong with the profiler configuration. In this case, check your include and exclude patterns and that no additional class file transformations happen at runtime e.g., by another java agent. You might also find the "),e("a",{href:"https://github.com/cqse/teamscale-jacoco-verifier",target:"_blank",rel:"noreferrer"},"Teamscale JaCoCo Verifier"),t(" helpful to find out whether the XML file actually contains relevant coverage.")],-1)])),_:1,__:[11]}),s(n,{label:"LCOV"},{default:o(()=>a[12]||(a[12]=[e("p",null,[e("em",null,"LCov"),t(" reports consist of "),e("code",null,"SF:"),t(" prefixed lines that denote the source files followed by "),e("code",null,"DA:"),t(" prefixed lines that list the lines that have been covered. No "),e("code",null,"DA:"),t(" entries means no coverage.")],-1)])),_:1,__:[12]}),s(n,{label:"Cobertura"},{default:o(()=>a[13]||(a[13]=[e("p",null,[e("em",null,"Cobertura"),t(" reports have line tags like "),e("code",null,'<line number="3" hits="1" branch="false"/>'),t(" where "),e("code",null,"hits"),t(" counts the number of times a line has been executed. When the coverage file only contains "),e("code",null,'hits="0"'),t(" entries something must be wrong with the profiler configuration.")],-1)])),_:1,__:[13]})]),_:1})]),a[21]||(a[21]=i(`<h3 id="teamscale-java-profiler" tabindex="-1">Teamscale Java Profiler <a class="header-anchor" href="#teamscale-java-profiler" aria-label="Permalink to &quot;Teamscale Java Profiler&quot;">​</a></h3><p>You have attached the <a href="https://github.com/cqse/teamscale-jacoco-agent/" target="_blank" rel="noreferrer">Teamscale Java Profiler</a> to your application according to the documentation but you are not seeing the coverage you expected or maybe even no coverage at all.</p><div class="tip custom-block"><p class="custom-block-title">Always Check the Logs</p><p>The first step in troubleshooting such problems is always to look at the log file the agent writes at <code>AGENT_INSTALL_DIR/logs</code>. If it contains any errors, please resolve these first. Examples are network connectivity issues or incorrectly configured command line arguments.</p><p>It also tells you whether the agent was started at all since the agent will always log at least an <code>INFO</code> entry at startup.</p></div><p>First, we&#39;ll verify the most basic setup: The agent must at least start and write coverage files to disk. Please remove all options starting with <code>teamscale-</code> and the <code>out</code> option. This allows you to inspect the coverage reports. Coverage is written to <code>AGENT_INSTALL_DIR/coverage</code>. Please ensure that the agent can create files inside this directory.</p><p>Please disable all other <code>-javaagent</code> and <code>-agentlib</code> arguments to your JVM to avoid interference of other agents with the Teamscale Java Profiler.</p><p>Re-run your application and then <strong>shut it down</strong>. Coverage files are always written on shut down of the application.</p><ul><li>A coverage file must be created in <code>AGENT_INSTALL_DIR/coverage</code>.</li><li>If not, please check the agent&#39;s logs in <code>AGENT_INSTALL_DIR/logs</code>.</li><li>If no logs were created, then the agent was not started. Please re-check your configuration and the logs of your own application.</li></ul><h4 id="no-coverage-data-is-generated-at-all" tabindex="-1">No Coverage Data is Generated at All <a class="header-anchor" href="#no-coverage-data-is-generated-at-all" aria-label="Permalink to &quot;No Coverage Data is Generated at All&quot;">​</a></h4><div class="danger custom-block"><p class="custom-block-title">Problem: Your Application Is Not Shut Down Gracefully</p><p>If no coverage file was created or the coverage file is truncated (i.e. does not end with <code>&lt;/report&gt;</code>), then it may be that your JVM did not shut down gracefully. Please ensure that no other process is forcefully killing your JVM, e.g. a service running, Docker, an application server etc.</p></div><h4 id="coverage-files-can-be-generated-but-upload-to-teamscale-fails" tabindex="-1">Coverage Files Can Be Generated But Upload to Teamscale Fails <a class="header-anchor" href="#coverage-files-can-be-generated-but-upload-to-teamscale-fails" aria-label="Permalink to &quot;Coverage Files Can Be Generated But Upload to Teamscale Fails&quot;">​</a></h4><p>If a coverage file was written but upload to Teamscale fails when configuring the <code>teamscale-</code> options, please verify that the server where the agent is installed can reach the Teamscale server.</p><div class="danger custom-block"><p class="custom-block-title">Problem: Your Servers Cannot Reach Each Other</p><p>On the agent&#39;s server:</p><ul><li>Run a <code>ping</code> of the IP address of the Teamscale server.</li><li>Run <code>curl -v TEAMSCALE_URL/login</code> and check for connection problems. Teamscale must respond with the login page&#39;s HTML, HTTP status 200.</li><li>Ensure that no firewalls or reverse proxies are causing issues.</li><li>If a proxy is required, please configure the proxy for your JVM so the agent can use it.</li></ul></div><div class="danger custom-block"><p class="custom-block-title">Problem: You Provided the Wrong Authentication Information</p><p>If a network connection is possible, common mistakes that prevent an upload to Teamscale are:</p><ul><li>The <code>teamscale-user</code> you provided does not have the <em>Perform External Uploads</em> permission in Teamscale.</li><li>You provided the <code>teamscale-user</code>&#39;s password instead of their access token in the <code>teamscale-access-token</code> option.</li></ul></div><h4 id="coverage-uploads-are-shown-in-teamscale-but-coverage-is-missing" tabindex="-1">Coverage Uploads Are Shown In Teamscale But Coverage Is Missing <a class="header-anchor" href="#coverage-uploads-are-shown-in-teamscale-but-coverage-is-missing" aria-label="Permalink to &quot;Coverage Uploads Are Shown In Teamscale But Coverage Is Missing&quot;">​</a></h4><p>You can see the coverage uploads as <code>Processed</code> in Teamscale under <em>Project Configuration</em> &gt; <i class="cloud upload icon"></i>. You can also see the upload under <em>Activity</em>. However, when you click on that upload in <em>Activity</em>, either all or some coverage is missing when you check the list of covered files.</p><div class="danger custom-block"><p class="custom-block-title">Problem: Your Include/Exclude Patterns Are Misconfigured</p><p>Please run the agent with patterns that include all code:</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">includes</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=*</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">excludes</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span></span></code></pre></div><p>Run your application and upload coverage to Teamscale again If you now see the missing coverage, then your previous include/exclude patterns were not configured correctly and were excluding the code you wanted to profile.</p></div><div class="danger custom-block"><p class="custom-block-title">Problem: You Are Profiling the Wrong Process</p><p>The profiler will only profile the code running within the JVM which receives the <code>-javaagent</code> argument. I.e. if your main Java process spawns another, it must pass on the <code>-javaagent</code> argument to the child process or the code running in the child will not be profiled.</p><p>Please ensure that the JVM that is running the code you wish to profile actually receives the <code>-javaagent</code> argument, e.g. with a process explorer tool that can show the command line of a process.</p></div><div class="danger custom-block"><p class="custom-block-title">Problem: Interference by Another Java Agent</p><p>Other Java Agents can disrupt the Java Profiler in a way that prevents it from instrumenting your classes. Please disable all other <code>-javaagent</code> and <code>-agentlib</code> arguments to your JVM. If this resolves your issue, you have two options:</p><ul><li>either leave the other agent disabled while you collect coverage</li><li>or try to reorder the agents so the Teamscale Java Profiler&#39;s <code>-javaagent</code> argument is the <strong>first</strong> such argument on the JVM&#39;s command line. In many cases, this will also resolve the conflict.</li></ul></div><h2 id="teamscale-integration-for-eclipse" tabindex="-1">Teamscale Integration for Eclipse <a class="header-anchor" href="#teamscale-integration-for-eclipse" aria-label="Permalink to &quot;Teamscale Integration for Eclipse&quot;">​</a></h2><div class="tip custom-block"><p class="custom-block-title">Enabling Debug Logging</p><p>In order to determine the root cause of the problem, we may need debug logs from your Eclipse installation. To enable debug logging, open the <em>Preferences</em> and navigate to <em>General</em> &gt; <em>Tracing</em>. There, check <em>Enable tracing</em> and search the <em>Tracing options</em> for <code>Teamscale</code>. Set the desired options to <em>true</em>. (If in doubt, set all options offered by the <em>Teamscale Integration for Eclipse</em> to <code>true</code>.) Finally, take a note of the path given for the <em>Output to file</em> option: This is where you can later access the log file. Apply your changes and close the dialog.</p><p>Then, please reproduce the problem in the open IDE window. Afterwards, locate the log file and send it to CQSE support for analysis.</p></div><h3 id="cannot-install-eclipse-integration" tabindex="-1">Cannot Install <em>Eclipse Integration</em> <a class="header-anchor" href="#cannot-install-eclipse-integration" aria-label="Permalink to &quot;Cannot Install _Eclipse Integration_&quot;">​</a></h3><div class="danger custom-block"><p class="custom-block-title">Problem: Installation Complains <em>Cannot Perform Operation</em></p><p>When Eclipse complains that <em>Cannot perform operation. Computing alternate solutions [...]</em> during installation of the <em>Teamscale Integration</em>, wait and then proceed to the <em>Install Remediation Page</em>. If that page does not offer a solution, go <em>Back</em> and refine the set of plug-ins to install. The <em>Diagnostic Support</em> plug-in, in particular, has been known to cause the above error when doing an <a href="./../howto/integrating-with-your-ide/eclipse/#installing-while-offline">offline installation</a> and the <em>Equinox Dynamic Tracing Enablement UI</em> (<code>org.eclipse.ui.trace</code>) plug-in is not already installed.</p><p>To solve the issue, please only install the <em>Teamscale Integration for Eclipse</em> itself; everything else is optional.</p></div><h2 id="teamscale-integration-for-intellij" tabindex="-1">Teamscale Integration for IntelliJ <a class="header-anchor" href="#teamscale-integration-for-intellij" aria-label="Permalink to &quot;Teamscale Integration for IntelliJ&quot;">​</a></h2><div class="tip custom-block"><p class="custom-block-title">Enabling Debug Logging</p><p>In order to determine the root cause of the problem, we may need debug logs from your IntelliJ installation. To enable debug logging, go to either <em>Help</em> &gt; <em>Debug Log Settings…</em> or <em>Help</em> &gt; <em>Diagnostic Tools</em> &gt; <em>Debug Log Settings…</em>, depending on your IntelliJ version. Then, enter the following log categories, one per line:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>com.teamscale.ide.intellij:trace</span></span>
<span class="line"><span>#com.teamscale.ide.intellij:trace</span></span></code></pre></div><p>Save your changes and close the dialog.</p><p>Then, please reproduce the problem in the open IDE window. Afterwards, you can access the log files under <em>Help</em> &gt; <em>Show Log in Files</em> and send them to CQSE support for analysis.</p></div><h3 id="intellij-integration-forgets-server-settings" tabindex="-1"><em>IntelliJ Integration</em> Forgets Server Settings <a class="header-anchor" href="#intellij-integration-forgets-server-settings" aria-label="Permalink to &quot;_IntelliJ Integration_ Forgets Server Settings&quot;">​</a></h3><p>When the <em>Teamscale Integration for IntelliJ</em> &quot;forgets&quot; the <em>Teamscale Servers</em> configured on the <em>Tools</em> &gt; <em>Teamscale</em> settings page upon an IDE restart, this may have several causes.</p><div class="danger custom-block"><p class="custom-block-title">Problem: <em>Do Not Save, Forget Passwords After Restart</em> Selected</p><p>The <em>Do not save, forget passwords after restart</em> option is selected on the <em>Appearance &amp; Behavior</em> &gt; <em>System Settings</em> &gt; <em>Passwords</em> settings page. In this case, please select another option.</p></div><div class="danger custom-block"><p class="custom-block-title">Problem: <em>Native Keychain</em> Does not Work With Gnome Keyring</p><p>If <em>In native keychain</em> is selected and you are using the Gnome Keyring, you may be experiencing a bug in the IDE itself (<a href="https://youtrack.jetbrains.com/issue/IDEA-247162" target="_blank" rel="noreferrer">issue IDEA-247162</a>). As a workaround, please select the <em>In KeePass</em> option.</p></div>`,28))])}const q=h(y,[["render",E]]);export{I as __pageData,q as default};
