Enforce consistent linebreaks in curly braces in JSX attributes and expressions.




Many style guides require or disallow newlines inside of jsx curly expressions.

## Rule Details

This rule enforces consistent linebreaks inside of curlies of jsx curly expressions.

## require

Examples of **incorrect** code for this rule, when configured with `{ multiline: "require", singleline: "require" }`:

```jsx
<div>
  { foo &&
    foo.bar }
</div>

<div>
  { foo }
</div>

<div>
  { foo
  }
</div>
```

Examples of **correct** code for this rule:

```jsx
<div>
  {
    foo &&
    foo.bar
  }
</div>

<div>
  {
    foo
  }
</div>
```

## When Not To Use It

You can turn this rule off if you are not concerned with the consistency of padding linebreaks inside of JSX attributes or expressions.
