JavaScript allows you to place unnecessary spaces before or after a semicolon.

Disallowing or enforcing space around a semicolon can improve the readability of your program.

```js
var a = "b" ;

var c = "d";var e = "f";
```

## Rule Details

This rule aims to enforce spacing around a semicolon. This rule prevents the use of spaces before a semicolon in expressions.

This rule doesn't check spacing in the following cases:

* The spacing after the semicolon if it is the first token in the line.

* The spacing before the semicolon if it is after an opening parenthesis (`(` or `{`), or the spacing after the semicolon if it is before a closing parenthesis (`)` or `}`). That spacing is checked by `space-in-parens` or `block-spacing`.

* The spacing around the semicolon in a for loop with an empty condition (`for(;;)`).

## When Not To Use It

You can turn this rule off if you are not concerned with the consistency of spacing before or after semicolons.
