<h2>Why is this an issue?</h2>
<p>Empty statements represented by a semicolon <code>;</code> are statements that do not perform any operation. They are often the result of a typo or
a misunderstanding of the language syntax. It is a good practice to remove empty statements since they don’t add value and lead to confusion and
errors.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
void DoSomething()
{
    ; // Noncompliant - was used as a kind of TODO marker
}

void DoSomethingElse()
{
    Console.WriteLine("Hello, world!");;  // Noncompliant - double ;
    // ...
    // Rarely, they are used on purpose as the body of a loop. It is a bad practice to
    // have side-effects outside of the loop:
    for (int i = 0; i &lt; 3; Console.WriteLine(i), i++); // Noncompliant
    // ...
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
void DoSomething()
{
}

void DoSomethingElse()
{
    Console.WriteLine("Hello, world!");
    // ...
    for (int i = 0; i &lt; 3; i++)
    {
        Console.WriteLine(i);
     }
    // ...
}
</pre>

