﻿## SA1118

<table>
<tr>
  <td>TypeName</td>
  <td>SA1118ParameterMustNotSpanMultipleLines</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1118</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

A parameter to a C# method or indexer, other than the first parameter, spans across multiple lines.

## Rule description

To prevent method calls from becoming excessively complicated and unreadable, individual parameters and arguments should
be placed on a single line. When parameters other than the first parameter span across multiple lines, it can be
difficult to tell how many parameters are passed to the method. In general, the code becomes difficult to read. A
violation of this rule is reported when a parameter or argument spans multiple lines, except in the following specific
cases:

* The first parameter may span multiple lines
* Anonymous methods (including lambda expressions) may span multiple lines
* Invocation expressions may span multiple lines
* Object and array creation expressions may span multiple lines
* `with` expressions (C# 9) may span multiple lines

For example, the following code would violate this rule, since the second parameter spans across multiple lines:

```csharp
return JoinStrings(
    "John",
    "Smith" + 
    " Doe");
```

To fix the example above, ensure that the parameters after the first parameter do not span across multiple lines. If
this will cause a parameter to be excessively long, store the value of the parameter within a temporary variable. For
example:

```csharp
string last = "Smith" + 
    " Doe";

return JoinStrings(
    "John",
    last);
```

In some cases, this will allow the method to be written even more concisely, such as:

```csharp
return JoinStrings("John", last);
```

## How to fix violations

To fix a violation of this rule, ensure that the parameters and arguments do not span multiple lines, except in the
specific cases listed above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1118:ParameterMustNotSpanMultipleLines", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1118 // ParameterMustNotSpanMultipleLines
#pragma warning restore SA1118 // ParameterMustNotSpanMultipleLines
```
