## SA1134

<table>
<tr>
  <td>TypeName</td>
  <td>SA1134AttributesMustNotShareLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1134</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

An attribute is placed on the same line of code as another attribute or element.

## Rule description

A violation of this rule occurs when two more more attributes are placed on the same line of code, or an attribute is placed on the same line of code as another element.

For example, the following code would produce a violation of this rule:

```csharp
[ExportCodeFixProvider(LanguageNames.CSharp, Name = nameof(MyCodeFixProvider))][Shared]
public class MyCodeFixProvider : CodeFixProvider
{
}
```

The following code would not produce any violations:

```csharp
[ExportCodeFixProvider(LanguageNames.CSharp, Name = nameof(MyCodeFixProvider))]
[Shared]
public class MyCodeFixProvider : CodeFixProvider
{
}
```

### Exceptions

A violation of this rule will not occur for attributes placed on parameters or type parameters.

For example, the following code will not produce violations:

```csharp
public class MyClass<[Foo][Bar] T>
{
	public T MyMethod([In][MarshalAs(UnmanagedType.LPWStr)] string value)
	{
	    ...
	}
}
```

## How to fix violations

To fix a violation of this rule, place each attribute on its own line.

## How to suppress violations

```csharp
#pragma warning disable SA1134 // Attributes should not share line
[ExportCodeFixProvider(LanguageNames.CSharp, Name = nameof(MyCodeFixProvider))][Shared]
#pragma warning restore SA1134 // Attributes should not share line
public class MyCodeFixProvider : CodeFixProvider
{
}
```
