﻿## SA1518

<table>
<tr>
  <td>TypeName</td>
  <td>SA1518UseLineEndingsCorrectlyAtEndOfFile</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1518</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

The line endings at the end of a file do not match the settings for the project.

## Rule description

To improve the layout of the code, StyleCop requires line endings to be consistent at the end of files. The specific
requirements for a project may be configured using **stylecop.json**. See [Configuration.md](Configuration.md) for more
information.

The specific settings is one of the following:

* Allow (default): Files are allowed to end with a single newline character, but it is not required
* Require: Files are required to end with a single newline character
* Omit: Files may not end with a newline character

## How to fix violations

To fix a violation of this rule, update the line endings at the end of the file to match the settings for the current
project.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1518:CodeMustNotContainBlankLinesAtEndOfFile", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1518 // CodeMustNotContainBlankLinesAtEndOfFile
#pragma warning restore SA1518 // CodeMustNotContainBlankLinesAtEndOfFile
```
