<h2>Why is this an issue?</h2>
<p>Before Java 8, a container annotation was required as wrapper to use multiple instances of the same annotation. As of Java 8, this is no longer
necessary. Instead, these annotations should be used directly without a wrapper, resulting in cleaner and more readable code.</p>
<p>This rule is automatically disabled when the project’s <code>sonar.java.source</code> is lower than <code>8</code> as repeating annotations were
introduced in Java 8.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
@SomeAnnotations({  // Noncompliant, wrapper annotations are not necessary in Java 8+
  @SomeAnnotation(..a..),
  @SomeAnnotation(..b..),
  @SomeAnnotation(..c..),
})
public class SomeClass {
  ...
}
```
<h4>Compliant solution</h4>

```java
@SomeAnnotation(..a..)
@SomeAnnotation(..b..)
@SomeAnnotation(..c..)
public class SomeClass {
  ...
}
```
<h2>References</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/tutorial/java/annotations/repeating.html">Repeating Annotations - The Java™ Tutorials</a> </li>
</ul>