<h2>Why is this an issue?</h2>
<p>In applications where the accepted practice is to log an <code>Exception</code> and then rethrow it, you end up with miles-long logs that contain
multiple instances of the same exception. In multi-threaded applications debugging this type of log can be particularly hellish because messages from
other threads will be interwoven with the repetitions of the logged-and-thrown <code>Exception</code>. Instead, exceptions should be either logged or
rethrown, not both.</p>
<h3>Noncompliant code example</h3>

```java
catch (SQLException e) {
  ...
  LOGGER.log(Level.ERROR,  contextInfo, e);
  throw new MySQLException(contextInfo, e);
}
```
<h3>Compliant solution</h3>

```java
catch (SQLException e) {
  ...
  throw new MySQLException(contextInfo, e);
}
```
<p>or</p>

```java
catch (SQLException e) {
  ...
  LOGGER.log(Level.ERROR,  contextInfo, e);
  // handle exception...
}
```