<h2>Why is this an issue?</h2>
<p>Regular expressions are powerful but tricky, and even those long used to using them can make mistakes.</p>
<p>The following should not be used as regular expressions:</p>
<ul>
  <li> <code>.</code> - matches any single character. Used in <code>replaceAll</code>, it matches <em>everything</em> </li>
  <li> <code>|</code> - normally used as an option delimiter. Used stand-alone, it matches the space between characters </li>
  <li> <code>File.separator</code> - matches the platform-specific file path delimiter. On Windows, this will be taken as an escape character </li>
</ul>
<h3>Noncompliant code example</h3>

```java
String str = "/File|Name.txt";

String clean = str.replaceAll(".",""); // Noncompliant; probably meant to remove only dot chars, but returns an empty string
String clean2 = str.replaceAll("|","_"); // Noncompliant; yields _/_F_i_l_e_|_N_a_m_e_._t_x_t_
String clean3 = str.replaceAll(File.separator,""); // Noncompliant; exception on Windows

String clean4 = str.replaceFirst(".",""); // Noncompliant;
String clean5 = str.replaceFirst("|","_"); // Noncompliant;
String clean6 = str.replaceFirst(File.separator,""); // Noncompliant;
```