<h2>Why is this an issue?</h2>
<p>Two functions having the same implementation are suspicious. It might be that something else was intended. Or the duplication is intentional, which
becomes a maintenance burden.</p>

```js
function calculateCode() {
  doTheThing();
  doOtherThing();
  return code;
}

function getName() {  // Noncompliant: duplicates calculateCode
  doTheThing();
  doOtherThing();
  return code;
}
```
<p>If the identical logic is intentional, the code should be refactored to avoid duplication. For example, by having both functions call the same
function or by having one implementation invoke the other.</p>

```js
function calculateCode() {
  doTheThing();
  doOtherThing();
  return code;
}

function getName() { // Intent is clear
  return calculateCode();
}
```
<h3>Exceptions</h3>
<ul>
  <li> Functions with fewer than 3 lines are ignored. </li>
  <li> This rule does not apply to function expressions and arrow functions because they don’t have explicit names and are often used in a way where
  refactoring is not applicable. </li>
</ul>

```js
list.map((item) => ({
  name: item.name,
  address: item.address,
  country: item.country
}));
```