<h2>Why is this an issue?</h2>
<p>The <code>Array.prototype.reduce()</code> method in JavaScript is used to apply a function against an accumulator and each element in the array
(from left to right) to reduce it to a single output value. It is a convenient method that can simplify logic in your code.</p>
<p>However, it’s important to always provide an initial value as the second argument to <code>reduce()</code>. The initial value is used as the first
argument to the first call of the callback function. If no initial value is supplied, JavaScript will use the first element of the array as the
initial accumulator value and start iterating at the second element.</p>
<p>This can lead to runtime errors if the array is empty, as <code>reduce()</code> will throw a TypeError.</p>

```js
function sum(xs) {
  return xs.reduce((acc, current) => acc + current); // Noncompliant
}
console.log(sum([1, 2, 3, 4, 5])); // Prints 15
console.log(sum([])); // TypeError: Reduce of empty array with no initial value
```
<p>To fix this, always provide an initial value as the second argument to <code>reduce()</code>.</p>

```js
function sum(xs) {
  return xs.reduce((acc, current) => acc + current, 0);
}
console.log(sum([1, 2, 3, 4, 5])); // Prints 15
console.log(sum([])); // Prints 0
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reduce">Array.prototype.reduce()</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Reduce_of_empty_array_with_no_initial_value">TypeError: Reduce of
  empty array with no initial value</a> </li>
</ul>