State actions in Stateflow charts shall be stated in the following order: entry (en), during (du), exit (ex). This
improves readability, maintainability and consistency of the model.

This check contains two sub-checks:

#### Sub ID a

Checks the ordering of basic state action types inside a Stateflow state.

#### Sub ID b

If enabled, checks the ordering of combined state action types inside the same line of a Stateflow state (e.g., `en, du, ex: x=1`).

## Guidelines

- [MAB Modeling Guideline (Version 6.0)](https://mathworks.com/help/simulink/mdl_gd/maab/jc_0733orderofstateactiontypes.html)

## References

- Corresponding Model Advisor check [JMAAB jc_0733](https://www.mathworks.com/help/slcheck/ref/check-order-of-state-action-types.html)
