/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.Preconditions;

public final class DateUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");

    private DateUtils() {
    }

    public static String formatDate(Date d) {
        return d.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().toString();
    }

    public static String formatDate(Instant d) {
        return d.atZone(ZoneId.systemDefault()).toLocalDate().toString();
    }

    public static String formatDateTime(Date d) {
        return DateUtils.formatDateTime(OffsetDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault()));
    }

    public static String formatDateTime(long ms) {
        return DateUtils.formatDateTime(OffsetDateTime.ofInstant(Instant.ofEpochMilli(ms), ZoneId.systemDefault()));
    }

    public static String formatDateTime(OffsetDateTime dt) {
        return DATETIME_FORMATTER.format(dt);
    }

    public static String formatDateTimeNullSafe(@Nullable Date date) {
        return date == null ? "" : DateUtils.formatDateTime(date);
    }

    @CheckForNull
    public static Date longToDate(@Nullable Long time) {
        return time == null ? null : new Date(time);
    }

    @CheckForNull
    public static Long dateToLong(@Nullable Date date) {
        return date == null ? null : Long.valueOf(date.getTime());
    }

    public static Date parseDate(String s) {
        return Date.from(DateUtils.parseLocalDate(s).atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    @CheckForNull
    public static Date parseDateQuietly(@Nullable String s) {
        Date date = null;
        if (s != null) {
            try {
                date = DateUtils.parseDate(s);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return date;
    }

    public static LocalDate parseLocalDate(String s) {
        try {
            return LocalDate.parse(s);
        }
        catch (DateTimeParseException e) {
            throw MessageException.of("The date '" + s + "' does not respect format 'yyyy-MM-dd'", e);
        }
    }

    @CheckForNull
    public static LocalDate parseLocalDateQuietly(@Nullable String s) {
        LocalDate date = null;
        if (s != null) {
            try {
                date = DateUtils.parseLocalDate(s);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return date;
    }

    public static Date parseDateTime(String s) {
        return Date.from(DateUtils.parseOffsetDateTime(s).toInstant());
    }

    public static OffsetDateTime parseOffsetDateTime(String s) {
        try {
            return OffsetDateTime.parse(s, DATETIME_FORMATTER);
        }
        catch (DateTimeParseException e) {
            throw MessageException.of("The date '" + s + "' does not respect format 'yyyy-MM-dd'T'HH:mm:ssZ'", e);
        }
    }

    @CheckForNull
    public static Date parseDateTimeQuietly(@Nullable String s) {
        Date datetime = null;
        if (s != null) {
            try {
                datetime = DateUtils.parseDateTime(s);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return datetime;
    }

    @CheckForNull
    public static OffsetDateTime parseOffsetDateTimeQuietly(@Nullable String s) {
        OffsetDateTime datetime = null;
        if (s != null) {
            try {
                datetime = DateUtils.parseOffsetDateTime(s);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return datetime;
    }

    @CheckForNull
    public static Date parseDateOrDateTime(@Nullable String stringDate) {
        return DateUtils.parseDateOrDateTime(stringDate, ZoneId.systemDefault());
    }

    @CheckForNull
    public static Date parseDateOrDateTime(@Nullable String stringDate, ZoneId timeZone) {
        if (stringDate == null) {
            return null;
        }
        OffsetDateTime odt = DateUtils.parseOffsetDateTimeQuietly(stringDate);
        if (odt != null) {
            return Date.from(odt.toInstant());
        }
        LocalDate ld = DateUtils.parseLocalDateQuietly(stringDate);
        Preconditions.checkArgument(ld != null, "Date '%s' cannot be parsed as either a date or date+time", stringDate);
        return Date.from(ld.atStartOfDay(timeZone).toInstant());
    }

    @CheckForNull
    public static Date parseStartingDateOrDateTime(@Nullable String stringDate) {
        return DateUtils.parseDateOrDateTime(stringDate);
    }

    @CheckForNull
    public static Date parseStartingDateOrDateTime(@Nullable String stringDate, ZoneId timeZone) {
        return DateUtils.parseDateOrDateTime(stringDate, timeZone);
    }

    @CheckForNull
    public static Date parseEndingDateOrDateTime(@Nullable String stringDate) {
        return DateUtils.parseEndingDateOrDateTime(stringDate, ZoneId.systemDefault());
    }

    @CheckForNull
    public static Date parseEndingDateOrDateTime(@Nullable String stringDate, ZoneId timeZone) {
        if (stringDate == null) {
            return null;
        }
        OffsetDateTime odt = DateUtils.parseOffsetDateTimeQuietly(stringDate);
        if (odt != null) {
            return Date.from(odt.toInstant());
        }
        LocalDate ld = DateUtils.parseLocalDateQuietly(stringDate);
        Preconditions.checkArgument(ld != null, "Date '%s' cannot be parsed as either a date or date+time", stringDate);
        return Date.from(ld.atStartOfDay(timeZone).plusDays(1L).toInstant());
    }

    public static Date addDays(Date date, int numberOfDays) {
        return Date.from(date.toInstant().plus((long)numberOfDays, ChronoUnit.DAYS));
    }

    public static Instant addDays(Instant instant, int numberOfDays) {
        return instant.plus((long)numberOfDays, ChronoUnit.DAYS);
    }

    @CheckForNull
    public static Date truncateToSeconds(@Nullable Date d) {
        if (d == null) {
            return null;
        }
        return DateUtils.truncateToSecondsImpl(d);
    }

    public static long truncateToSeconds(long dateTime) {
        return DateUtils.truncateToSecondsImpl(new Date(dateTime)).getTime();
    }

    private static Date truncateToSecondsImpl(Date d) {
        Instant instant = d.toInstant();
        instant = instant.truncatedTo(ChronoUnit.SECONDS);
        return Date.from(instant);
    }
}

