/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.connected;

import javax.annotation.concurrent.Immutable;
import org.sonarsource.sonarlint.core.client.api.common.AbstractAnalysisConfiguration;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

@Immutable
public class ConnectedAnalysisConfiguration
extends AbstractAnalysisConfiguration {
    private final String projectKey;
    private final String toString;

    public ConnectedAnalysisConfiguration(Builder builder) {
        super(builder);
        this.projectKey = builder.projectKey;
        this.toString = this.generateString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String toString() {
        return this.toString;
    }

    private String generateString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n").append("  projectKey: ").append(this.projectKey).append("\n");
        this.generateToStringCommon(sb);
        this.generateToStringInputFiles(sb);
        sb.append("]\n");
        return sb.toString();
    }

    public static final class Builder
    extends AbstractAnalysisConfiguration.AbstractBuilder<Builder> {
        private String projectKey;

        private Builder() {
        }

        public Builder setProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public ConnectedAnalysisConfiguration build() {
            if (StringUtils.isBlank(this.projectKey)) {
                throw new IllegalStateException("'projectKey' is mandatory");
            }
            return new ConnectedAnalysisConfiguration(this);
        }
    }
}

