/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.branches;

import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;
import org.sonarsource.sonarlint.core.serverapi.branches.ServerBranch;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Common;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.ProjectBranches;

public class ProjectBranchesApi {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String LIST_ALL_PROJECT_BRANCHES_URL = "/api/project_branches/list.protobuf";
    private final ServerApiHelper helper;

    public ProjectBranchesApi(ServerApiHelper helper) {
        this.helper = helper;
    }

    public List<ServerBranch> getAllBranches(String projectKey) {
        ProjectBranches.ListWsResponse response;
        try (HttpClient.Response wsResponse = this.helper.get("/api/project_branches/list.protobuf?project=" + UrlUtils.urlEncode(projectKey));
             InputStream is = wsResponse.bodyAsStream();){
            response = ProjectBranches.ListWsResponse.parseFrom(is);
        }
        catch (Exception e) {
            LOG.error("Error while fetching project branches", e);
            return List.of();
        }
        return response.getBranchesList().stream().filter(b -> b.getType() == Common.BranchType.BRANCH || b.getType() == Common.BranchType.LONG).map(branchWs -> new ServerBranch(branchWs.getName(), branchWs.getIsMain())).collect(Collectors.toList());
    }
}

