/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;
import org.sonarsource.sonarlint.core.serverapi.exception.UnexpectedBodyException;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Rules;
import org.sonarsource.sonarlint.core.serverapi.rules.ServerActiveRule;
import org.sonarsource.sonarlint.core.serverapi.rules.ServerRule;

public class RulesApi {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    public static final Map<Language, String> TAINT_REPOS_BY_LANGUAGE = Map.of(Language.CS, "roslyn.sonaranalyzer.security.cs", Language.JAVA, "javasecurity", Language.JS, "jssecurity", Language.TS, "tssecurity", Language.PHP, "phpsecurity", Language.PYTHON, "pythonsecurity");
    public static final Set<String> TAINT_REPOS = Set.copyOf(TAINT_REPOS_BY_LANGUAGE.values());
    public static final String RULE_SHOW_URL = "/api/rules/show.protobuf?key=";
    private final ServerApiHelper serverApiHelper;

    public RulesApi(ServerApiHelper serverApiHelper) {
        this.serverApiHelper = serverApiHelper;
    }

    public CompletableFuture<ServerRule> getRule(String ruleKey) {
        StringBuilder builder = new StringBuilder(RULE_SHOW_URL + ruleKey);
        this.serverApiHelper.getOrganizationKey().ifPresent(org -> builder.append("&organization=").append(UrlUtils.urlEncode(org)));
        return this.serverApiHelper.getAsync(builder.toString()).thenApply(response -> {
            HttpClient.Response response2 = response;
            try {
                Rules.Rule rule = Rules.ShowResponse.parseFrom(response.bodyAsStream()).getRule();
                ServerRule serverRule = new ServerRule(rule.getName(), IssueSeverity.valueOf(rule.getSeverity()), RuleType.valueOf(rule.getType().name()), rule.getLang(), rule.getHtmlDesc(), RulesApi.convertDescriptionSections(rule), rule.getHtmlNote(), Set.copyOf(rule.getEducationPrinciples().getEducationPrinciplesList()));
                if (response2 != null) {
                    response2.close();
                }
                return serverRule;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Error when fetching rule + '" + ruleKey + "'", e);
                    throw new UnexpectedBodyException(e);
                }
            }
        });
    }

    private static List<ServerRule.DescriptionSection> convertDescriptionSections(Rules.Rule rule) {
        if (rule.hasDescriptionSections()) {
            return rule.getDescriptionSections().getDescriptionSectionsList().stream().map(s -> {
                ServerRule.DescriptionSection.Context context = null;
                if (s.hasContext()) {
                    Rules.Rule.DescriptionSection.Context contextFromServer = s.getContext();
                    context = new ServerRule.DescriptionSection.Context(contextFromServer.getKey(), contextFromServer.getDisplayName());
                }
                return new ServerRule.DescriptionSection(s.getKey(), s.getContent(), Optional.ofNullable(context));
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Collection<ServerActiveRule> getAllActiveRules(String qualityProfileKey, ProgressMonitor progress) {
        HashMap activeRulesByKey = new HashMap();
        HashMap ruleTemplatesByRuleKey = new HashMap();
        this.serverApiHelper.getPaginated(this.getSearchByQualityProfileUrl(qualityProfileKey), Rules.SearchResponse::parseFrom, r -> r.hasPaging() ? (long)r.getPaging().getTotal() : r.getTotal(), r -> {
            ruleTemplatesByRuleKey.putAll(r.getRulesList().stream().collect(Collectors.toMap(Rules.Rule::getKey, Rules.Rule::getTemplateKey)));
            return List.copyOf(r.getActives().getActivesMap().entrySet());
        }, activeEntry -> {
            String ruleKey = (String)activeEntry.getKey();
            Rules.Active ar = ((Rules.ActiveList)activeEntry.getValue()).getActiveListList().get(0);
            activeRulesByKey.put(ruleKey, new ServerActiveRule(ruleKey, IssueSeverity.valueOf(ar.getSeverity()), ar.getParamsList().stream().collect(Collectors.toMap(Rules.Active.Param::getKey, Rules.Active.Param::getValue)), (String)ruleTemplatesByRuleKey.get(ruleKey)));
        }, false, progress);
        return activeRulesByKey.values();
    }

    private String getSearchByQualityProfileUrl(String qualityProfileKey) {
        StringBuilder builder = new StringBuilder();
        builder.append("/api/rules/search.protobuf?qprofile=");
        builder.append(UrlUtils.urlEncode(qualityProfileKey));
        this.serverApiHelper.getOrganizationKey().ifPresent(org -> builder.append("&organization=").append(UrlUtils.urlEncode(org)));
        builder.append("&activation=true&f=templateKey,actives&types=CODE_SMELL,BUG,VULNERABILITY,SECURITY_HOTSPOT&s=key");
        return builder.toString();
    }

    public Set<String> getAllTaintRules(List<Language> enabledLanguages, ProgressMonitor progress) {
        HashSet<String> taintRules = new HashSet<String>();
        this.serverApiHelper.getPaginated(this.getSearchByRepoUrl(enabledLanguages.stream().map(TAINT_REPOS_BY_LANGUAGE::get).filter(Objects::nonNull).collect(Collectors.toList())), Rules.SearchResponse::parseFrom, Rules.SearchResponse::getTotal, Rules.SearchResponse::getRulesList, rule -> taintRules.add(rule.getKey()), false, progress);
        return taintRules;
    }

    private String getSearchByRepoUrl(List<String> repositories) {
        StringBuilder builder = new StringBuilder();
        builder.append("/api/rules/search.protobuf?repositories=");
        builder.append(repositories.stream().map(UrlUtils::urlEncode).collect(Collectors.joining(",")));
        this.serverApiHelper.getOrganizationKey().ifPresent(org -> builder.append("&organization=").append(UrlUtils.urlEncode(org)));
        builder.append("&f=repo&s=key");
        return builder.toString();
    }
}

