/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.RocksObject;
import org.rocksdb.TxnDBWritePolicy;

public class TransactionDBOptions
extends RocksObject {
    public TransactionDBOptions() {
        super(TransactionDBOptions.newTransactionDBOptions());
    }

    public long getMaxNumLocks() {
        assert (this.isOwningHandle());
        return this.getMaxNumLocks(this.nativeHandle_);
    }

    public TransactionDBOptions setMaxNumLocks(long maxNumLocks) {
        assert (this.isOwningHandle());
        this.setMaxNumLocks(this.nativeHandle_, maxNumLocks);
        return this;
    }

    public long getNumStripes() {
        assert (this.isOwningHandle());
        return this.getNumStripes(this.nativeHandle_);
    }

    public TransactionDBOptions setNumStripes(long numStripes) {
        assert (this.isOwningHandle());
        this.setNumStripes(this.nativeHandle_, numStripes);
        return this;
    }

    public long getTransactionLockTimeout() {
        assert (this.isOwningHandle());
        return this.getTransactionLockTimeout(this.nativeHandle_);
    }

    public TransactionDBOptions setTransactionLockTimeout(long transactionLockTimeout) {
        assert (this.isOwningHandle());
        this.setTransactionLockTimeout(this.nativeHandle_, transactionLockTimeout);
        return this;
    }

    public long getDefaultLockTimeout() {
        assert (this.isOwningHandle());
        return this.getDefaultLockTimeout(this.nativeHandle_);
    }

    public TransactionDBOptions setDefaultLockTimeout(long defaultLockTimeout) {
        assert (this.isOwningHandle());
        this.setDefaultLockTimeout(this.nativeHandle_, defaultLockTimeout);
        return this;
    }

    public TxnDBWritePolicy getWritePolicy() {
        assert (this.isOwningHandle());
        return TxnDBWritePolicy.getTxnDBWritePolicy(this.getWritePolicy(this.nativeHandle_));
    }

    public TransactionDBOptions setWritePolicy(TxnDBWritePolicy writePolicy) {
        assert (this.isOwningHandle());
        this.setWritePolicy(this.nativeHandle_, writePolicy.getValue());
        return this;
    }

    private static native long newTransactionDBOptions();

    private native long getMaxNumLocks(long var1);

    private native void setMaxNumLocks(long var1, long var3);

    private native long getNumStripes(long var1);

    private native void setNumStripes(long var1, long var3);

    private native long getTransactionLockTimeout(long var1);

    private native void setTransactionLockTimeout(long var1, long var3);

    private native long getDefaultLockTimeout(long var1);

    private native void setDefaultLockTimeout(long var1, long var3);

    private native byte getWritePolicy(long var1);

    private native void setWritePolicy(long var1, byte var3);

    @Override
    protected final native void disposeInternal(long var1);
}

