/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.authorization;

import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.util.ServiceAnnotationUtils;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

abstract class AnnotatedPermissionCheckerBase<T extends Annotation> {
    private final Class<T> annotationClass;
    protected ResourceInfo resourceInfo;
    protected UriInfo uriInfo;
    protected ITeamscaleServiceInfo serviceInfo;

    protected AnnotatedPermissionCheckerBase(Class<T> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void check(ResourceInfo resourceInfo, UriInfo uriInfo, ITeamscaleServiceInfo serviceInfo) throws StorageException {
        this.resourceInfo = resourceInfo;
        this.uriInfo = uriInfo;
        this.serviceInfo = serviceInfo;
        Optional annotation = ServiceAnnotationUtils.getMethodAnnotation((ResourceInfo)resourceInfo, this.annotationClass);
        if (annotation.isPresent()) {
            this.checkPermission((Annotation)annotation.get());
        }
    }

    protected abstract void checkPermission(T var1) throws StorageException;

    protected List<String> getPathOrQueryParameters(String pathParameterName, String queryParameterName) {
        CCSMAssert.isTrue((boolean)(pathParameterName.isEmpty() ^ queryParameterName.isEmpty()), (String)"Either a path or a query parameter must be given to check permissions on.");
        if (!pathParameterName.isEmpty()) {
            MultivaluedMap pathParameters = this.uriInfo.getPathParameters();
            if (pathParameters.containsKey((Object)pathParameterName)) {
                return (List)pathParameters.get((Object)pathParameterName);
            }
            throw new InternalServerErrorException("REST endpoint does not contain a " + pathParameterName + " path parameter.");
        }
        MultivaluedMap queryParameters = this.uriInfo.getQueryParameters();
        if (queryParameters.containsKey((Object)queryParameterName)) {
            return (List)queryParameters.get((Object)queryParameterName);
        }
        throw new InternalServerErrorException("REST endpoint does not contain a " + queryParameterName + " query parameter.");
    }
}

