/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class CoverableLineUtils {
    private static final int TOKEN_INCLUSION_THRESHOLD = 3;

    public static Set<Integer> determineLinesFromEntities(ELanguage language, Collection<ShallowEntity> entities) {
        HashSet<Integer> lines = new HashSet<Integer>();
        for (ShallowEntity entity : entities) {
            UnmodifiableList tokens;
            int colonIndex;
            if (ShallowParsingUtils.isCppConstructor((ELanguage)language, (ShallowEntity)entity) && (colonIndex = TokenStreamUtils.firstTokenMatching((List)(tokens = entity.ownStartTokens()), (ITokenMatcher)ETokenType.COLON)) != -1) {
                CoverableLineUtils.addLines(tokens.subList(colonIndex + 1, tokens.size()), lines);
                continue;
            }
            if (CoverableLineUtils.shouldFullyCoverEntities(language)) {
                CoverableLineUtils.addAllLines(entity, lines);
                continue;
            }
            if (entity.getChildren().isEmpty()) {
                CoverableLineUtils.addLines((List<IToken>)entity.includedTokens(), lines);
                continue;
            }
            UnmodifiableList startTokens = entity.ownStartTokens();
            UnmodifiableList endTokens = entity.ownEndTokens();
            if (startTokens.size() > 3 && endTokens.size() > 3) {
                CoverableLineUtils.addLines((List<IToken>)startTokens, lines);
                CoverableLineUtils.addLines((List<IToken>)endTokens, lines);
                continue;
            }
            if (startTokens.size() >= endTokens.size() || CoverableLineUtils.isEndKeyword((List<IToken>)endTokens)) {
                CoverableLineUtils.addLines((List<IToken>)startTokens, lines);
                continue;
            }
            CoverableLineUtils.addLines((List<IToken>)endTokens, lines);
        }
        return lines;
    }

    private static boolean shouldFullyCoverEntities(ELanguage language) {
        return language == ELanguage.SWIFT;
    }

    private static void addAllLines(ShallowEntity entity, Set<Integer> lines) {
        for (int line = entity.getStartLine(); line <= entity.getEndLine(); ++line) {
            lines.add(line);
        }
    }

    private static boolean isEndKeyword(List<IToken> endTokens) {
        return endTokens.get(0).getText().toLowerCase().startsWith("end");
    }

    private static void addLines(List<IToken> tokens, Set<Integer> lines) {
        int numberOfTokens = tokens.size();
        if (numberOfTokens == 0) {
            return;
        }
        IToken lastLineCalculatedToken = null;
        for (int i = 0; i < numberOfTokens; ++i) {
            String tokenText;
            IToken token = tokens.get(i);
            if (CoverableLineUtils.isSkippedTokenForCoverage(token) || lastLineCalculatedToken != null && i <= numberOfTokens - 2 && token.getLineNumber() == tokens.get(i + 1).getLineNumber() && !CoverableLineUtils.isSkippedTokenForCoverage(tokens.get(i + 1)) || (tokenText = token.getText()) == null) continue;
            int lineCount = StringUtils.countLines((String)tokenText);
            for (int lineOffset = 0; lineOffset < lineCount; ++lineOffset) {
                lines.add(token.getLineNumber() + 1 + lineOffset);
            }
            lastLineCalculatedToken = token;
        }
    }

    private static boolean isSkippedTokenForCoverage(IToken token) {
        return token.getType() == ETokenType.LBRACE || token.getType() == ETokenType.RBRACE || token.getType() == ETokenType.UNSAFE;
    }
}

