/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.util;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.service.framework.versioning.PublicApi;
import jakarta.ws.rs.container.ResourceInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.reflect.ReflectionUtils;

public class ServiceAnnotationUtils {
    public static <T extends Annotation> T getMethodOrClassAnnotation(Class<T> annotationClass, Method method) {
        return (T)ServiceAnnotationUtils.getMethodAnnotation(annotationClass, method).orElseGet(() -> ServiceAnnotationUtils.getClassAnnotation(annotationClass, method.getDeclaringClass()));
    }

    private static <T extends Annotation> T getClassAnnotation(Class<T> annotationClass, Class<?> resourceClass) {
        ArrayList types = new ArrayList();
        types.add(resourceClass);
        types.addAll(ReflectionUtils.getSuperClasses(resourceClass));
        types.addAll(ReflectionUtils.getAllInterfaces(resourceClass));
        for (Class clazz : types) {
            T methodAnnotation = clazz.getAnnotation(annotationClass);
            if (methodAnnotation == null) continue;
            return methodAnnotation;
        }
        return null;
    }

    public static <T extends Annotation> Optional<T> getMethodAnnotation(ResourceInfo resourceInfo, Class<T> annotationClass) {
        return ServiceAnnotationUtils.getMethodAnnotation(annotationClass, resourceInfo.getResourceMethod());
    }

    public static <T extends Annotation> List<T> getMethodAnnotations(ResourceInfo resourceInfo, Class<T> annotationClass) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod == null) {
            return Collections.emptyList();
        }
        return ServiceAnnotationUtils.getMethodAnnotations(annotationClass, resourceMethod);
    }

    public static <T extends Annotation> Optional<T> getMethodAnnotation(Class<T> annotationClass, Method method) {
        return ServiceAnnotationUtils.getMethodAnnotations(annotationClass, method).stream().findFirst();
    }

    private static <T extends Annotation> List<T> getMethodAnnotations(Class<T> annotationClass, Method method) {
        ArrayList<T> methodAnnotations = new ArrayList<T>();
        for (Class<?> type : ServiceAnnotationUtils.getSuperTypes(method)) {
            try {
                Method m = type.getMethod(method.getName(), method.getParameterTypes());
                T methodAnnotation = m.getAnnotation(annotationClass);
                if (methodAnnotation == null) continue;
                methodAnnotations.add(methodAnnotation);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return methodAnnotations;
    }

    public static List<List<Annotation>> getAllParameterAnnotations(Method method) {
        ArrayList parameterAnnotations = CollectionUtils.repeat(i -> new ArrayList(), (int)method.getParameterCount());
        for (Class<?> type : ServiceAnnotationUtils.getSuperTypes(method)) {
            Optional<Method> overriddenMethod = ServiceAnnotationUtils.getOverriddenMethodInType(type, method);
            if (overriddenMethod.isEmpty()) continue;
            for (int i2 = 0; i2 < overriddenMethod.get().getParameterCount(); ++i2) {
                Parameter parameter = overriddenMethod.get().getParameters()[i2];
                List<Annotation> annotations = Arrays.asList(parameter.getAnnotations());
                ((List)parameterAnnotations.get(i2)).addAll(annotations);
            }
        }
        return parameterAnnotations;
    }

    private static List<Class<?>> getSuperTypes(Method method) {
        Class<?> resourceClass = method.getDeclaringClass();
        ArrayList types = new ArrayList();
        types.add(resourceClass);
        types.addAll(ReflectionUtils.getSuperClasses(resourceClass));
        types.addAll(ReflectionUtils.getAllInterfaces(resourceClass));
        return types;
    }

    public static boolean isDeprecated(PublicApi publicApi) {
        return publicApi.deprecatedSince() != ETeamscaleVersion.VERSION_1_0_0;
    }

    private static Optional<Method> getOverriddenMethodInType(Class<?> type, Method method) {
        try {
            return Optional.of(type.getMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }
}

