/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.function.SupplierWithException;

public abstract class IndexBase {
    protected final ConvenientStore store;

    protected IndexBase(IStore store) {
        this.store = new ConvenientStore(store);
    }

    protected IndexBase(IStore store, boolean autoAbbreviateKeys) {
        this.store = new ConvenientStore(store, autoAbbreviateKeys);
    }

    public final <T extends Exception> void runLocked(String suffix, RunnableWithException<T> lockedOperation) throws T {
        this.computeLocked(suffix, () -> {
            lockedOperation.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R, E extends Exception> R computeLocked(String suffix, SupplierWithException<R, E> lockedComputation) throws E {
        Lock lock = this.store.obtainLock(suffix);
        lock.lock();
        try {
            Object object = lockedComputation.get();
            return (R)object;
        }
        finally {
            lock.unlock();
        }
    }
}

