/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.hist;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HeadReadOnlyHistorizingStore;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;

public class HeadInsertingHistorizingStore
extends HeadReadOnlyHistorizingStore {
    private final byte[] timestampSuffix;

    public HeadInsertingHistorizingStore(IStore delegate, long timestamp) {
        super(delegate);
        CCSMAssert.isTrue((timestamp > 0L ? 1 : 0) != 0, (String)"Timestamp must be positive!");
        this.timestampSuffix = ByteArrayUtils.longToByteArray((long)timestamp);
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        PairList keysValues = new PairList(2);
        keysValues.add((Object)HeadInsertingHistorizingStore.revisionKey(key, this.timestampSuffix), (Object)value);
        keysValues.add((Object)HeadInsertingHistorizingStore.headKey(key), (Object)value);
        this.store.put((PairList<byte[], byte[]>)keysValues);
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        PairList newKeysValues = new PairList();
        for (int i = 0; i < keysValues.size(); ++i) {
            newKeysValues.add((Object)HeadInsertingHistorizingStore.revisionKey((byte[])keysValues.getFirst(i), this.timestampSuffix), (Object)((byte[])keysValues.getSecond(i)));
            newKeysValues.add((Object)HeadInsertingHistorizingStore.headKey((byte[])keysValues.getFirst(i)), (Object)((byte[])keysValues.getSecond(i)));
        }
        this.store.put((PairList<byte[], byte[]>)newKeysValues);
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        this.store.remove(HeadInsertingHistorizingStore.headKey(key));
        this.store.put(HeadInsertingHistorizingStore.revisionKey(key, this.timestampSuffix), DELETION_MARKER);
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        this.store.remove(HeadInsertingHistorizingStore.headKeyList(keys));
        PairList deletionMarkers = new PairList();
        for (byte[] key : keys) {
            deletionMarkers.add((Object)HeadInsertingHistorizingStore.revisionKey(key, this.timestampSuffix), (Object)DELETION_MARKER);
        }
        this.store.put((PairList<byte[], byte[]>)deletionMarkers);
    }

    @Override
    public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
        this.remove(StorageUtils.listKeysStartingWith(prefix, (IStore)this));
    }
}

