/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;

public class SimulinkEncodedDataUtil
extends SimulinkBlock {
    private static final Charset CHARSET = FileSystemUtils.SYSTEM_CHARSET;

    public static BufferedImage getImage(String data) throws IOException {
        if (StringUtils.isEmpty((String)data)) {
            return null;
        }
        ByteArrayInputStream encodedStream = new ByteArrayInputStream(SimulinkEncodedDataUtil.changeDataToFitUUEncoding(data).getBytes(CHARSET));
        return ImageIO.read(new ByteArrayInputStream(SimulinkEncodedDataUtil.decodeBuffer(encodedStream)));
    }

    public static String getText(String data) {
        if (StringUtils.isEmpty((String)data)) {
            return null;
        }
        ByteArrayInputStream encodedStream = new ByteArrayInputStream(SimulinkEncodedDataUtil.changeDataToFitUUEncoding(data).getBytes(CHARSET));
        Scanner scanner = new Scanner((InputStream)new ByteArrayInputStream(SimulinkEncodedDataUtil.decodeBuffer(encodedStream)), CHARSET);
        scanner.findInLine("B");
        scanner.findInLine("B");
        String text = scanner.findInLine("[\\w\\s]+");
        scanner.close();
        return text;
    }

    private static String changeDataToFitUUEncoding(String data) {
        String transformed = data.replace(" ", "`");
        transformed = transformed.replaceAll(Pattern.quote("\\\\"), Matcher.quoteReplacement("\\"));
        transformed = transformed.replaceAll(Pattern.quote("\\\""), "\"");
        return transformed;
    }

    private static byte[] decodeBuffer(InputStream inputStream) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            SimulinkEncodedDataUtil.decodeBuffer(inputStream, bos);
        }
        catch (IOException e) {
            throw new AssertionError("This can not happen as we work in memory!", e);
        }
        return bos.toByteArray();
    }

    private static void decodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] decoderBuffer = new byte[4];
        while (true) {
            int[] decodedBytes = new int[3];
            for (int i = 0; i < 4; ++i) {
                int readCharacter = inputStream.read();
                if (readCharacter == -1) {
                    return;
                }
                decoderBuffer[i] = (byte)(readCharacter - 32 & 0x3F);
            }
            decodedBytes[0] = decoderBuffer[0] << 2 & 0xFC | decoderBuffer[1] >>> 4 & 3;
            decodedBytes[1] = decoderBuffer[1] << 4 & 0xF0 | decoderBuffer[2] >>> 2 & 0xF;
            decodedBytes[2] = decoderBuffer[2] << 6 & 0xC0 | decoderBuffer[3] & 0x3F;
            outputStream.write((byte)(decodedBytes[0] & 0xFF));
            outputStream.write((byte)(decodedBytes[1] & 0xFF));
            outputStream.write((byte)(decodedBytes[2] & 0xFF));
        }
    }
}

