/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler.simulink;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.InputStream;
import java.util.Scanner;
import java.util.Set;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkBlockNameUtils {
    private static final String FILE_CONTAINING_DEFAULT_NAMES = "/org/conqat/lib/simulink/model/datahandler/simulink/default_names.csv";
    private static final String FILE_CONTAINING_ADDITIONAL_LIBRARY_EXPLORER_NAMES = "/org/conqat/lib/simulink/model/datahandler/simulink/additional_library_explorer_names.csv";
    private static final Multimap<String, String> DEFAULT_NAMES = SimulinkBlockNameUtils.createMultiMapFromCSV("/org/conqat/lib/simulink/model/datahandler/simulink/default_names.csv");
    private static final Multimap<String, String> ADDITIONAL_LIBRARY_EXPLORER_NAMES = SimulinkBlockNameUtils.createMultiMapFromCSV("/org/conqat/lib/simulink/model/datahandler/simulink/additional_library_explorer_names.csv");
    private static final Set<String> DEFAULT_NAMES_REQUIRING_NUMBERS_EXTENSION = ImmutableSet.of((Object)"In", (Object)"Out");
    private static final Set<String> ADDITIONAL_LIBRARY_EXPLORER_NAMES_REQUIRING_NUMBERS_EXTENSION = ImmutableSet.of((Object)"Check", (Object)"Ex", (Object)"Frown", (Object)"Smile", (Object)"Solid Frown", (Object)"Solid Smile", (Object[])new String[0]);

    public static boolean hasDefaultName(SimulinkBlock block) {
        String name = block.getName();
        String type = SimulinkBlockNameUtils.getTypeOrSourceTypeOrStateflowType(block);
        if (type == null || name == null || DEFAULT_NAMES_REQUIRING_NUMBERS_EXTENSION.contains(name)) {
            return false;
        }
        if (type.equals("Math") && name.equals("Power of 10")) {
            return true;
        }
        String strippedName = SimulinkBlockNameUtils.getStrippedName(name);
        return strippedName.equals(type) || DEFAULT_NAMES.get((Object)type).contains(strippedName);
    }

    public static boolean hasNameUsedByLibraryExplorer(SimulinkBlock block) {
        String name = block.getName();
        String type = SimulinkBlockNameUtils.getTypeOrSourceTypeOrStateflowType(block);
        if (type == null || name == null || ADDITIONAL_LIBRARY_EXPLORER_NAMES_REQUIRING_NUMBERS_EXTENSION.contains(name)) {
            return false;
        }
        String strippedName = SimulinkBlockNameUtils.getStrippedName(name);
        return SimulinkBlockNameUtils.hasDefaultName(block) || ADDITIONAL_LIBRARY_EXPLORER_NAMES.get((Object)type).contains(strippedName);
    }

    private static Multimap<String, String> createMultiMapFromCSV(String fileName) {
        ArrayListMultimap alternativeNames = ArrayListMultimap.create();
        InputStream resource = SimulinkBlockNameUtils.class.getResourceAsStream(fileName);
        assert (resource != null);
        try (Scanner scanner = new Scanner(resource, "UTF-8");){
            while (scanner.hasNextLine()) {
                Scanner rowScanner = new Scanner(scanner.nextLine());
                rowScanner.useDelimiter(";");
                String key = rowScanner.next();
                while (rowScanner.hasNext()) {
                    alternativeNames.put((Object)key, (Object)rowScanner.next().trim());
                }
            }
        }
        return alternativeNames;
    }

    private static String getStrippedName(String name) {
        return name.replace("\\n", " ").replaceFirst("([0-9]+)$", "");
    }

    public static String getTypeOrSourceTypeOrStateflowType(SimulinkBlock block) {
        String stateflowBlockType;
        String type = block.getType();
        if ("Reference".equals(type)) {
            return block.getSourceType();
        }
        if (SimulinkUtils.isSubsystem(block) && (stateflowBlockType = block.getStateflowBlockType()) != null && !stateflowBlockType.equals("NONE")) {
            return stateflowBlockType;
        }
        return type;
    }
}

