/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler.simulink;

import java.awt.Color;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.datahandler.ESimulinkColor;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.util.SimulinkUtils;

class SimulinkColorUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    SimulinkColorUtils() {
    }

    public static Color extractColor(SimulinkElementBase element, String parameter, Color defaultColor) {
        return SimulinkColorUtils.extractColor(element, element.getId(), parameter, defaultColor);
    }

    public static Color extractColor(StateflowChart chart, String parameter, Color defaultColor) {
        return SimulinkColorUtils.extractColor(chart, chart.getStateflowId(), parameter, defaultColor);
    }

    private static Color extractColor(ParameterizedElement element, String elementId, String parameter, Color defaultColor) {
        String colorString = element.getParameter(parameter);
        if (colorString == null || "automatic".equals(colorString)) {
            return defaultColor;
        }
        if (colorString.startsWith("[")) {
            return SimulinkColorUtils.parseArrayColor(elementId, colorString, defaultColor);
        }
        return SimulinkColorUtils.parsePredefinedColor(elementId, colorString, defaultColor);
    }

    private static Color parseArrayColor(String elementId, String colorString, Color defaultColor) {
        try {
            double[] colorArray = SimulinkUtils.getDoubleParameterArray(colorString);
            if (colorArray.length != 3) {
                LOGGER.error("Unsupported color array found in element " + elementId + " (length = " + colorArray.length + " instead of 3). Using default color.");
                return defaultColor;
            }
            return new Color((float)colorArray[0], (float)colorArray[1], (float)colorArray[2]);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Color array in element " + elementId + " contained invalid number: " + colorString + ". Using default color.");
            return defaultColor;
        }
    }

    private static Color parsePredefinedColor(String elementId, String colorString, Color defaultColor) {
        ESimulinkColor simulinkColor = (ESimulinkColor)EnumUtils.valueOfIgnoreCase(ESimulinkColor.class, (String)colorString);
        if (simulinkColor == null) {
            LOGGER.error("Unsupported color string found in element " + elementId + " (" + colorString + "). Using default color.");
            return defaultColor;
        }
        return simulinkColor.getColor();
    }
}

